/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.monitors.JDBCMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCStoredProcedureMonitor
extends JDBCMonitor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus checkDatabaseStatus(Connection con, Map<String, Object> parameters) {
        PollStatus status = PollStatus.unavailable();
        CallableStatement cs = null;
        try {
            boolean bPass = false;
            String storedProcedure = ParameterMap.getKeyedString(parameters, (String)"stored-procedure", null);
            if (storedProcedure == null) {
                PollStatus pollStatus = status;
                return pollStatus;
            }
            String schemaName = ParameterMap.getKeyedString(parameters, (String)"schema", (String)"test");
            String procedureCall = "{ ? = call " + schemaName + "." + storedProcedure + "()}";
            cs = con.prepareCall(procedureCall);
            this.log().debug("Calling stored procedure: " + procedureCall);
            cs.registerOutParameter(1, -7);
            cs.executeUpdate();
            bPass = cs.getBoolean(1);
            this.log().debug("Stored procedure returned: " + bPass);
            if (bPass) {
                status = PollStatus.available();
            }
            this.closeStmt(cs);
        }
        catch (SQLException sqlEx) {
            status = this.logDown(Level.DEBUG, "JDBC stored procedure call not functional: " + sqlEx.getSQLState() + ", " + sqlEx.toString(), sqlEx);
        }
        finally {
            this.closeStmt(cs);
        }
        return status;
    }
}

