/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.poller.IfKey;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.SingleResultQuerier;
import org.opennms.netmgt.utils.Updater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueryManager
implements QueryManager {
    static final String SQL_RETRIEVE_INTERFACES = "SELECT nodeid,ipaddr FROM ifServices, service WHERE ifServices.serviceid = service.serviceid AND service.servicename = ? AND ifServices.status='A'";
    static final String SQL_RETRIEVE_SERVICE_IDS = "SELECT serviceid,servicename  FROM service";
    static final String SQL_RETRIEVE_SERVICE_STATUS = "SELECT ifregainedservice,iflostservice FROM outages WHERE nodeid = ? AND ipaddr = ? AND serviceid = ? AND iflostservice = (SELECT max(iflostservice) FROM outages WHERE nodeid = ? AND ipaddr = ? AND serviceid = ?)";
    static final String SQL_COUNT_IFSERVICE_STATUS = "select count(*) FROM ifServices, service WHERE nodeid=? AND ipaddr=? AND status='A' AND ifServices.serviceid=service.serviceid AND service.servicename=?";
    static final String SQL_COUNT_IFSERVICES_TO_POLL = "SELECT COUNT(*) FROM ifservices WHERE status = 'A' AND ipaddr = ?";
    static final String SQL_FETCH_IFSERVICES_TO_POLL = "SELECT if.serviceid FROM ifservices if, service s WHERE if.serviceid = s.serviceid AND if.status = 'A' AND if.ipaddr = ?";
    static final String SQL_FETCH_INTERFACES_AND_SERVICES_ON_NODE = "SELECT ipaddr,servicename FROM ifservices,service WHERE nodeid= ? AND ifservices.serviceid=service.serviceid";
    private DataSource m_dataSource;

    @Override
    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    @Override
    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    private Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activeServiceExists(String whichEvent, int nodeId, String ipAddr, String serviceName) {
        ThreadCategory log = this.log();
        Connection dbConn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = this.getConnection();
            d.watch((Object)dbConn);
            stmt = dbConn.prepareStatement(SQL_COUNT_IFSERVICE_STATUS);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, serviceName);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                boolean bl = rs.getInt(1) > 0;
                return bl;
            }
            if (log.isDebugEnabled()) {
                log.debug(whichEvent + nodeId + "/" + ipAddr + "/" + serviceName + " active");
            }
        }
        catch (SQLException sqlE) {
            log.error("SQLException during check to see if nodeid/ip/service is active", (Throwable)sqlE);
        }
        finally {
            d.cleanUp();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getActiveServiceIdsForInterface(String ipaddr) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        Connection dbConn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getConnection();
            d.watch((Object)dbConn);
            ArrayList<Integer> serviceIds = new ArrayList<Integer>();
            ThreadCategory log = this.log();
            stmt = dbConn.prepareStatement(SQL_FETCH_IFSERVICES_TO_POLL);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (log.isDebugEnabled()) {
                log.debug("restartPollingInterfaceHandler: retrieve active service to poll on interface: " + ipaddr);
            }
            while (rs.next()) {
                serviceIds.add(rs.getInt(1));
            }
            ArrayList<Integer> arrayList = serviceIds;
            return arrayList;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodeIDForInterface(String ipaddr) throws SQLException {
        ThreadCategory log = this.log();
        int nodeid = -1;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = this.getConnection();
            d.watch((Object)dbConn);
            stmt = dbConn.createStatement();
            d.watch((Object)stmt);
            String sql = "SELECT node.nodeid FROM node, ipinterface WHERE ipinterface.ipaddr='" + ipaddr + "' AND ipinterface.nodeid=node.nodeid";
            rs = stmt.executeQuery(sql);
            d.watch((Object)rs);
            if (rs.next()) {
                nodeid = rs.getInt(1);
                if (log.isDebugEnabled()) {
                    log.debug("getNodeLabel: ipaddr=" + ipaddr + " nodeid=" + nodeid);
                }
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeLabel(int nodeId) throws SQLException {
        ThreadCategory log = this.log();
        String nodeLabel = null;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = this.getConnection();
            d.watch((Object)dbConn);
            stmt = dbConn.createStatement();
            d.watch((Object)stmt);
            rs = stmt.executeQuery("SELECT nodelabel FROM node WHERE nodeid=" + String.valueOf(nodeId));
            d.watch((Object)rs);
            if (rs.next()) {
                nodeLabel = rs.getString("nodelabel");
                if (log.isDebugEnabled()) {
                    log.debug("getNodeLabel: nodeid=" + nodeId + " nodelabel=" + nodeLabel);
                }
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getServiceCountForInterface(String ipaddr) throws SQLException {
        ThreadCategory log = this.log();
        Connection dbConn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        int count = -1;
        try {
            dbConn = this.getConnection();
            d.watch((Object)dbConn);
            stmt = dbConn.prepareStatement(SQL_COUNT_IFSERVICES_TO_POLL);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                count = rs.getInt(1);
                if (!log.isDebugEnabled()) continue;
                log.debug("restartPollingInterfaceHandler: count active ifservices to poll for interface: " + ipaddr);
            }
        }
        finally {
            d.cleanUp();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IfKey> getInterfacesWithService(String svcName) throws SQLException {
        ArrayList<IfKey> ifkeys = new ArrayList<IfKey>();
        ThreadCategory log = this.log();
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            if (log.isDebugEnabled()) {
                log.debug("scheduleExistingInterfaces: dbConn = " + dbConn + ", svcName = " + svcName);
            }
            PreparedStatement stmt = dbConn.prepareStatement(SQL_RETRIEVE_INTERFACES);
            d.watch((Object)stmt);
            stmt.setString(1, svcName);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                IfKey key = new IfKey(rs.getInt(1), rs.getString(2));
                ifkeys.add(key);
            }
        }
        finally {
            d.cleanUp();
        }
        return ifkeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getServiceLostDate(int nodeId, String ipAddr, String svcName, int serviceId) {
        ThreadCategory log = ThreadCategory.getInstance(Poller.class);
        log.debug("getting last known status for address: " + ipAddr + " service: " + svcName);
        Date svcLostDate = null;
        if (serviceId < 0) {
            log.warn("Failed to retrieve service identifier for interface " + ipAddr + " and service '" + svcName + "'");
            return svcLostDate;
        }
        PreparedStatement outagesQuery = null;
        ResultSet outagesResult = null;
        Timestamp regainedDate = null;
        Timestamp lostDate = null;
        Connection dbConn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = this.getConnection();
            d.watch((Object)dbConn);
            outagesQuery = dbConn.prepareStatement(SQL_RETRIEVE_SERVICE_STATUS);
            d.watch((Object)outagesQuery);
            outagesQuery.setInt(1, nodeId);
            outagesQuery.setString(2, ipAddr);
            outagesQuery.setInt(3, serviceId);
            outagesQuery.setInt(4, nodeId);
            outagesQuery.setString(5, ipAddr);
            outagesQuery.setInt(6, serviceId);
            outagesResult = outagesQuery.executeQuery();
            d.watch((Object)outagesResult);
            if (outagesResult.next()) {
                regainedDate = outagesResult.getTimestamp(1);
                lostDate = outagesResult.getTimestamp(2);
                log.debug("getServiceLastKnownStatus: lostDate: " + lostDate);
            } else {
                Date currentDate = new Date(System.currentTimeMillis());
                regainedDate = new Timestamp(currentDate.getTime());
                lostDate = new Timestamp(currentDate.getTime());
            }
        }
        catch (SQLException sqlE) {
            log.error("SQL exception while retrieving last known service status for " + ipAddr + "/" + svcName);
        }
        finally {
            d.cleanUp();
        }
        if (lostDate != null && regainedDate == null) {
            svcLostDate = new Date(lostDate.getTime());
            log.debug("getServiceLastKnownStatus: svcLostDate: " + svcLostDate);
        }
        return svcLostDate;
    }

    public Timestamp convertEventTimeToTimeStamp(String time) {
        try {
            Date date = EventConstants.parseToDate((String)time);
            Timestamp eventTime = new Timestamp(date.getTime());
            return eventTime;
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date format " + time, e);
        }
    }

    @Override
    public void openOutage(String outageIdSQL, int nodeId, String ipAddr, String svcName, int dbId, String time) {
        boolean notUpdated = true;
        int serviceId = this.getServiceID(svcName);
        for (int attempt = 0; attempt < 2 && notUpdated; ++attempt) {
            try {
                this.log().info("openOutage: opening outage for " + nodeId + ":" + ipAddr + ":" + svcName + " with cause " + dbId + ":" + time);
                SingleResultQuerier srq = new SingleResultQuerier(this.getDataSource(), outageIdSQL);
                srq.execute(new Object[0]);
                Object outageId = srq.getResult();
                if (outageId == null) {
                    throw new Exception("Null outageId returned from Querier with SQL: " + outageIdSQL);
                }
                String sql = "insert into outages (outageId, svcLostEventId, nodeId, ipAddr, serviceId, ifLostService) values (" + outageId + ", ?, ?, ?, ?, ?)";
                Object[] values = new Object[]{new Integer(dbId), new Integer(nodeId), ipAddr, new Integer(serviceId), this.convertEventTimeToTimeStamp(time)};
                Updater updater = new Updater(this.getDataSource(), sql);
                updater.execute(values);
                notUpdated = false;
                continue;
            }
            catch (Exception e) {
                if (attempt > 1) {
                    this.log().fatal("openOutage: Second and final attempt failed opening outage for " + nodeId + ":" + ipAddr + ":" + svcName, (Throwable)e);
                    continue;
                }
                this.log().info("openOutage: First attempt failed opening outage for " + nodeId + ":" + ipAddr + ":" + svcName, (Throwable)e);
            }
        }
    }

    @Override
    public void resolveOutage(int nodeId, String ipAddr, String svcName, int dbId, String time) {
        boolean notUpdated = true;
        for (int attempt = 0; attempt < 2 && notUpdated; ++attempt) {
            try {
                this.log().info("resolving outage for " + nodeId + ":" + ipAddr + ":" + svcName + " with resolution " + dbId + ":" + time);
                int serviceId = this.getServiceID(svcName);
                String sql = "update outages set svcRegainedEventId=?, ifRegainedService=? where nodeId = ? and ipAddr = ? and serviceId = ? and ifRegainedService is null";
                Object[] values = new Object[]{new Integer(dbId), this.convertEventTimeToTimeStamp(time), new Integer(nodeId), ipAddr, new Integer(serviceId)};
                Updater updater = new Updater(this.getDataSource(), sql);
                updater.execute(values);
                notUpdated = false;
                continue;
            }
            catch (Exception e) {
                if (attempt > 1) {
                    this.log().fatal("resolveOutage: Second and final attempt failed resolving outage for " + nodeId + ":" + ipAddr + ":" + svcName, (Throwable)e);
                    continue;
                }
                this.log().info("resolveOutage: first attempt failed resolving outage for " + nodeId + ":" + ipAddr + ":" + svcName, (Throwable)e);
            }
        }
    }

    @Override
    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        try {
            this.log().info("reparenting outages for " + oldNodeId + ":" + ipAddr + " to new node " + newNodeId);
            String sql = "update outages set nodeId = ? where nodeId = ? and ipaddr = ?";
            Object[] values = new Object[]{new Integer(newNodeId), new Integer(oldNodeId), ipAddr};
            Updater updater = new Updater(this.getDataSource(), sql);
            updater.execute(values);
        }
        catch (Exception e) {
            this.log().fatal(" Error reparenting outage for " + oldNodeId + ":" + ipAddr + " to " + newNodeId, (Throwable)e);
        }
    }

    public int getServiceID(String serviceName) {
        if (serviceName == null) {
            return -1;
        }
        SingleResultQuerier querier = new SingleResultQuerier(this.getDataSource(), "select serviceId from service where serviceName = ?");
        querier.execute(serviceName);
        Integer result = (Integer)querier.getResult();
        return result == null ? -1 : result;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public String[] getCriticalPath(int nodeId) {
        final String[] cpath = new String[2];
        Querier querier = new Querier(this.getDataSource(), "SELECT criticalpathip, criticalpathservicename FROM pathoutage where nodeid=?"){

            public void processRow(ResultSet rs) throws SQLException {
                cpath[0] = rs.getString(1);
                cpath[1] = rs.getString(2);
            }
        };
        querier.execute(nodeId);
        if (cpath[0] == null || cpath[0].equals("")) {
            cpath[0] = OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathIp();
            cpath[1] = "ICMP";
        }
        if (cpath[1] == null || cpath[1].equals("")) {
            cpath[1] = "ICMP";
        }
        return cpath;
    }

    @Override
    public List<String[]> getNodeServices(int nodeId) {
        final LinkedList<String[]> servicemap = new LinkedList<String[]>();
        Querier querier = new Querier(this.getDataSource(), SQL_FETCH_INTERFACES_AND_SERVICES_ON_NODE){

            public void processRow(ResultSet rs) throws SQLException {
                String[] row = new String[]{rs.getString(1), rs.getString(2)};
                servicemap.add(row);
            }
        };
        querier.execute(nodeId);
        return servicemap;
    }
}

