/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Enumeration;
import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventUtils {
    public static void addEventListener(EventListener listener, List<String> ueiList) {
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(listener, ueiList);
    }

    public static void checkEventId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasDbid()) {
            throw new InsufficientInformationException("eventID is unavailable");
        }
    }

    public static void checkInterface(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getInterface() == null || e.getInterface().length() == 0) {
            throw new InsufficientInformationException("ipaddr for event is unavailable");
        }
    }

    public static boolean isNonIpInterface(String intf) {
        return intf == null || intf.length() == 0 || "0.0.0.0".equals(intf);
    }

    public static void checkInterfaceOrIfIndex(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!(e.getInterface() != null && e.getInterface().length() != 0 || e.hasIfIndex())) {
            throw new InsufficientInformationException("Both ipaddr and ifIndex for event are unavailable");
        }
    }

    public static void checkHost(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getHost() == null || e.getHost().length() == 0) {
            throw new InsufficientInformationException("host for event is unavailable");
        }
    }

    public static void checkNodeId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasNodeid()) {
            throw new InsufficientInformationException("nodeid for event is unavailable");
        }
    }

    public static void checkService(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getService() == null || e.getService().length() == 0) {
            throw new InsufficientInformationException("service for event is unavailable");
        }
    }

    public static long getEventID(Event e) {
        long eventID = -1L;
        if (e.hasDbid()) {
            eventID = e.getDbid();
        }
        return eventID;
    }

    public static long getLongParm(Event e, String parmName, long defaultValue) {
        String longVal = EventUtils.getParm(e, parmName);
        if (longVal == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(longVal);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static long getNodeId(Event e) {
        long nodeID = -1L;
        if (e.hasNodeid()) {
            nodeID = e.getNodeid();
        }
        return nodeID;
    }

    public static String getParm(Event e, String parmName) {
        return EventUtils.getParm(e, parmName, null);
    }

    public static String getParm(Event e, String parmName, String defaultValue) {
        Parms parms = e.getParms();
        if (parms == null) {
            return defaultValue;
        }
        Enumeration parmEnum = parms.enumerateParm();
        while (parmEnum.hasMoreElements()) {
            Parm parm = (Parm)parmEnum.nextElement();
            if (!parmName.equals(parm.getParmName())) continue;
            if (parm.getValue() != null && parm.getValue().getContent() != null) {
                return parm.getValue().getContent();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static void requireParm(Event e, String parmName) throws InsufficientInformationException {
        Parms parms = e.getParms();
        if (parms == null) {
            throw new InsufficientInformationException("parameter " + parmName + " required but but no parms are available.");
        }
        Enumeration parmEnum = parms.enumerateParm();
        while (parmEnum.hasMoreElements()) {
            Parm parm = (Parm)parmEnum.nextElement();
            if (!parmName.equals(parm.getParmName())) continue;
            if (parm.getValue() != null && parm.getValue().getContent() != null) {
                return;
            }
            throw new InsufficientInformationException("parameter " + parmName + " required but only null valued parms available");
        }
        throw new InsufficientInformationException("parameter " + parmName + " required but was not available");
    }

    public static void sendEvent(Event newEvent, String callerUei, long txNo, boolean isXmlRpcEnabled) {
        block2: {
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
                LogUtils.debugf(EventUtils.class, (String)"sendEvent: successfully sent event %s", (Object[])new Object[]{newEvent});
            }
            catch (Throwable t) {
                LogUtils.warnf(EventUtils.class, (Throwable)t, (String)"run: unexpected throwable exception caught during send to middleware", (Object[])new Object[0]);
                if (!isXmlRpcEnabled) break block2;
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, callerUei, "caught unexpected throwable exception.", status, "OpenNMS.Capsd");
            }
        }
    }
}

