/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.Vlan;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.FdbTableGet;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscoveryLink
implements ReadyRunnable {
    private static final int SNMP_IF_TYPE_ETHERNET = 6;
    private static final int SNMP_IF_TYPE_PROP_VIRTUAL = 53;
    private static final int SNMP_IF_TYPE_L2_VLAN = 135;
    private static final int SNMP_IF_TYPE_L3_VLAN = 136;
    private String packageName;
    private List<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
    private List<MacToNodeLink> maclinks = new ArrayList<MacToNodeLink>();
    private HashMap<Integer, LinkableNode> bridgeNodes = new HashMap();
    private List<LinkableNode> routerNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> cdpNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> atNodes = new ArrayList<LinkableNode>();
    private List<String> macsParsed = new ArrayList<String>();
    private List<String> macsExcluded = new ArrayList<String>();
    private Map<String, List<AtInterface>> macToAtinterface = new HashMap<String, List<AtInterface>>();
    private boolean enableDownloadDiscovery = false;
    private boolean discoveryUsingRoutes = true;
    private boolean discoveryUsingCdp = true;
    private boolean discoveryUsingBridge = true;
    private boolean suspendCollection = false;
    private boolean isRunned = false;
    private boolean forceIpRouteDiscoveryOnEtherNet = false;
    private Scheduler m_scheduler;
    private long snmp_poll_interval = 1800000L;
    private long discovery_interval = 300000L;
    private long initial_sleep_time = 600000L;
    private Linkd m_linkd;

    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    public Linkd getLinkd() {
        return this.m_linkd;
    }

    @Override
    public void run() {
        if (this.suspendCollection) {
            LogUtils.warnf((Object)this, (String)"DiscoveryLink.run: Suspended!", (Object[])new Object[0]);
        } else {
            Iterator<Object> sub_ite;
            Collection<LinkableNode> all_snmplinknodes = this.m_linkd.getLinkableNodesOnPackage(this.getPackageName());
            LogUtils.debugf((Object)this, (String)"run: LinkableNodes/package found: %d/%s", (Object[])new Object[]{all_snmplinknodes.size(), this.getPackageName()});
            LogUtils.debugf((Object)this, (String)"run: discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes: %b/%b/%b", (Object[])new Object[]{this.discoveryUsingBridge, this.discoveryUsingCdp, this.discoveryUsingRoutes});
            LogUtils.debugf((Object)this, (String)"run: enableDownloadDiscovery: %b", (Object[])new Object[]{this.enableDownloadDiscovery});
            for (LinkableNode curNode : all_snmplinknodes) {
                LogUtils.debugf((Object)this, (String)"run: Iterating on LinkableNode's found node: %d", (Object[])new Object[]{curNode.getNodeId()});
                if (curNode == null) {
                    LogUtils.errorf((Object)this, (String)"run: null linkable node found", (Object[])new Object[0]);
                    continue;
                }
                if (curNode.isBridgeNode && this.discoveryUsingBridge) {
                    this.bridgeNodes.put(new Integer(curNode.getNodeId()), curNode);
                }
                if (curNode.hasCdpInterfaces() && this.discoveryUsingCdp) {
                    this.cdpNodes.add(curNode);
                }
                if (curNode.hasRouteInterfaces() && this.discoveryUsingRoutes) {
                    this.routerNodes.add(curNode);
                }
                if (!curNode.hasAtInterfaces()) continue;
                this.atNodes.add(curNode);
            }
            LogUtils.debugf((Object)this, (String)"run: using atNodes to populate macToAtinterface", (Object[])new Object[0]);
            Iterator<LinkableNode> ite = this.atNodes.iterator();
            while (ite.hasNext()) {
                for (AtInterface at : ite.next().getAtInterfaces()) {
                    int nodeid = at.getNodeId();
                    String ipaddr = at.getIpAddress();
                    String macAddress = at.getMacAddress();
                    LogUtils.debugf((Object)this, (String)"Parsing at Interface nodeid/ipaddr/macaddr: %d/%s/%s", (Object[])new Object[]{nodeid, ipaddr, macAddress});
                    if (!this.m_linkd.isInterfaceInPackage(at.getIpAddress(), this.getPackageName())) {
                        LogUtils.infof((Object)this, (String)"run: at interface: %s does not belong to package: %s! Not adding to discoverable atinterface.", (Object[])new Object[]{ipaddr, this.getPackageName()});
                        this.macsExcluded.add(macAddress);
                        continue;
                    }
                    if (this.isMacIdentifierOfBridgeNode(macAddress)) {
                        LogUtils.infof((Object)this, (String)"run: at interface %s belongs to bridge node! Not adding to discoverable atinterface.", (Object[])new Object[]{macAddress});
                        this.macsExcluded.add(macAddress);
                        continue;
                    }
                    if (macAddress.indexOf("00000c07ac") == 0) {
                        LogUtils.infof((Object)this, (String)"run: at interface %s is cisco hsrp address! Not adding to discoverable atinterface.", (Object[])new Object[]{macAddress});
                        this.macsExcluded.add(macAddress);
                        continue;
                    }
                    List<AtInterface> ats = this.macToAtinterface.get(macAddress);
                    if (ats == null) {
                        ats = new ArrayList<AtInterface>();
                    }
                    LogUtils.infof((Object)this, (String)"parseAtNodes: Adding to discoverable atinterface.", (Object[])new Object[0]);
                    ats.add(at);
                    this.macToAtinterface.put(macAddress, ats);
                    LogUtils.debugf((Object)this, (String)"parseAtNodes: mac: %s now has atinterface reference: %d", (Object[])new Object[]{macAddress, ats.size()});
                }
            }
            LogUtils.debugf((Object)this, (String)"run: end populate macToAtinterface", (Object[])new Object[0]);
            if (this.enableDownloadDiscovery) {
                LogUtils.infof((Object)this, (String)"run: get further unknown mac address snmp bridge table info", (Object[])new Object[0]);
                this.snmpParseBridgeNodes();
            } else {
                LogUtils.infof((Object)this, (String)"run: skipping get further unknown mac address snmp bridge table info", (Object[])new Object[0]);
            }
            LogUtils.debugf((Object)this, (String)"run: finding links among nodes using Cisco Discovery Protocol", (Object[])new Object[0]);
            for (LinkableNode curNode : this.cdpNodes) {
                int curCdpNodeId = curNode.getNodeId();
                String curCdpIpAddr = curNode.getSnmpPrimaryIpAddr();
                LogUtils.debugf((Object)this, (String)"run: parsing nodeid %d ip address %s with %d Cdp interfaces.", (Object[])new Object[]{curCdpNodeId, curCdpIpAddr, curNode.getCdpInterfaces().size()});
                for (CdpInterface cdpIface : curNode.getCdpInterfaces()) {
                    LinkableNode targetNode;
                    int cdpIfIndex = cdpIface.getCdpIfIndex();
                    if (cdpIfIndex < 0) {
                        LogUtils.warnf((Object)this, (String)"run: found not valid CDP IfIndex %d.  Skipping.", (Object[])new Object[]{cdpIfIndex});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: found CDP ifindex %d", (Object[])new Object[]{cdpIfIndex});
                    InetAddress targetIpAddr = cdpIface.getCdpTargetIpAddr();
                    if (!this.m_linkd.isInterfaceInPackage(targetIpAddr.getHostAddress(), this.getPackageName())) {
                        LogUtils.warnf((Object)this, (String)"run: ip address %s Not in package: %s.  Skipping.", (Object[])new Object[]{targetIpAddr.getHostAddress(), this.getPackageName()});
                        continue;
                    }
                    int targetCdpNodeId = cdpIface.getCdpTargetNodeId();
                    if (targetCdpNodeId == -1) {
                        LogUtils.warnf((Object)this, (String)"run: no node id found for ip address %s.  Skipping.", (Object[])new Object[]{targetIpAddr.getHostAddress()});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: found nodeid/CDP target ipaddress: %d:%s", (Object[])new Object[]{targetCdpNodeId, targetIpAddr});
                    if (targetCdpNodeId == curCdpNodeId) {
                        LogUtils.debugf((Object)this, (String)"run: node id found for ip address %s is itself.  Skipping.", (Object[])new Object[]{targetIpAddr.getHostAddress()});
                        continue;
                    }
                    int cdpDestIfindex = cdpIface.getCdpTargetIfIndex();
                    if (cdpDestIfindex < 0) {
                        LogUtils.warnf((Object)this, (String)"run: found not valid CDP destination IfIndex %d.  Skipping.", (Object[])new Object[]{cdpDestIfindex});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: found CDP target ifindex %d", (Object[])new Object[]{cdpDestIfindex});
                    LogUtils.debugf((Object)this, (String)"run: parsing CDP link: nodeid=%d ifindex=%d nodeparentid=%d parentifindex=%d", (Object[])new Object[]{curCdpNodeId, cdpIfIndex, targetCdpNodeId, cdpDestIfindex});
                    boolean add = false;
                    if (curNode.isBridgeNode() && this.isBridgeNode(targetCdpNodeId)) {
                        targetNode = this.bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetNode, cdpDestIfindex);
                        LogUtils.debugf((Object)this, (String)"run: both node are bridge nodes! Adding: %b", (Object[])new Object[]{add});
                    } else if (curNode.isBridgeNode) {
                        LogUtils.debugf((Object)this, (String)"run: source node is bridge node, target node is not bridge node! Adding: %b", (Object[])new Object[]{add});
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetCdpNodeId);
                    } else if (this.isBridgeNode(targetCdpNodeId)) {
                        LogUtils.debugf((Object)this, (String)"run: source node is not bridge node, target node is bridge node! Adding: %b", (Object[])new Object[]{add});
                        targetNode = this.bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(targetNode, cdpDestIfindex, curCdpNodeId);
                    } else {
                        LogUtils.debugf((Object)this, (String)"run: no node is bridge node! Adding CDP link", (Object[])new Object[0]);
                        add = true;
                    }
                    if (!add) continue;
                    NodeToNodeLink lk = new NodeToNodeLink(targetCdpNodeId, cdpDestIfindex);
                    lk.setNodeparentid(curCdpNodeId);
                    lk.setParentifindex(cdpIfIndex);
                    this.addNodetoNodeLink(lk);
                    LogUtils.debugf((Object)this, (String)"run: CDP link added: %s", (Object[])new Object[]{lk.toString()});
                }
            }
            LogUtils.debugf((Object)this, (String)"run: try to found backbone ethernet links among bridge nodes using Spanning Tree Protocol", (Object[])new Object[0]);
            for (LinkableNode curNode : this.bridgeNodes.values()) {
                int curNodeId = curNode.getNodeId();
                String cupIpAddr = curNode.getSnmpPrimaryIpAddr();
                LogUtils.debugf((Object)this, (String)"run: parsing bridge nodeid %d ip address %s", (Object[])new Object[]{curNodeId, cupIpAddr});
                sub_ite = curNode.getStpInterfaces().entrySet().iterator();
                LogUtils.debugf((Object)this, (String)"run: parsing %d Vlan.", (Object[])new Object[]{curNode.getStpInterfaces().size()});
                while (sub_ite.hasNext()) {
                    Map.Entry me = (Map.Entry)sub_ite.next();
                    String vlan = (String)me.getKey();
                    String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                    LogUtils.debugf((Object)this, (String)"run: found bridge identifier %s", (Object[])new Object[]{curBaseBridgeAddress});
                    String designatedRoot = null;
                    if (!curNode.hasStpRoot(vlan)) {
                        LogUtils.debugf((Object)this, (String)"run: desigated root bridge identifier not found. Skipping %s", (Object[])new Object[]{curBaseBridgeAddress});
                        continue;
                    }
                    designatedRoot = curNode.getStpRoot(vlan);
                    if (designatedRoot == null || designatedRoot.equals("0000000000000000")) {
                        LogUtils.warnf((Object)this, (String)"run: designated root is invalid. Skipping", (Object[])new Object[0]);
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                        LogUtils.debugf((Object)this, (String)"run: STP designated root is the bridge itself. Skipping", (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: STP designated root is another bridge. %s Parsing Stp Interface", (Object[])new Object[]{designatedRoot});
                    for (BridgeStpInterface stpIface : (List)me.getValue()) {
                        int stpbridgeport = stpIface.getBridgeport();
                        if (curNode.isBackBoneBridgePort(stpbridgeport)) {
                            LogUtils.debugf((Object)this, (String)"run: bridge port %d already found.  Skipping.", (Object[])new Object[]{stpbridgeport});
                            continue;
                        }
                        String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                        String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                        LogUtils.debugf((Object)this, (String)"run: parsing bridge port %d with stp designated bridge %s and stp designated port %s", (Object[])new Object[]{stpbridgeport, stpPortDesignatedBridge, stpPortDesignatedPort});
                        if (stpPortDesignatedBridge == null || stpPortDesignatedBridge.equals("0000000000000000") || stpPortDesignatedBridge.equals("")) {
                            LogUtils.warnf((Object)this, (String)"run: designated bridge is invalid: %s", (Object[])new Object[]{stpPortDesignatedBridge});
                            continue;
                        }
                        if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                            LogUtils.debugf((Object)this, (String)"run: designated bridge for port %d is bridge itself", (Object[])new Object[]{stpbridgeport});
                            continue;
                        }
                        if (stpPortDesignatedPort == null || stpPortDesignatedPort.equals("0000")) {
                            LogUtils.warnf((Object)this, (String)"run: designated port is invalid: %s", (Object[])new Object[]{stpPortDesignatedPort});
                            continue;
                        }
                        int designatedbridgeport = Integer.parseInt(stpPortDesignatedPort.substring(1), 16);
                        LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(stpPortDesignatedBridge.substring(4));
                        if (designatedNode == null) {
                            LogUtils.warnf((Object)this, (String)"run: no nodeid found for stp bridge address %s.  Nothing to save.", (Object[])new Object[]{stpPortDesignatedBridge});
                            continue;
                        }
                        int designatednodeid = designatedNode.getNodeId();
                        LogUtils.debugf((Object)this, (String)"run: found designated nodeid %d", (Object[])new Object[]{designatednodeid});
                        if (!this.isNearestBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport)) {
                            LogUtils.debugf((Object)this, (String)"run: other bridge found between nodes. No links to save!", (Object[])new Object[0]);
                            continue;
                        }
                        int curIfIndex = curNode.getIfindex(stpbridgeport);
                        if (curIfIndex == -1) {
                            LogUtils.warnf((Object)this, (String)"run: got invalid ifindex", (Object[])new Object[0]);
                            continue;
                        }
                        int designatedifindex = designatedNode.getIfindex(designatedbridgeport);
                        if (designatedifindex == -1) {
                            LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on designated node", (Object[])new Object[0]);
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d.  Adding to bridge %d.", (Object[])new Object[]{curNodeId, stpbridgeport});
                        curNode.addBackBoneBridgePorts(stpbridgeport);
                        this.bridgeNodes.put(new Integer(curNodeId), curNode);
                        LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d.  Adding to helper class BB port bridge port %d.", (Object[])new Object[]{designatednodeid, designatedbridgeport});
                        designatedNode.addBackBoneBridgePorts(designatedbridgeport);
                        this.bridgeNodes.put(new Integer(designatednodeid), designatedNode);
                        LogUtils.debugf((Object)this, (String)"run: adding links on BB bridge port %d", (Object[])new Object[]{designatedbridgeport});
                        this.addLinks(this.getMacsOnBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport), curNodeId, curIfIndex);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(designatednodeid);
                        lk.setParentifindex(designatedifindex);
                        this.addNodetoNodeLink(lk);
                    }
                }
            }
            LogUtils.debugf((Object)this, (String)"run: try to found links using Mac Address Forwarding Table", (Object[])new Object[0]);
            for (LinkableNode curNode : this.bridgeNodes.values()) {
                int curNodeId = curNode.getNodeId();
                LogUtils.debugf((Object)this, (String)"run: parsing node bridge %d", (Object[])new Object[]{curNodeId});
                block9: for (Integer intePort : curNode.getPortMacs().keySet()) {
                    int curBridgePort = intePort;
                    LogUtils.debugf((Object)this, (String)"run: parsing bridge port %d with mac address %s", (Object[])new Object[]{curBridgePort, curNode.getMacAddressesOnBridgePort(curBridgePort).toString()});
                    if (curNode.isBackBoneBridgePort(curBridgePort)) {
                        LogUtils.debugf((Object)this, (String)"run: parsing backbone bridge port %d.  Skipping.", (Object[])new Object[]{curBridgePort});
                        continue;
                    }
                    int curIfIndex = curNode.getIfindex(curBridgePort);
                    if (curIfIndex == -1) {
                        LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on bridge port %d", (Object[])new Object[]{curBridgePort});
                        continue;
                    }
                    Set<String> macs = curNode.getMacAddressesOnBridgePort(curBridgePort);
                    List<LinkableNode> bridgesOnPort = this.getBridgesFromMacs(macs);
                    if (bridgesOnPort.isEmpty()) {
                        LogUtils.debugf((Object)this, (String)"run: no bridge info found on port %d.  Saving MACs.", (Object[])new Object[]{curBridgePort});
                        this.addLinks(macs, curNodeId, curIfIndex);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: bridge info found on port %d.  Finding nearest.", (Object[])new Object[]{curBridgePort});
                    for (LinkableNode endNode : bridgesOnPort) {
                        int endNodeid = endNode.getNodeId();
                        int endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                        if (endBridgePort == -1) {
                            LogUtils.errorf((Object)this, (String)"run: no valid port found on bridge nodeid %d for node bridge identifiers nodeid %d.  Skipping.", (Object[])new Object[]{endNodeid, curNodeId});
                            continue;
                        }
                        boolean isTargetNode = this.isNearestBridgeLink(curNode, curBridgePort, endNode, endBridgePort);
                        if (!isTargetNode) continue;
                        int endIfindex = endNode.getIfindex(endBridgePort);
                        if (endIfindex == -1) {
                            LogUtils.warnf((Object)this, (String)("run: got invalid ifindex o designated bridge port " + endBridgePort), (Object[])new Object[0]);
                            continue block9;
                        }
                        LogUtils.debugf((Object)this, (String)("run: backbone port found for node " + curNodeId + ". Adding backbone port " + curBridgePort + " to bridge"), (Object[])new Object[0]);
                        curNode.addBackBoneBridgePorts(curBridgePort);
                        this.bridgeNodes.put(curNodeId, curNode);
                        LogUtils.debugf((Object)this, (String)("run: backbone port found for node " + endNodeid + " .Adding to helper class bb port " + " bridge port " + endBridgePort), (Object[])new Object[0]);
                        endNode.addBackBoneBridgePorts(endBridgePort);
                        this.bridgeNodes.put(endNodeid, endNode);
                        this.addLinks(this.getMacsOnBridgeLink(curNode, curBridgePort, endNode, endBridgePort), curNodeId, curIfIndex);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(endNodeid);
                        lk.setParentifindex(endIfindex);
                        this.addNodetoNodeLink(lk);
                        continue block9;
                    }
                }
            }
            LogUtils.debugf((Object)this, (String)"run: try to found  not ethernet links on Router nodes", (Object[])new Object[0]);
            for (LinkableNode curNode : this.routerNodes) {
                int curNodeId = curNode.getNodeId();
                String curIpAddr = curNode.getSnmpPrimaryIpAddr();
                LogUtils.debugf((Object)this, (String)("run: parsing router nodeid " + curNodeId + " ip address " + curIpAddr), (Object[])new Object[0]);
                sub_ite = curNode.getRouteInterfaces().iterator();
                LogUtils.debugf((Object)this, (String)("run: parsing " + curNode.getRouteInterfaces().size() + " Route Interface. "), (Object[])new Object[0]);
                while (sub_ite.hasNext()) {
                    RouterInterface routeIface = (RouterInterface)sub_ite.next();
                    LogUtils.debugf((Object)this, (String)("run: parsing RouterInterface: " + routeIface.toString()), (Object[])new Object[0]);
                    if (routeIface.getMetric() == -1) {
                        LogUtils.infof((Object)this, (String)("run: Router interface has invalid metric " + routeIface.getMetric() + ". Skipping"), (Object[])new Object[0]);
                        continue;
                    }
                    if (this.forceIpRouteDiscoveryOnEtherNet) {
                        LogUtils.infof((Object)this, (String)"run: force ip route discovery not getting SnmpIfType", (Object[])new Object[0]);
                    } else {
                        int snmpiftype = routeIface.getSnmpiftype();
                        LogUtils.infof((Object)this, (String)("run: force ip route discovery getting SnmpIfType: " + snmpiftype), (Object[])new Object[0]);
                        if (snmpiftype == 6) {
                            LogUtils.infof((Object)this, (String)"run: Ethernet interface for nodeid. Skipping ", (Object[])new Object[0]);
                            continue;
                        }
                        if (snmpiftype == 53) {
                            LogUtils.infof((Object)this, (String)"run: PropVirtual interface for nodeid. Skipping ", (Object[])new Object[0]);
                            continue;
                        }
                        if (snmpiftype == 135) {
                            LogUtils.infof((Object)this, (String)"run: Layer2 Vlan interface for nodeid. Skipping ", (Object[])new Object[0]);
                            continue;
                        }
                        if (snmpiftype == 136) {
                            LogUtils.infof((Object)this, (String)"run: Layer3 Vlan interface for nodeid. Skipping ", (Object[])new Object[0]);
                            continue;
                        }
                        if (snmpiftype == -1) {
                            LogUtils.infof((Object)this, (String)("store: interface has unknown snmpiftype " + snmpiftype + " . Skipping "), (Object[])new Object[0]);
                            continue;
                        }
                    }
                    InetAddress nexthop = routeIface.getNextHop();
                    if (nexthop.getHostAddress().equals("0.0.0.0")) {
                        LogUtils.infof((Object)this, (String)("run: nexthop address is broadcast address " + nexthop.getHostAddress() + " . Skipping "), (Object[])new Object[0]);
                        continue;
                    }
                    if (nexthop.isLoopbackAddress()) {
                        LogUtils.infof((Object)this, (String)("run: nexthop address is localhost address " + nexthop.getHostAddress() + " . Skipping "), (Object[])new Object[0]);
                        continue;
                    }
                    if (!this.m_linkd.isInterfaceInPackage(nexthop.getHostAddress(), this.getPackageName())) {
                        LogUtils.infof((Object)this, (String)("run: nexthop address is not in package " + nexthop.getHostAddress() + "/" + this.getPackageName() + " . Skipping "), (Object[])new Object[0]);
                        continue;
                    }
                    int nextHopNodeid = routeIface.getNextHopNodeid();
                    if (nextHopNodeid == -1) {
                        LogUtils.infof((Object)this, (String)("run: no node id found for ip next hop address " + nexthop.getHostAddress() + " , skipping "), (Object[])new Object[0]);
                        continue;
                    }
                    if (nextHopNodeid == curNodeId) {
                        LogUtils.debugf((Object)this, (String)("run: node id found for ip next hop address " + nexthop.getHostAddress() + " is itself, skipping "), (Object[])new Object[0]);
                        continue;
                    }
                    int ifindex = routeIface.getIfindex();
                    if (ifindex == 0) {
                        LogUtils.infof((Object)this, (String)("run: route interface has ifindex " + ifindex + " . trying to get ifindex from nextHopNet: " + routeIface.getNextHopNet()), (Object[])new Object[0]);
                        ifindex = this.getIfIndexFromRouter(curNode, routeIface.getNextHopNet());
                        if (ifindex == -1) {
                            LogUtils.debugf((Object)this, (String)("run: found not correct ifindex " + ifindex + " skipping."), (Object[])new Object[0]);
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)("run: found correct ifindex " + ifindex + " ."), (Object[])new Object[0]);
                    }
                    LogUtils.debugf((Object)this, (String)"run: saving route link", (Object[])new Object[0]);
                    NodeToNodeLink lk = new NodeToNodeLink(nextHopNodeid, routeIface.getNextHopIfindex());
                    lk.setNodeparentid(curNodeId);
                    lk.setParentifindex(ifindex);
                    this.addNodetoNodeLink(lk);
                }
            }
            this.bridgeNodes.clear();
            this.routerNodes.clear();
            this.cdpNodes.clear();
            this.macsParsed.clear();
            this.macsExcluded.clear();
            this.macToAtinterface.clear();
            this.atNodes.clear();
            this.m_linkd.updateDiscoveryLinkCollection(this);
            this.links.clear();
            this.maclinks.clear();
        }
        this.isRunned = true;
        this.reschedule();
    }

    private int getIfIndexFromRouter(LinkableNode parentnode, InetAddress nextHopNet) {
        if (!parentnode.hasRouteInterfaces()) {
            return -1;
        }
        for (RouterInterface curIface : parentnode.getRouteInterfaces()) {
            int ifindex;
            if (curIface.getMetric() == -1 || (ifindex = curIface.getIfindex()) == 0 || ifindex == -1 || !curIface.getRouteNet().equals(nextHopNet)) continue;
            return ifindex;
        }
        return -1;
    }

    boolean isBridgeNode(int nodeid) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isRouterNode(int nodeid) {
        for (LinkableNode curNode : this.routerNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isCdpNode(int nodeid) {
        for (LinkableNode curNode : this.cdpNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isEndBridgePort(LinkableNode bridge, int bridgeport) {
        Set<String> macsOnBridge = bridge.getMacAddressesOnBridgePort(bridgeport);
        if (macsOnBridge == null || macsOnBridge.isEmpty()) {
            return true;
        }
        for (String macaddr : macsOnBridge) {
            if (!this.isMacIdentifierOfBridgeNode(macaddr)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        boolean hasbridge2forwardingRule = false;
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return false;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return false;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1)) {
                hasbridge2forwardingRule = true;
                continue;
            }
            if (bridge1.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            return false;
        }
        return hasbridge2forwardingRule;
    }

    private Set<String> getMacsOnBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        HashSet<String> macsOnLink = new HashSet<String>();
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return null;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return null;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1)) continue;
            macsOnLink.add(curMacOnBridge1);
        }
        return macsOnLink;
    }

    private boolean isMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return true;
        }
        return false;
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    private List<LinkableNode> getBridgesFromMacs(Set<String> macs) {
        ArrayList<LinkableNode> bridges = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            for (String curBridgeIdentifier : curNode.getBridgeIdentifiers()) {
                if (!macs.contains(curBridgeIdentifier)) continue;
                bridges.add(curNode);
            }
        }
        return bridges;
    }

    private int getBridgePortOnEndBridge(LinkableNode startBridge, LinkableNode endBridge) {
        int port = -1;
        for (String curBridgeIdentifier : startBridge.getBridgeIdentifiers()) {
            LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: parsing bridge identifier " + curBridgeIdentifier), (Object[])new Object[0]);
            if (endBridge.hasMacAddress(curBridgeIdentifier)) {
                for (Integer p : endBridge.getBridgePortsFromMac(curBridgeIdentifier)) {
                    port = p;
                    if (endBridge.isBackBoneBridgePort(port)) {
                        LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: found backbone bridge port " + port + " .... Skipping"), (Object[])new Object[0]);
                        continue;
                    }
                    if (port == -1) {
                        LogUtils.debugf((Object)this, (String)("run: no port found on bridge nodeid " + endBridge.getNodeId() + " for node bridge identifiers nodeid " + startBridge.getNodeId() + " . .....Skipping"), (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("run: using mac address table found bridge port " + port + " on node " + endBridge.getNodeId()), (Object[])new Object[0]);
                    return port;
                }
                continue;
            }
            LogUtils.debugf((Object)this, (String)("run: bridge identifier not found on node " + endBridge.getNodeId()), (Object[])new Object[0]);
        }
        return -1;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval + this.discovery_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval, this);
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public long getDiscoveryInterval() {
        return this.discovery_interval;
    }

    public void setSnmpPollInterval(long interval) {
        this.snmp_poll_interval = interval;
    }

    public long getSnmpPollInterval() {
        return this.snmp_poll_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_interval = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.links.toArray(new NodeToNodeLink[0]);
    }

    public MacToNodeLink[] getMacLinks() {
        return this.maclinks.toArray(new MacToNodeLink[0]);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.isRunned) {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval + this.initial_sleep_time + this.discovery_interval);
        }
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, int nodeid2) {
        int bridgeport = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport)) {
            LogUtils.debugf((Object)this, (String)("parseCdpLinkOn: node/backbone bridge port " + node1.getNodeId() + "/" + bridgeport + " already parsed. Skipping"), (Object[])new Object[0]);
            return false;
        }
        if (!this.isEndBridgePort(node1, bridgeport)) {
            LogUtils.warnf((Object)this, (String)"parseCdpLinkOn: link cannot be saved. Skipping", (Object[])new Object[0]);
            return false;
        }
        node1.addBackBoneBridgePorts(bridgeport);
        this.bridgeNodes.put(node1.getNodeId(), node1);
        Set<String> macs = node1.getMacAddressesOnBridgePort(bridgeport);
        this.addLinks(macs, node1.getNodeId(), ifindex1);
        return true;
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, LinkableNode node2, int ifindex2) {
        int bridgeport1 = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport1)) {
            LogUtils.debugf((Object)this, (String)("parseCdpLinkOn: backbone bridge port " + bridgeport1 + " already parsed. Skipping"), (Object[])new Object[0]);
            return false;
        }
        int bridgeport2 = node2.getBridgePort(ifindex2);
        if (node2.isBackBoneBridgePort(bridgeport2)) {
            LogUtils.debugf((Object)this, (String)("parseCdpLinkOn: backbone bridge port " + bridgeport2 + " already parsed. Skipping"), (Object[])new Object[0]);
            return false;
        }
        if (!this.isNearestBridgeLink(node1, bridgeport1, node2, bridgeport2)) {
            LogUtils.debugf((Object)this, (String)"parseCdpLinkOn: link found not on nearest. Skipping", (Object[])new Object[0]);
            return false;
        }
        node1.addBackBoneBridgePorts(bridgeport1);
        this.bridgeNodes.put(node1.getNodeId(), node1);
        node2.addBackBoneBridgePorts(bridgeport2);
        this.bridgeNodes.put(node2.getNodeId(), node2);
        LogUtils.debugf((Object)this, (String)"parseCdpLinkOn: Adding node on links.", (Object[])new Object[0]);
        this.addLinks(this.getMacsOnBridgeLink(node1, bridgeport1, node2, bridgeport2), node1.getNodeId(), ifindex1);
        return true;
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink) {
        if (nnlink == null) {
            LogUtils.warnf((Object)this, (String)"addNodetoNodeLink: node link is null.", (Object[])new Object[0]);
            return;
        }
        if (!this.links.isEmpty()) {
            for (NodeToNodeLink curNnLink : this.links) {
                if (!curNnLink.equals(nnlink)) continue;
                LogUtils.infof((Object)this, (String)"addNodetoNodeLink: link %s exists, not adding", (Object[])new Object[]{nnlink.toString()});
                return;
            }
        }
        LogUtils.debugf((Object)this, (String)"addNodetoNodeLink: adding link %s", (Object[])new Object[]{nnlink.toString()});
        this.links.add(nnlink);
    }

    private void addLinks(Set<String> macs, int nodeid, int ifindex) {
        if (macs == null || macs.isEmpty()) {
            LogUtils.debugf((Object)this, (String)"addLinks: mac's list on link is empty.", (Object[])new Object[0]);
        } else {
            for (String curMacAddress : macs) {
                if (this.macsParsed.contains(curMacAddress)) {
                    LogUtils.warnf((Object)this, (String)("addLinks: mac address " + curMacAddress + " just found on other bridge port! Skipping..."), (Object[])new Object[0]);
                    continue;
                }
                if (this.macsExcluded.contains(curMacAddress)) {
                    LogUtils.warnf((Object)this, (String)("addLinks: mac address " + curMacAddress + " is excluded from discovery package! Skipping..."), (Object[])new Object[0]);
                    continue;
                }
                if (this.macToAtinterface.containsKey(curMacAddress)) {
                    List<AtInterface> ats = this.macToAtinterface.get(curMacAddress);
                    for (AtInterface at : ats) {
                        NodeToNodeLink lNode = new NodeToNodeLink(at.getNodeId(), at.getIfindex());
                        lNode.setNodeparentid(nodeid);
                        lNode.setParentifindex(ifindex);
                        this.addNodetoNodeLink(lNode);
                    }
                } else {
                    LogUtils.debugf((Object)this, (String)"addLinks: not find nodeid for ethernet mac address %s found on node/ifindex %d/%d", (Object[])new Object[]{curMacAddress, nodeid, ifindex});
                    MacToNodeLink lMac = new MacToNodeLink(curMacAddress);
                    lMac.setNodeparentid(nodeid);
                    lMac.setParentifindex(ifindex);
                    this.maclinks.add(lMac);
                }
                this.macsParsed.add(curMacAddress);
            }
        }
    }

    @Override
    public boolean equals(ReadyRunnable r) {
        return r instanceof DiscoveryLink && this.getPackageName().equals(r.getPackageName());
    }

    @Override
    public String getInfo() {
        return " Ready Runnable Discovery Link discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes/package: " + this.discoveryUsingBridge() + "/" + this.discoveryUsingCdp() + "/" + this.discoveryUsingRoutes() + "/" + this.getPackageName();
    }

    public boolean discoveryUsingBridge() {
        return this.discoveryUsingBridge;
    }

    public void setDiscoveryUsingBridge(boolean discoveryUsingBridge) {
        this.discoveryUsingBridge = discoveryUsingBridge;
    }

    public boolean discoveryUsingCdp() {
        return this.discoveryUsingCdp;
    }

    public void setDiscoveryUsingCdp(boolean discoveryUsingCdp) {
        this.discoveryUsingCdp = discoveryUsingCdp;
    }

    public boolean discoveryUsingRoutes() {
        return this.discoveryUsingRoutes;
    }

    public void setDiscoveryUsingRoutes(boolean discoveryUsingRoutes) {
        this.discoveryUsingRoutes = discoveryUsingRoutes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void snmpParseBridgeNodes() {
        LogUtils.debugf((Object)this, (String)"parseBridgeNodes: searching bridge port for bridge identifier not yet already found. Iterating on bridge nodes.", (Object[])new Object[0]);
        ArrayList<LinkableNode> bridgenodeschanged = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            LogUtils.debugf((Object)this, (String)"parseBridgeNodes: parsing bridge: %d/%s", (Object[])new Object[]{curNode.getNodeId(), curNode.getSnmpPrimaryIpAddr()});
            List<String> macs = this.getNotAlreadyFoundMacsOnNode(curNode);
            if (macs.isEmpty()) continue;
            SnmpAgentConfig agentConfig = null;
            String className = null;
            boolean useVlan = this.m_linkd.getLinkdConfig().enableVlanDiscovery();
            if (this.m_linkd.getLinkdConfig().getPackage(this.getPackageName()).hasEnableVlanDiscovery()) {
                useVlan = this.m_linkd.getLinkdConfig().getPackage(this.getPackageName()).getEnableVlanDiscovery();
            }
            if (useVlan && this.m_linkd.getLinkdConfig().hasClassName(curNode.getSysoid())) {
                className = this.m_linkd.getLinkdConfig().getVlanClassName(curNode.getSysoid());
            }
            try {
                agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(curNode.getSnmpPrimaryIpAddr()));
            }
            catch (UnknownHostException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"parseBridgeNodes: Failed to load snmp parameter from snmp configuration file.", (Object[])new Object[0]);
                return;
            }
            String community = agentConfig.getReadCommunity();
            for (String mac : macs) {
                LogUtils.debugf((Object)this, (String)"parseBridgeNodes: parsing mac: %s", (Object[])new Object[]{mac});
                if (className != null && (className.equals("org.opennms.netmgt.linkd.snmp.CiscoVlanTable") || className.equals("org.opennms.netmgt.linkd.snmp.IntelVlanTable"))) {
                    for (Vlan vlan : curNode.getVlans()) {
                        if (vlan.getVlanStatus() != 1 || vlan.getVlanType() != 1) {
                            LogUtils.debugf((Object)this, (String)"parseBridgeNodes: skipping vlan: %s", (Object[])new Object[]{vlan.getVlanName()});
                            continue;
                        }
                        agentConfig.setReadCommunity(community + "@" + vlan.getVlanIndex());
                        curNode = this.collectMacAddress(agentConfig, curNode, mac, vlan.getVlanIndex());
                        agentConfig.setReadCommunity(community);
                    }
                    continue;
                }
                int vlan = 1;
                if (useVlan) {
                    vlan = 0;
                }
                curNode = this.collectMacAddress(agentConfig, curNode, mac, vlan);
            }
            bridgenodeschanged.add(curNode);
        }
        for (LinkableNode node : bridgenodeschanged) {
            this.bridgeNodes.put(node.getNodeId(), node);
        }
    }

    private LinkableNode collectMacAddress(SnmpAgentConfig agentConfig, LinkableNode node, String mac, int vlan) {
        FdbTableGet coll = new FdbTableGet(agentConfig, mac);
        LogUtils.infof((Object)this, (String)"collectMacAddress: finding entry in bridge forwarding table for mac on node: %s/%d", (Object[])new Object[]{mac, node.getNodeId()});
        int bridgeport = coll.getBridgePort();
        if (bridgeport > 0 && coll.getBridgePortStatus() == 3) {
            node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
            LogUtils.infof((Object)this, (String)"collectMacAddress: found mac on bridge port: %d", (Object[])new Object[]{bridgeport});
        } else {
            bridgeport = coll.getQBridgePort();
            if (bridgeport > 0 && coll.getQBridgePortStatus() == 3) {
                node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
                LogUtils.infof((Object)this, (String)"collectMacAddress: found mac on bridge port: %d", (Object[])new Object[]{bridgeport});
            } else {
                LogUtils.infof((Object)this, (String)"collectMacAddress: mac not found: %d", (Object[])new Object[]{bridgeport});
            }
        }
        return node;
    }

    private List<String> getNotAlreadyFoundMacsOnNode(LinkableNode node) {
        LogUtils.debugf((Object)this, (String)"Searching Not Yet Found Bridge Identifier Occurrence on Node: %d", (Object[])new Object[]{node.getNodeId()});
        ArrayList<String> macs = new ArrayList<String>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (node.getNodeId() == curNode.getNodeId()) continue;
            for (String curMac : curNode.getBridgeIdentifiers()) {
                if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
                LogUtils.debugf((Object)this, (String)"Found a node/Bridge Identifier %d/%s that was not found in bridge forwarding table for bridge node: %d", (Object[])new Object[]{curNode.getNodeId(), curMac, node.getNodeId()});
                macs.add(curMac);
            }
        }
        LogUtils.debugf((Object)this, (String)"Searching Not Yet Found Mac Address Occurrence on Node: %d", (Object[])new Object[]{node.getNodeId()});
        for (String curMac : this.macToAtinterface.keySet()) {
            if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
            LogUtils.debugf((Object)this, (String)"Found a Mac Address %s that was not found in bridge forwarding table for bridge node: %d", (Object[])new Object[]{curMac, node.getNodeId()});
            macs.add(curMac);
        }
        return macs;
    }

    public boolean isEnableDownloadDiscovery() {
        return this.enableDownloadDiscovery;
    }

    public void setEnableDownloadDiscovery(boolean enableDownloaddiscovery) {
        this.enableDownloadDiscovery = enableDownloaddiscovery;
    }

    public boolean isForceIpRouteDiscoveryOnEtherNet() {
        return this.forceIpRouteDiscoveryOnEtherNet;
    }

    public void setForceIpRouteDiscoveryOnEtherNet(boolean forceIpRouteDiscoveryOnEtherNet) {
        this.forceIpRouteDiscoveryOnEtherNet = forceIpRouteDiscoveryOnEtherNet;
    }
}

