/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.Collection;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.SnmpResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpNodeCollector
extends AggregateTracker {
    private SNMPCollectorEntry m_collectorEntry;
    private String m_primaryIf;
    private SnmpCollectionSet m_collectionSet;

    public SnmpNodeCollector(InetAddress address, Collection<SnmpAttributeType> objList, SnmpCollectionSet collectionSet) {
        super(SnmpAttributeType.getCollectionTrackers(objList));
        this.m_primaryIf = address.getHostAddress();
        this.m_collectionSet = collectionSet;
        this.m_collectorEntry = new SNMPCollectorEntry(objList, this.m_collectionSet);
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public SNMPCollectorEntry getEntry() {
        return this.m_collectorEntry;
    }

    protected void reportGenErr(String msg) {
        this.log().warn("genErr collecting data for node " + this.m_primaryIf + ": " + msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info("noSuchName collecting data for node " + this.m_primaryIf + ": " + msg);
    }

    protected void storeResult(SnmpResult res) {
        this.m_collectorEntry.storeResult(res);
    }

    public SnmpCollectionSet getCollectionSet() {
        return this.m_collectionSet;
    }
}

