/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionAttributeType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnmpAttributeType
implements AttributeDefinition,
CollectionAttributeType {
    private MibObject m_mibObj;
    private String m_collectionName;
    private ResourceType m_resourceType;
    private AttributeGroupType m_groupType;

    protected SnmpAttributeType(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        this.m_resourceType = resourceType;
        this.m_collectionName = collectionName;
        this.m_mibObj = mibObj;
        this.m_groupType = groupType;
    }

    private MibObject getMibObj() {
        return this.m_mibObj;
    }

    protected String getCollectionName() {
        return this.m_collectionName;
    }

    public static List<Collectable> getCollectionTrackers(Collection<SnmpAttributeType> objList) {
        ArrayList<Collectable> trackers = new ArrayList<Collectable>(objList.size());
        for (SnmpAttributeType attrType : objList) {
            trackers.add((Collectable)attrType.getCollectionTracker());
        }
        return trackers;
    }

    private CollectionTracker getCollectionTracker() {
        SnmpInstId[] instances = this.m_resourceType.getCollectionInstances();
        if (instances != null && Boolean.getBoolean("org.opennms.netmgt.collectd.SnmpCollector.limitCollectionToInstances")) {
            return this.getMibObj().getCollectionTracker(instances);
        }
        return this.getMibObj().getCollectionTracker();
    }

    public static SnmpAttributeType create(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        if (NumericAttributeType.supportsType(mibObj.getType())) {
            return new NumericAttributeType(resourceType, collectionName, mibObj, groupType);
        }
        if (StringAttributeType.supportsType(mibObj.getType())) {
            return new StringAttributeType(resourceType, collectionName, mibObj, groupType);
        }
        throw new IllegalArgumentException("No support exists for AttributeType '" + mibObj.getType() + "' for MIB object: " + mibObj);
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }

    @Override
    public AttributeGroupType getGroupType() {
        return this.m_groupType;
    }

    public String getGroupName() {
        return this.m_groupType.getName();
    }

    public String getMaxval() {
        return this.m_mibObj.getMaxval();
    }

    public String getMinval() {
        return this.m_mibObj.getMinval();
    }

    public String getAlias() {
        return this.m_mibObj.getAlias();
    }

    public String getOid() {
        return this.m_mibObj.getOid();
    }

    public String getInstance() {
        return this.m_mibObj.getInstance();
    }

    @Override
    public String getType() {
        return this.m_mibObj.getType();
    }

    SnmpObjId getSnmpObjId() {
        return this.m_mibObj.getSnmpObjId();
    }

    @Override
    public String getName() {
        return this.getAlias();
    }

    @Override
    public abstract void storeAttribute(CollectionAttribute var1, Persister var2);

    public void storeResult(SnmpCollectionSet collectionSet, SNMPCollectorEntry entry, SnmpResult res) {
        this.log().debug("Setting attribute: " + this + ".[" + res.getInstance() + "] = '" + res.getValue() + "'");
        SnmpCollectionResource resource = null;
        resource = this.getAlias().equals("ifAlias") ? this.m_resourceType.findAliasedResource(res.getInstance(), res.getValue().toString()) : this.m_resourceType.findResource(res.getInstance());
        if (resource == null) {
            collectionSet.notifyIfNotFound(this, res);
        } else {
            resource.setAttributeValue(this, res.getValue());
        }
    }

    public String toString() {
        return this.getAlias() + " [" + this.getOid() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SnmpAttributeType) {
            SnmpAttributeType attrType = (SnmpAttributeType)obj;
            return attrType.m_resourceType.equals(this.m_resourceType) && attrType.getAlias().equals(this.getAlias());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getAlias().hashCode();
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getGroupIfType() {
        return this.m_groupType.getIfType();
    }

    public boolean matches(SnmpObjId base, SnmpInstId inst) {
        if (!base.equals((Object)this.getSnmpObjId())) {
            return false;
        }
        if (this.getInstance().equals("ifIndex") || this.m_mibObj.getResourceType() != null) {
            return true;
        }
        return this.getInstance().equals(inst.toString());
    }
}

