/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.LinkedHashMap;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.BasePersister;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdRepository;

public class GroupPersister
extends BasePersister {
    public GroupPersister(ServiceParameters params, RrdRepository repository) {
        super(params, repository);
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            LinkedHashMap<String, String> dsNamesToRrdNames = new LinkedHashMap<String, String>();
            for (CollectionAttribute a : group.getAttributes()) {
                if (!NumericAttributeType.supportsType(a.getType())) continue;
                dsNamesToRrdNames.put(a.getName(), group.getName());
            }
            this.createBuilder(group.getResource(), group.getName(), group.getGroupType().getAttributeTypes());
            File path = group.getResource().getResourceDir(this.getRepository());
            ResourceTypeUtils.updateDsProperties((File)path, dsNamesToRrdNames);
        }
    }

    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

