/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnmpTable<T extends SnmpTableEntry>
extends AggregateTracker {
    private Map<SnmpInstId, T> m_results = new TreeMap<SnmpInstId, T>();
    private InetAddress m_address;
    private String m_tableName;

    protected SnmpTable(InetAddress address, String tableName, NamedSnmpVar[] columns) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(columns));
        this.m_address = address;
        this.m_tableName = tableName;
    }

    protected void storeResult(SnmpResult res) {
        SnmpTableEntry entry = (SnmpTableEntry)((Object)this.m_results.get(res.getInstance()));
        if (entry == null) {
            entry = this.createTableEntry(res.getBase(), res.getInstance(), res.getValue());
            this.m_results.put(res.getInstance(), (T)((Object)entry));
        }
        entry.storeResult(res);
    }

    protected abstract T createTableEntry(SnmpObjId var1, SnmpInstId var2, Object var3);

    public List<T> getEntries() {
        return new ArrayList<T>(this.m_results.values());
    }

    protected void reportGenErr(String msg) {
        this.log().warn("Error retrieving " + this.m_tableName + " from " + this.m_address + ". " + msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info("Error retrieving " + this.m_tableName + " from " + this.m_address + ". " + msg);
    }

    private final ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

