/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TcpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "TCP";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout, RE regex, StringBuffer bannerResult) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug("TcpPlugin: connected to host: " + host + " on port: " + port);
                if (regex == null) {
                    isAServer = true;
                    continue;
                }
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String response = lineRdr.readLine();
                if (regex.match(response)) {
                    if (log.isDebugEnabled()) {
                        log.debug("isServer: matching response=" + response);
                    }
                    isAServer = true;
                    if (bannerResult == null) continue;
                    bannerResult.append(response);
                    continue;
                }
                isAServer = false;
                if (!log.isDebugEnabled()) break;
                log.debug("isServer: NON-matching response=" + response);
                break;
            }
            catch (ConnectException e) {
                log.debug("TcpPlugin: Connection refused to " + host.getHostAddress() + ":" + port);
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                log.info("TcpPlugin: Could not connect to host " + host.getHostAddress() + ", no route to host", (Throwable)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                log.debug("TcpPlugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                log.info("TcpPlugin: An expected I/O exception occured connecting to host " + host.getHostAddress() + " on port " + port, (Throwable)e);
                isAServer = false;
                continue;
            }
            catch (Throwable t) {
                isAServer = false;
                log.warn("TcpPlugin: An undeclared throwable exception was caught connecting to host " + host.getHostAddress() + " on port " + port, t);
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = 0;
        int timeout = 5000;
        int port = -1;
        String banner = null;
        String match = null;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)-1);
            banner = ParameterMap.getKeyedString(qualifiers, (String)"banner", null);
            match = ParameterMap.getKeyedString(qualifiers, (String)"match", null);
        }
        if (port == -1) {
            throw new IllegalArgumentException("The port must be specified when doing TCP discovery");
        }
        try {
            StringBuffer bannerResult = null;
            RE regex = null;
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = new RE(match);
                bannerResult = new StringBuffer();
            } else if (banner != null) {
                regex = new RE(banner);
                bannerResult = new StringBuffer();
            }
            boolean result = this.isServer(address, port, retries, timeout, regex, bannerResult);
            if (result && qualifiers != null && bannerResult != null && bannerResult.length() > 0) {
                qualifiers.put("banner", bannerResult.toString());
            }
            return result;
        }
        catch (RESyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

