/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.spring.xmlrpc;

import java.io.IOException;
import org.apache.xmlrpc.WebServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.spring.xmlrpc.XmlRpcProxyFactoryBean;
import org.opennms.spring.xmlrpc.XmlRpcServiceExporter;
import org.opennms.spring.xmlrpc.XmlRpcWebServerFactoryBean;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.remoting.RemoteAccessException;

public class XmlRpcTest {
    private WebServer m_webServer;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        XmlRpcWebServerFactoryBean wsf = new XmlRpcWebServerFactoryBean();
        wsf.setPort(9192);
        wsf.setSecure(false);
        wsf.afterPropertiesSet();
        this.m_webServer = (WebServer)wsf.getObject();
    }

    @After
    public void tearDown() {
        this.m_webServer.shutdown();
    }

    @Test
    public void testXmlRpcProxyFactoryBeanAndServiceExporter() throws Throwable {
        TestBean target = new TestBean("myname", 99);
        XmlRpcServiceExporter exporter = new XmlRpcServiceExporter();
        exporter.setServiceInterface(ITestBean.class);
        exporter.setService((Object)target);
        exporter.setWebServer(this.m_webServer);
        exporter.afterPropertiesSet();
        XmlRpcProxyFactoryBean pfb = new XmlRpcProxyFactoryBean();
        pfb.setServiceInterface(ITestBean.class);
        pfb.setServiceUrl("http://localhost:9192/RPC2");
        pfb.afterPropertiesSet();
        ITestBean proxy = (ITestBean)pfb.getObject();
        Assert.assertEquals((Object)"myname", (Object)proxy.getName());
        Assert.assertEquals((long)99L, (long)proxy.getAge());
        proxy.setAge(50);
        Assert.assertEquals((long)50L, (long)proxy.getAge());
    }

    @Test
    @Ignore(value="We're not set up for HTTPS for these tests.")
    public void testXmlRpcProxyFactoryBeanAndServiceExporterWithHttps() throws Throwable {
        TestBean target = new TestBean("myname", 99);
        XmlRpcServiceExporter exporter = new XmlRpcServiceExporter();
        exporter.setServiceInterface(ITestBean.class);
        exporter.setService((Object)target);
        exporter.setWebServer(this.m_webServer);
        exporter.afterPropertiesSet();
        XmlRpcProxyFactoryBean pfb = new XmlRpcProxyFactoryBean();
        pfb.setServiceInterface(ITestBean.class);
        pfb.setServiceUrl("https://localhost:9192/RPC2");
        pfb.afterPropertiesSet();
        ITestBean proxy = (ITestBean)pfb.getObject();
        Assert.assertEquals((Object)"myname", (Object)proxy.getName());
        Assert.assertEquals((long)99L, (long)proxy.getAge());
        proxy.setAge(50);
        Assert.assertEquals((long)50L, (long)proxy.getAge());
    }

    @Test
    @Ignore(value="If you're using OpenDNS, myurl gives an IP address")
    public void testXmlRpcProxyFactoryBeanAndServiceExporterWithIOException() throws Exception {
        TestBean target = new TestBean("myname", 99);
        XmlRpcServiceExporter exporter = new XmlRpcServiceExporter();
        exporter.setServiceInterface(ITestBean.class);
        exporter.setService((Object)target);
        exporter.setWebServer(this.m_webServer);
        exporter.afterPropertiesSet();
        XmlRpcProxyFactoryBean pfb = new XmlRpcProxyFactoryBean();
        pfb.setServiceInterface(ITestBean.class);
        pfb.setServiceUrl("http://127.0.0.1:9191/RPC2");
        pfb.afterPropertiesSet();
        ITestBean proxy = (ITestBean)pfb.getObject();
        try {
            proxy.setAge(50);
            Assert.fail((String)"Should have thrown RemoteAccessException");
        }
        catch (RemoteAccessException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IOException));
        }
    }

    static class TestBean
    implements ITestBean {
        private String name;
        private int age;

        TestBean(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }

    public static interface ITestBean {
        public String getName();

        public int getAge();

        public void setAge(int var1);
    }
}

