/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xmlrpcd.XmlRpcNotifierTest;
import org.opennms.netmgt.xmlrpcd.XmlrpcAnticipator;
import org.opennms.netmgt.xmlrpcd.Xmlrpcd;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.MockLogAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlrpcdTest
extends OpenNMSTestCase {
    private static final int m_port1 = 9000;
    private static final int m_port2 = 9001;
    private Xmlrpcd m_xmlrpcd;
    private XmlrpcAnticipator m_anticipator1;
    private XmlrpcAnticipator m_anticipator2;
    StringReader m_config = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9000\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeUp\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeDown\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/interfaceUp\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/interfaceDown\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configTwo = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9000\" />\n  <xmlrpc-server url=\"http://localhost:9001\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configParallelSame = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9000\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9001\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configParallelDifferent = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9000\" />\n  <serverSubscription>baseEvents1</serverSubscription>\n </external-servers>\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9001\" />\n  <serverSubscription>baseEvents2</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents1\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n </subscription>\n <subscription name=\"baseEvents2\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configGeneric = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\" generic-msgs=\"true\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9000\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n  <subscribed-event uei=\"uei.opennms.org/default/trap\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configBad = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:9000\" />\n  <serverSubscription>baseEventsBlah</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_serverConfig = new StringReader("<local-server server-name=\"nms1\" verify-server=\"false\">\n</local-server>\n");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_anticipator1 = new XmlrpcAnticipator(9000, false);
        OpennmsServerConfigFactory.setInstance((OpennmsServerConfigFactory)new OpennmsServerConfigFactory((Reader)this.m_serverConfig));
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_config));
        this.m_xmlrpcd = new Xmlrpcd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishUp() {
        if (this.m_anticipator1 != null) {
            this.m_anticipator1.verifyAnticipated();
        }
        if (this.m_anticipator2 != null) {
            this.m_anticipator2.verifyAnticipated();
        }
        try {
            MockLogAppender.assertNoWarningsOrGreater();
        }
        finally {
            MockLogAppender.resetEvents();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.m_anticipator1 != null) {
            this.m_anticipator1.shutdown();
        }
        if (this.m_anticipator2 != null) {
            this.m_anticipator2.shutdown();
        }
        super.tearDown();
    }

    public void anticipateNotifyReceivedEvent(XmlrpcAnticipator anticipator) {
        anticipator.anticipateCall("notifyReceivedEvent", this.createVector("0", "uei.opennms.org/internal/capsd/xmlrpcNotification", "test connection"));
    }

    @Override
    public void testDoNothing() {
        super.testDoNothing();
        this.finishUp();
    }

    public void testStart() throws Exception {
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        this.finishUp();
    }

    public void testQueueing() throws Exception {
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createRouterVector(date));
        Event nodeOneEvent = new Event();
        nodeOneEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        nodeOneEvent.setTime(date);
        nodeOneEvent.setNodeid(1L);
        nodeOneEvent.setSource("the one true event source");
        nodeOneEvent.setInterface("192.168.1.1");
        nodeOneEvent.setService("ICMP");
        this.getEventIpcManager().sendNow(nodeOneEvent);
        Thread.sleep(1000L);
        this.m_anticipator1.verifyAnticipated();
        this.m_anticipator1.shutdown();
        Event nodeTwoEvent = new Event();
        nodeTwoEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        nodeTwoEvent.setTime(date);
        nodeTwoEvent.setNodeid(2L);
        nodeTwoEvent.setSource("the one true event source");
        nodeTwoEvent.setInterface("192.168.1.2");
        nodeTwoEvent.setService("SNMP");
        this.getEventIpcManager().sendNow(nodeTwoEvent);
        Thread.sleep(1000L);
        this.m_anticipator1 = new XmlrpcAnticipator(9000, true);
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createServerVector(date));
        this.m_anticipator1.setupWebServer();
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        LoggingEvent[] errors = MockLogAppender.getEventsGreaterOrEqual((Level)Level.ERROR);
        MockLogAppender.resetEvents();
        if (errors.length == 0) {
            XmlrpcdTest.fail((String)"No errors received by log4j, however some errors should have been received while the XML-RPCanticipator was down");
        }
        for (int i = 0; i < errors.length; ++i) {
            String message = errors[i].getMessage().toString();
            if ("Failed to send message to XMLRPC server: http://localhost:9000".equals(message) || "Could not successfully communicate with XMLRPC server 'http://localhost:9000' after 1 tries".equals(message) || "Can not set up communication with any XMLRPC server".equals(message)) continue;
            XmlrpcdTest.fail((String)("Unexpected error logged: [" + errors[i].getLevel().toString() + "] " + errors[i].getLoggerName() + ": " + errors[i].getMessage()));
        }
        MockLogAppender.resetEvents();
        this.finishUp();
    }

    public void testSerialFailover() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configTwo));
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(9001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createRouterVector(date));
        Event nodeOneEvent = new Event();
        nodeOneEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        nodeOneEvent.setTime(date);
        nodeOneEvent.setNodeid(1L);
        nodeOneEvent.setSource("the one true event source");
        nodeOneEvent.setInterface("192.168.1.1");
        nodeOneEvent.setService("ICMP");
        this.getEventIpcManager().sendNow(nodeOneEvent);
        Thread.sleep(1000L);
        this.m_anticipator1.verifyAnticipated();
        this.m_anticipator1.shutdown();
        this.m_anticipator2.anticipateCall("sendServiceDownEvent", this.createServerVector(date));
        Event nodeTwoEvent = new Event();
        nodeTwoEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        nodeTwoEvent.setTime(date);
        nodeTwoEvent.setNodeid(2L);
        nodeTwoEvent.setSource("the one true event source");
        nodeTwoEvent.setInterface("192.168.1.2");
        nodeTwoEvent.setService("SNMP");
        this.getEventIpcManager().sendNow(nodeTwoEvent);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        LoggingEvent[] errors = MockLogAppender.getEventsGreaterOrEqual((Level)Level.ERROR);
        MockLogAppender.resetEvents();
        if (errors.length == 0) {
            XmlrpcdTest.fail((String)"No errors received by log4j, however some errors should have been received while the XML-RPCanticipator was down");
        }
        for (int i = 0; i < errors.length; ++i) {
            String message = errors[i].getMessage().toString();
            if ("Failed to send message to XMLRPC server: http://localhost:9000".equals(message) || "Could not successfully communicate with XMLRPC server 'http://localhost:9000' after 1 tries".equals(message) || "Failed to send message to XMLRPC server http://localhost:9000".equals(message) || "Can not set up communication with any XMLRPC server".equals(message)) continue;
            XmlrpcdTest.fail((String)("Unexpected error logged: [" + errors[i].getLevel().toString() + "] " + errors[i].getLoggerName() + ": " + errors[i].getMessage()));
        }
        MockLogAppender.resetEvents();
        this.finishUp();
    }

    public void testSerialFailback() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configTwo));
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(9001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createRouterVector(date));
        Event nodeOneEvent = new Event();
        nodeOneEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        nodeOneEvent.setTime(date);
        nodeOneEvent.setNodeid(1L);
        nodeOneEvent.setSource("the one true event source");
        nodeOneEvent.setInterface("192.168.1.1");
        nodeOneEvent.setService("ICMP");
        this.getEventIpcManager().sendNow(nodeOneEvent);
        Thread.sleep(1500L);
        this.m_anticipator1.verifyAnticipated();
        this.m_anticipator1.shutdown();
        this.m_anticipator2.anticipateCall("sendServiceDownEvent", this.createServerVector(date));
        Event nodeTwoEvent = new Event();
        nodeTwoEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        nodeTwoEvent.setTime(date);
        nodeTwoEvent.setNodeid(2L);
        nodeTwoEvent.setSource("the one true event source");
        nodeTwoEvent.setInterface("192.168.1.2");
        nodeTwoEvent.setService("SNMP");
        this.getEventIpcManager().sendNow(nodeTwoEvent);
        Thread.sleep(1500L);
        this.m_anticipator2.verifyAnticipated();
        this.m_anticipator2.shutdown();
        this.m_anticipator1 = new XmlrpcAnticipator(9000);
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createFirewallVector(date));
        Event nodeThreeEvent = new Event();
        nodeThreeEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        nodeThreeEvent.setTime(date);
        nodeThreeEvent.setNodeid(3L);
        nodeThreeEvent.setSource("the one true event source");
        nodeThreeEvent.setInterface("192.168.1.3");
        nodeThreeEvent.setService("Telnet");
        this.getEventIpcManager().sendNow(nodeThreeEvent);
        Thread.sleep(1500L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        LoggingEvent[] errors = MockLogAppender.getEventsGreaterOrEqual((Level)Level.ERROR);
        MockLogAppender.resetEvents();
        if (errors.length == 0) {
            XmlrpcdTest.fail((String)"No errors received by log4j, however some errors should have been received while the XML-RPCanticipator was down");
        }
        for (int i = 0; i < errors.length; ++i) {
            String message = errors[i].getMessage().toString();
            if ("Failed to send message to XMLRPC server: http://localhost:9000".equals(message) || "Failed to send message to XMLRPC server: http://localhost:9001".equals(message) || "Could not successfully communicate with XMLRPC server 'http://localhost:9000' after 1 tries".equals(message) || "Could not successfully communicate with XMLRPC server 'http://localhost:9001' after 1 tries".equals(message) || "Failed to send message to XMLRPC server http://localhost:9000".equals(message) || "Can not set up communication with any XMLRPC server".equals(message)) continue;
            XmlrpcdTest.fail((String)("Unexpected error logged: [" + errors[i].getLevel().toString() + "] " + errors[i].getLoggerName() + ": " + errors[i].getMessage()));
        }
        MockLogAppender.resetEvents();
        this.finishUp();
    }

    private Vector<Object> createFirewallVector(String date) {
        return this.createVector("Firewall", "192.168.1.3", "Telnet", "Not Available", "null", date);
    }

    public void testMultipleServersSameEvents() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configParallelSame));
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(9001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createRouterVector(date));
        this.m_anticipator2.anticipateCall("sendServiceDownEvent", this.createRouterVector(date));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeLostService");
        e.setTime(date);
        e.setNodeid(1L);
        e.setSource("the one true event source");
        e.setInterface("192.168.1.1");
        e.setService("ICMP");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testMultipleServersDifferentEvents() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configParallelDifferent));
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(9001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createRouterVector(date));
        Event lostEvent = new Event();
        lostEvent.setUei("uei.opennms.org/nodes/nodeLostService");
        lostEvent.setTime(date);
        lostEvent.setNodeid(1L);
        lostEvent.setSource("the one true event source");
        lostEvent.setInterface("192.168.1.1");
        lostEvent.setService("ICMP");
        this.getEventIpcManager().sendNow(lostEvent);
        this.m_anticipator2.anticipateCall("sendServiceUpEvent", this.createServerVector(date));
        Event regainedEvent = new Event();
        regainedEvent.setUei("uei.opennms.org/nodes/nodeRegainedService");
        regainedEvent.setTime(date);
        regainedEvent.setNodeid(2L);
        regainedEvent.setSource("the one true event source");
        regainedEvent.setInterface("192.168.1.2");
        regainedEvent.setService("SNMP");
        this.getEventIpcManager().sendNow(regainedEvent);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    private Vector<Object> createServerVector(String date) {
        return this.createVector("Server", "192.168.1.2", "SNMP", "Not Available", "null", date);
    }

    public void testEventGeneric() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configGeneric));
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("source", "the one true event source");
        t.put("nodeId", "1");
        t.put("time", date);
        t.put("interface", "192.168.1.1");
        t.put("nodeLabel", "Router");
        t.put("service", "ICMP");
        t.put("uei", "uei.opennms.org/nodes/nodeLostService");
        t.put("description", "\n      <p>A ICMP outage was identified on interface\n      192.168.1.1.</p> <p>A new Outage record has been\n      created and service level availability calculations will be\n      impacted until this outage is resolved.</p>\n    ");
        t.put("severity", "Minor");
        this.m_anticipator1.anticipateCall("sendEvent", this.createVector(t));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeLostService");
        e.setTime(date);
        e.setNodeid(1L);
        e.setSource("the one true event source");
        e.setInterface("192.168.1.1");
        e.setService("ICMP");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testSendTrapSimpleNonGeneric() throws Exception {
        long dateLong = System.currentTimeMillis();
        String date = new Date(dateLong).toString();
        String enterpriseId = ".1.3.6.4.1.1.1";
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setTime(EventConstants.formatToString((Date)new Date(dateLong)));
        e.setSnmp(XmlRpcNotifierTest.makeBasicTrapEventSnmp("public", 6, enterpriseId, 2, dateLong, "1"));
        e.setSource("the one true source");
        e.setLogmsg(new Logmsg());
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testSendTrapSimple() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configGeneric));
        long dateLong = System.currentTimeMillis();
        String date = EventConstants.formatToString((Date)new Date(dateLong));
        String enterpriseId = ".1.3.6.4.1.1.1";
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcTrapHashtable(v, date, "public", 6, enterpriseId, 2, dateLong, "1");
        t.put("uei", "uei.opennms.org/default/trap");
        t.put("source", "the one true source");
        t.put("severity", "Normal");
        this.m_anticipator1.anticipateCall("sendSnmpTrapEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setUei("uei.opennms.org/default/trap");
        e.setTime(EventConstants.formatToString((Date)new Date(dateLong)));
        e.setSnmp(XmlRpcNotifierTest.makeBasicTrapEventSnmp("public", 6, enterpriseId, 2, dateLong, "1"));
        e.setSource("the one true source");
        e.setSeverity("Normal");
        e.setLogmsg(new Logmsg());
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testServiceDownEvent() throws Exception {
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", this.createRouterVector(date));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeLostService");
        e.setTime(date);
        e.setNodeid(1L);
        e.setSource("the one true event source");
        e.setInterface("192.168.1.1");
        e.setService("ICMP");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    private Vector<Object> createRouterVector(String date) {
        return this.createVector("Router", "192.168.1.1", "ICMP", "Not Available", "null", date);
    }

    public void testServiceUpEvent() throws Exception {
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendServiceUpEvent", this.createRouterVector(date));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeRegainedService");
        e.setTime(date);
        e.setNodeid(1L);
        e.setSource("the one true event source");
        e.setInterface("192.168.1.1");
        e.setService("ICMP");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testInterfaceDownEvent() throws Exception {
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendInterfaceDownEvent", this.createVector("Router", "192.168.1.1", "null", date));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/interfaceDown");
        e.setTime(date);
        e.setNodeid(1L);
        e.setSource("the one true event source");
        e.setInterface("192.168.1.1");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testInterfaceUpEvent() throws Exception {
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendInterfaceUpEvent", this.createVector("Router", "192.168.1.1", "null", "null", date));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/interfaceUp");
        e.setTime(date);
        e.setNodeid(1L);
        e.setSource("the one true event source");
        e.setInterface("192.168.1.1");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testNodeDownEvent() throws Exception {
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendNodeDownEvent", this.createVector("Router", "bar", date));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeDown");
        e.setTime(date);
        e.setNodeid(1L);
        e.setHost("bar");
        e.setSource("the one true event source");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testNodeUpEvent() throws Exception {
        String date = EventConstants.formatToString((Date)new Date());
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendNodeUpEvent", this.createVector("Router", "bar", date));
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeUp");
        e.setTime(date);
        e.setNodeid(1L);
        e.setHost("bar");
        e.setSource("the one true event source");
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testBadConfig() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configBad));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new UndeclaredThrowableException((Throwable)new ValidationException()));
        try {
            this.m_xmlrpcd.init();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        LoggingEvent[] errors = MockLogAppender.getEventsGreaterOrEqual((Level)Level.ERROR);
        MockLogAppender.resetEvents();
        if (errors.length == 0) {
            XmlrpcdTest.fail((String)"No errors received by log4j, however some errors should have been received while the XML-RPCanticipator was down");
        }
        for (int i = 0; i < errors.length; ++i) {
            String message = errors[i].getMessage().toString();
            if ("serverSubscription element baseEventsBlah references a subscription that does not exist".equals(message) || "Failed to load configuration".equals(message)) continue;
            XmlrpcdTest.fail((String)("Unexpected error logged: [" + errors[i].getLevel().toString() + "] " + errors[i].getLoggerName() + ": " + errors[i].getMessage()));
        }
        MockLogAppender.resetEvents();
        this.finishUp();
    }

    private Vector<Object> createVector(Object ... objs) {
        Vector<Object> v = new Vector<Object>(objs.length);
        for (Object obj : objs) {
            v.add(obj);
        }
        return v;
    }
}

