/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import org.opennms.netmgt.dao.TransactionAwareEventForwarder;
import org.opennms.netmgt.dao.db.AbstractTransactionalTemporaryDatabaseSpringContextTests;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.DaoTestConfigBean;

public class TransactionAwareEventForwarderTest
extends AbstractTransactionalTemporaryDatabaseSpringContextTests {
    private TransactionAwareEventForwarder m_proxy;
    private int m_eventNumber = 1;
    private MockEventIpcManager m_eventIpcManager;

    protected void setUpConfiguration() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.afterPropertiesSet();
    }

    protected String[] getConfigLocations() {
        return new String[]{"META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "META-INF/opennms/applicationContext-daemon.xml", "org/opennms/netmgt/utils/applicationContext-testTAEventForwarderTest.xml", "META-INF/opennms/mockEventIpcManager.xml", "META-INF/opennms/smallEventConfDao.xml"};
    }

    public void setTransactionAwareEventForwarder(TransactionAwareEventForwarder proxy) {
        this.m_proxy = proxy;
    }

    public void testSendEventsOnCommit() {
        this.sendEventAndCommit();
        this.getEventAnticipator().verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    public void testSendEventsOnRollback() {
        this.sendEventAndRollback();
        this.getEventAnticipator().verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    public void testTwoTransactions() {
        this.sendEventAndCommit();
        this.startNewTransaction();
        this.sendEventAndCommit();
        this.getEventAnticipator().verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    public void testCommitRollbackCommit() {
        this.sendEventAndCommit();
        this.startNewTransaction();
        this.sendEventAndRollback();
        this.startNewTransaction();
        this.sendEventAndCommit();
        this.getEventAnticipator().verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    private void sendEventAndCommit() {
        this.sendEventAndEndTransaction(true);
    }

    private void sendEventAndRollback() {
        this.sendEventAndEndTransaction(false);
    }

    private void sendEventAndEndTransaction(boolean complete) {
        Event event = new EventBuilder("uei.opennms.org/internal/capsd/addInterface", "Test").setNodeid(this.m_eventNumber++).getEvent();
        if (complete) {
            this.getEventAnticipator().anticipateEvent(event);
        }
        this.m_proxy.sendNow(event);
        if (complete) {
            this.setComplete();
        }
        this.endTransaction();
    }

    private EventAnticipator getEventAnticipator() {
        return this.m_eventIpcManager.getEventAnticipator();
    }

    public MockEventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    public void setEventIpcManager(MockEventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }
}

