/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.InputStream;
import java.net.InetAddress;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.TrapdConfigFactory;
import org.opennms.netmgt.dao.db.AbstractTransactionalTemporaryDatabaseSpringContextTests;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.trapd.Trapd;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;

public class TrapdTest
extends AbstractTransactionalTemporaryDatabaseSpringContextTests {
    private int m_port = 1162;
    private Trapd m_trapd = new Trapd();
    private MockEventIpcManager m_mockEventIpcManager;

    protected void setUpConfiguration() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.afterPropertiesSet();
        InputStream stream = ConfigurationTestUtils.getInputStreamForResourceWithReplacements((Object)((Object)this), (String)"trapd-configuration.xml", (String[][])new String[][]{{"@snmp-trap-port@", Integer.toString(this.m_port)}});
        TrapdConfigFactory.setInstance((TrapdConfig)new TrapdConfigFactory(stream));
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:META-INF/opennms/applicationContext-daemon.xml", "classpath:META-INF/opennms/mockEventIpcManager.xml", "classpath:META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:META-INF/opennms/applicationContext-trapDaemon.xml", "classpath:META-INF/opennms/smallEventConfDao.xml"};
    }

    protected void onSetUpInTransactionIfEnabled() throws Exception {
        this.getMockEventIpcManager().setSynchronous(true);
        this.m_trapd.onStart();
    }

    protected void onTearDownInTransactionIfEnabled() throws Exception {
        this.m_trapd.onStop();
    }

    public Trapd getDaemon() {
        return this.m_trapd;
    }

    public void setDaemon(Trapd daemon) {
        this.m_trapd = daemon;
    }

    public void testSnmpV1TrapSend() throws Exception {
        String localhost = "127.0.0.1";
        InetAddress localAddr = InetAddress.getByName(localhost);
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)".1.3.6.1.4.1.5813"));
        pdu.setGeneric(1);
        pdu.setSpecific(0);
        pdu.setTimeStamp(666L);
        pdu.setAgentAddress(localAddr);
        EventBuilder defaultTrapBuilder = new EventBuilder("uei.opennms.org/default/trap", "trapd");
        defaultTrapBuilder.setInterface(localhost);
        this.getMockEventIpcManager().getEventAnticipator().anticipateEvent(defaultTrapBuilder.getEvent());
        EventBuilder newSuspectBuilder = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "trapd");
        newSuspectBuilder.setInterface(localhost);
        this.getMockEventIpcManager().getEventAnticipator().anticipateEvent(newSuspectBuilder.getEvent());
        pdu.send(localhost, this.m_port, "public");
        this.getMockEventIpcManager().getEventAnticipator().verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    public MockEventIpcManager getMockEventIpcManager() {
        return this.m_mockEventIpcManager;
    }

    public void setMockEventIpcManager(MockEventIpcManager mockEventIpcManager) {
        this.m_mockEventIpcManager = mockEventIpcManager;
    }
}

