/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.trapd.SyntaxToEvent;
import org.opennms.netmgt.xml.event.Parm;

public class SyntaxToEventTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testProcessSyntaxZeros() {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        Assert.assertNotNull((Object)valueFactory);
        byte[] macAddr = new byte[]{0, 0, 0, 0, 0, 0};
        SnmpValue octetString = valueFactory.getOctetString(macAddr);
        Parm parm = SyntaxToEvent.processSyntax((String)"Test", (SnmpValue)octetString);
        Assert.assertEquals((Object)"Test", (Object)parm.getParmName());
        Assert.assertEquals((Object)"00:00:00:00:00:00", (Object)parm.getValue().getContent());
    }

    @Test
    public void testProcessSyntaxWithNull() {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        Assert.assertNotNull((Object)valueFactory);
        byte[] macAddr = new byte[]{0, 85, 85, 85, 85, 85};
        SnmpValue octetString = valueFactory.getOctetString(macAddr);
        Parm parm = SyntaxToEvent.processSyntax((String)"Test", (SnmpValue)octetString);
        Assert.assertEquals((Object)"Test", (Object)parm.getParmName());
        Assert.assertEquals((Object)"macAddress", (Object)parm.getValue().getEncoding());
        Assert.assertEquals((Object)"00:55:55:55:55:55", (Object)parm.getValue().getContent());
    }

    @Test
    public void testProcessSyntaxWithTerminatingNull() {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        Assert.assertNotNull((Object)valueFactory);
        byte[] macAddr = new byte[]{85, 85, 85, 85, 85, 0};
        SnmpValue octetString = valueFactory.getOctetString(macAddr);
        Parm parm = SyntaxToEvent.processSyntax((String)"Test", (SnmpValue)octetString);
        Assert.assertEquals((Object)"Test", (Object)parm.getParmName());
        Assert.assertEquals((Object)"text", (Object)parm.getValue().getEncoding());
        Assert.assertEquals((Object)"UUUUU.", (Object)parm.getValue().getContent());
    }

    @Test
    public void testProcessSyntaxForMacAddresses() {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        Assert.assertNotNull((Object)valueFactory);
        byte[] macAddr = new byte[]{1, 2, 3, 4, 5, 6};
        SnmpValue octetString = valueFactory.getOctetString(macAddr);
        Parm parm = SyntaxToEvent.processSyntax((String)"testMacAddress", (SnmpValue)octetString);
        Assert.assertEquals((Object)"testMacAddress", (Object)parm.getParmName());
        Assert.assertEquals((Object)"macAddress", (Object)parm.getValue().getEncoding());
        Assert.assertEquals((Object)"01:02:03:04:05:06", (Object)parm.getValue().getContent());
        macAddr = new byte[]{-128, -127, -116, -113, -1, 5};
        octetString = valueFactory.getOctetString(macAddr);
        parm = SyntaxToEvent.processSyntax((String)"testMacAddress", (SnmpValue)octetString);
        Assert.assertEquals((Object)"testMacAddress", (Object)parm.getParmName());
        Assert.assertEquals((Object)"macAddress", (Object)parm.getValue().getEncoding());
        Assert.assertEquals((Object)"80:81:8C:8F:FF:05", (Object)parm.getValue().getContent());
        macAddr = new byte[]{65, 65, 65, 65, 65, 65};
        octetString = valueFactory.getOctetString(macAddr);
        parm = SyntaxToEvent.processSyntax((String)"otherDataType", (SnmpValue)octetString);
        Assert.assertEquals((Object)"otherDataType", (Object)parm.getParmName());
        Assert.assertEquals((Object)"text", (Object)parm.getValue().getEncoding());
        Assert.assertEquals((Object)"AAAAAA", (Object)parm.getValue().getContent());
        parm = SyntaxToEvent.processSyntax((String)"testMacAddress", (SnmpValue)octetString);
        Assert.assertEquals((Object)"testMacAddress", (Object)parm.getParmName());
        Assert.assertEquals((Object)"macAddress", (Object)parm.getValue().getEncoding());
        Assert.assertEquals((Object)"41:41:41:41:41:41", (Object)parm.getValue().getContent());
    }
}

