/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.SnmpThresholder;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholderTestCase;
import org.opennms.test.mock.MockLogAppender;

public class SnmpThresholderIntegrationTest
extends ThresholderTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.setupDatabase();
        this.createMockRrd();
        this.setupEventManager();
        this.replayMocks();
        String rrdRepository = "target/threshd-test";
        String fileName = "cpuUtilization" + RrdUtils.getExtension();
        int nodeId = 1;
        String ipAddress = "192.168.1.1";
        String serviceName = "SNMP";
        String groupName = "default-snmp";
        this.setupThresholdConfig(rrdRepository + File.separator + nodeId, fileName, nodeId, ipAddress, serviceName, groupName);
        this.m_thresholder = new SnmpThresholder();
        this.m_thresholder.initialize(this.m_serviceParameters);
        this.m_thresholder.initialize((ThresholdNetworkInterface)this.m_iface, this.m_parameters);
        this.verifyMocks();
        this.expectRrdStrategyCalls();
    }

    protected void tearDown() throws Exception {
        RrdUtils.setStrategy(null);
        MockLogAppender.assertNoWarningsOrGreater();
        super.tearDown();
    }

    public void testNormalValue() throws Exception {
        this.setupFetchSequence("cpuUtilization", 69.0, 79.0, 74.0, 74.0);
        this.replayMocks();
        this.ensureNoEventAfterFetches("cpuUtilization", 4);
        this.verifyMocks();
    }

    public void testBigValue() throws Exception {
        this.setupFetchSequence("cpuUtilization", 99.0, 98.0, 97.0, 96.0, 95.0);
        this.replayMocks();
        this.ensureExceededAfterFetches("cpuUtilization", 3);
        this.ensureNoEventAfterFetches("cpuUtilization", 2);
        this.verifyMocks();
    }

    public void testRearm() throws Exception {
        double[] values = new double[]{99.0, 91.0, 93.0, 96.0, 15.0, 98.0, 98.0, 98.0};
        this.setupFetchSequence("cpuUtilization", values);
        this.replayMocks();
        this.ensureExceededAfterFetches("cpuUtilization", 3);
        this.ensureRearmedAfterFetches("cpuUtilization", 2);
        this.ensureExceededAfterFetches("cpuUtilization", 3);
        this.verifyMocks();
    }
}

