/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.syslogd.SyslogClient;
import org.opennms.netmgt.syslogd.Syslogd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyslogdTest
extends OpenNMSTestCase {
    private Syslogd m_syslogd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUp() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.setRelativeHomeDirectory("src/test/resources");
        daoTestConfig.afterPropertiesSet();
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        InputStream stream = null;
        try {
            stream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/etc/syslogd-configuration.xml");
            new SyslogdConfigFactory(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        this.m_syslogd = new Syslogd();
        this.m_syslogd.init();
    }

    @Override
    protected void tearDown() throws Exception {
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
        super.tearDown();
    }

    @Override
    public void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNotGreaterOrEqual((Level)Level.FATAL);
    }

    private List<Event> doMessageTest(String testPDU, String expectedHost, String expectedUEI, String expectedLogMsg) throws UnknownHostException, InterruptedException {
        this.startSyslogdGracefully();
        Event expectedEvent = new Event();
        expectedEvent.setUei(expectedUEI);
        expectedEvent.setSource("syslogd");
        expectedEvent.setInterface(expectedHost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent(expectedLogMsg);
        expectedEvent.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        this.getEventIpcManager().addEventListener((EventListener)ea);
        ea.anticipateEvent(expectedEvent);
        SyslogClient sc = null;
        sc = new SyslogClient(null, 10, 7);
        sc.syslog(7, testPDU);
        SyslogdTest.assertEquals((int)0, (int)ea.waitForAnticipated(2000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        Event receivedEvent = ea.getAnticipatedEventsRecieved().get(0);
        SyslogdTest.assertEquals((String)"Log messages do not match", (String)expectedLogMsg, (String)receivedEvent.getLogmsg().getContent());
        return ea.getAnticipatedEventsRecieved();
    }

    private List<Event> doMessageTest(String testPDU, String expectedHost, String expectedUEI, String expectedLogMsg, Map<String, String> expectedParams) throws UnknownHostException, InterruptedException {
        List<Event> receivedEvents = this.doMessageTest(testPDU, expectedHost, expectedUEI, expectedLogMsg);
        HashMap<String, String> actualParms = new HashMap<String, String>();
        for (Parm actualParm : receivedEvents.get(0).getParms().getParmCollection()) {
            actualParms.put(actualParm.getParmName(), actualParm.getValue().getContent());
        }
        for (String expectedKey : expectedParams.keySet()) {
            String expectedValue = expectedParams.get(expectedKey);
            SyslogdTest.assertTrue((String)("Actual event does not have a parameter called " + expectedKey), (boolean)actualParms.containsKey(expectedKey));
            SyslogdTest.assertEquals((String)("Actual event has a parameter called " + expectedKey + " but its value does not match"), (String)expectedValue, (String)((String)actualParms.get(expectedKey)));
        }
        return receivedEvents;
    }

    public void testMessaging() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 0, 7);
            s.syslog(3, "Hello.");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void XXXtestMyPatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 host.domain.com A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testIPPatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 127.0.0.1 A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testResolvePatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void startSyslogdGracefully() {
        block2: {
            try {
                this.m_syslogd.start();
            }
            catch (UndeclaredThrowableException ute) {
                if (ute.getCause() instanceof BindException) break block2;
                throw ute;
            }
        }
    }

    public void testSubstrUEIRewrite() throws Exception {
        this.doMessageTest("2007-01-01 localhost A CRISCO message", this.myLocalHost(), "uei.opennms.org/tests/syslogd/substrUeiRewriteTest", "A CRISCO message");
    }

    public void testRegexUEIRewrite() throws Exception {
        this.doMessageTest("2007-01-01 localhost foo: 100 out of 666 tests failed for bar", this.myLocalHost(), "uei.opennms.org/tests/syslogd/regexUeiRewriteTest", "100 out of 666 tests failed for bar");
    }

    public void testSubstrTESTTestThatRemovesATESTString() throws Exception {
        this.doMessageTest("2007-01-01 localhost A CRISCO message that is also a TESTHIDING message -- hide me!", this.myLocalHost(), "uei.opennms.org/tests/syslogd/substrUeiRewriteTest", "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.");
    }

    public void testRegexTESTTestThatRemovesADoubleSecretString() throws Exception {
        this.doMessageTest("2007-01-01 localhost foo: 100 out of 666 tests failed for doubleSecret", this.myLocalHost(), "uei.opennms.org/tests/syslogd/regexUeiRewriteTest", "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.");
    }

    public void testSubstrDiscard() throws Exception {
        this.startSyslogdGracefully();
        String testPDU = "2007-01-01 127.0.0.1 A JUNK message";
        EventAnticipator ea = new EventAnticipator();
        this.getEventIpcManager().addEventListener((EventListener)ea);
        SyslogClient sc = null;
        sc = new SyslogClient(null, 10, 7);
        sc.syslog(7, "2007-01-01 127.0.0.1 A JUNK message");
        Thread.sleep(3000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
    }

    public void testRegexDiscard() throws Exception {
        this.startSyslogdGracefully();
        String testPDU = "2007-01-01 127.0.0.1 A TrAsH message";
        EventAnticipator ea = new EventAnticipator();
        this.getEventIpcManager().addEventListener((EventListener)ea);
        SyslogClient sc = null;
        sc = new SyslogClient(null, 10, 7);
        sc.syslog(7, "2007-01-01 127.0.0.1 A TrAsH message");
        Thread.sleep(3000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
    }

    public void testRegexUEIWithBothKindsOfParameterAssignments() throws Exception {
        String testPDU = "2007-01-01 127.0.0.1 coffee: Secretly replaced rangerrick's coffee with 42 wombats";
        String expectedUEI = "uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/bothKinds";
        String expectedLogMsg = "Secretly replaced rangerrick's coffee with 42 wombats";
        String[] testGroups = new String[]{"rangerrick's", "42", "wombats"};
        HashMap<String, String> expectedParms = new HashMap<String, String>();
        expectedParms.put("group1", testGroups[0]);
        expectedParms.put("whoseBeverage", testGroups[0]);
        expectedParms.put("group2", testGroups[1]);
        expectedParms.put("count", testGroups[1]);
        expectedParms.put("group3", testGroups[2]);
        expectedParms.put("replacementItem", testGroups[2]);
        this.doMessageTest("2007-01-01 127.0.0.1 coffee: Secretly replaced rangerrick's coffee with 42 wombats", this.myLocalHost(), "uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/bothKinds", "Secretly replaced rangerrick's coffee with 42 wombats", expectedParms);
    }

    public void testRegexUEIWithOnlyUserSpecifiedParameterAssignments() throws InterruptedException {
        this.startSyslogdGracefully();
        String localhost = this.myLocalHost();
        String testPDU = "2007-01-01 127.0.0.1 tea: Secretly replaced cmiskell's tea with 666 ferrets";
        String testUEI = "uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/userSpecifiedOnly";
        String testMsg = "Secretly replaced cmiskell's tea with 666 ferrets";
        String[] testGroups = new String[]{"cmiskell's", "666", "ferrets"};
        Event e = new Event();
        e.setUei("uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/userSpecifiedOnly");
        e.setSource("syslogd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("Secretly replaced cmiskell's tea with 666 ferrets");
        e.setLogmsg(logmsg);
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("whoseBeverage");
        parmValue = new Value();
        parmValue.setContent(testGroups[0]);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("count");
        parmValue = new Value();
        parmValue.setContent(testGroups[1]);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("replacementItem");
        parmValue = new Value();
        parmValue.setContent(testGroups[2]);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        e.setParms(eventParms);
        EventAnticipator ea = new EventAnticipator();
        this.getEventIpcManager().addEventListener((EventListener)ea);
        ea.anticipateEvent(e);
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 127.0.0.1 tea: Secretly replaced cmiskell's tea with 666 ferrets");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        SyslogdTest.assertEquals((int)0, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
    }
}

