/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.syslogd.SyslogClient;
import org.opennms.netmgt.syslogd.Syslogd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyslogdLoadTest
extends OpenNMSTestCase {
    private Syslogd m_syslogd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUp() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.setRelativeHomeDirectory("src/test/resources");
        daoTestConfig.afterPropertiesSet();
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        InputStream stream = null;
        try {
            stream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/etc/syslogd-loadtest-configuration.xml");
            new SyslogdConfigFactory(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        this.m_syslogd = new Syslogd();
        this.m_syslogd.init();
    }

    @Override
    protected void tearDown() throws Exception {
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
        super.tearDown();
    }

    @Override
    public void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNotGreaterOrEqual((Level)Level.FATAL);
    }

    private List<Event> doMessageTest(String testPDU, String expectedHost, String expectedUEI, String expectedLogMsg) throws UnknownHostException, InterruptedException {
        this.startSyslogdGracefully();
        Event expectedEvent = new Event();
        expectedEvent.setUei(expectedUEI);
        expectedEvent.setSource("syslogd");
        expectedEvent.setInterface(expectedHost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent(expectedLogMsg);
        expectedEvent.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        this.getEventIpcManager().addEventListener((EventListener)ea);
        ea.anticipateEvent(expectedEvent);
        SyslogClient sc = null;
        sc = new SyslogClient(null, 10, 7);
        sc.syslog(7, testPDU);
        SyslogdLoadTest.assertEquals((int)0, (int)ea.waitForAnticipated(2000L).size());
        Thread.sleep(2000L);
        SyslogdLoadTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        Event receivedEvent = ea.getAnticipatedEventsRecieved().get(0);
        SyslogdLoadTest.assertEquals((String)"Log messages do not match", (String)expectedLogMsg, (String)receivedEvent.getLogmsg().getContent());
        return ea.getAnticipatedEventsRecieved();
    }

    private void startSyslogdGracefully() {
        block2: {
            try {
                this.m_syslogd.start();
            }
            catch (UndeclaredThrowableException ute) {
                if (ute.getCause() instanceof BindException) break block2;
                throw ute;
            }
        }
    }

    public void XXXtestHummerSyslogd() throws Exception {
        this.startSyslogdGracefully();
        EventAnticipator ea = new EventAnticipator();
        this.getEventIpcManager().addEventListener((EventListener)ea);
        ArrayList<Event> eventsToSend = new ArrayList<Event>();
        for (int i = 0; i < 100000; ++i) {
            double eventNum = Math.random() * 300.0;
            String expectedUei = "uei.example.org/syslog/loadTest/foo" + eventNum;
            Event thisEvent = new Event();
            thisEvent.setUei(expectedUei);
            Logmsg logmsg = new Logmsg();
            logmsg.setDest("logndisplay");
            logmsg.setContent("A load test has been received as a Syslog Message");
            thisEvent.setLogmsg(logmsg);
            ea.anticipateEvent(thisEvent);
            eventsToSend.add(thisEvent);
        }
        String testPduFormat = "2010-08-19 localhost foo%d: load test %d on tty1";
        SyslogClient sc = null;
        sc = new SyslogClient(null, 10, 7);
        for (Event e : eventsToSend) {
        }
    }
}

