/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.MailDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.statsd.RelativeTime;

public class RelativeTimeTest {
    private DateFormat m_dateFormat = new MailDateFormat();
    private TimeZone m_timeZone = TimeZone.getTimeZone("GMT-05:00");

    @Test
    public void testYesterdayBeginningDST() {
        RelativeTime yesterday = RelativeTime.YESTERDAY;
        yesterday.setTimeKeeper(new TimeKeeper(){

            public Date getCurrentDate() {
                GregorianCalendar cal = new GregorianCalendar(RelativeTimeTest.this.m_timeZone, Locale.ENGLISH);
                cal.set(2006, 3, 3, 10, 0, 0);
                return cal.getTime();
            }

            public long getCurrentTime() {
                return this.getCurrentDate().getTime();
            }
        });
        Date start = yesterday.getStart();
        Date end = yesterday.getEnd();
        GregorianCalendar c = new GregorianCalendar(this.m_timeZone, Locale.ENGLISH);
        c.setTime(start);
        Assert.assertEquals((long)-18000000L, (long)c.get(15));
        Assert.assertEquals((long)2006L, (long)c.get(1));
        Assert.assertEquals((long)0L, (long)c.get(11));
        Assert.assertEquals((long)1L, (long)c.get(7));
        Assert.assertEquals((long)2L, (long)c.get(5));
        c.setTime(end);
        Assert.assertEquals((long)-18000000L, (long)c.get(15));
        Assert.assertEquals((long)2006L, (long)c.get(1));
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)1L, (long)c.get(7));
        Assert.assertEquals((long)2L, (long)c.get(5));
        Assert.assertEquals((String)"start date", (Object)"Sun, 2 Apr 2006 00:00:00 -0500 (EST)", (Object)this.m_dateFormat.format(start));
        Assert.assertEquals((String)"end date", (Object)"Mon, 3 Apr 2006 00:00:00 -0400 (EDT)", (Object)this.m_dateFormat.format(end));
        Assert.assertEquals((String)"end date - start date", (long)82800000L, (long)(end.getTime() - start.getTime()));
    }

    @Test
    public void testYesterdayEndingDST() {
        RelativeTime yesterday = RelativeTime.YESTERDAY;
        yesterday.setTimeKeeper(new TimeKeeper(){

            public Date getCurrentDate() {
                GregorianCalendar cal = new GregorianCalendar(RelativeTimeTest.this.m_timeZone, Locale.ENGLISH);
                cal.set(2006, 9, 30, 10, 0, 0);
                return cal.getTime();
            }

            public long getCurrentTime() {
                return this.getCurrentDate().getTime();
            }
        });
        Date start = yesterday.getStart();
        Date end = yesterday.getEnd();
        GregorianCalendar c = new GregorianCalendar(this.m_timeZone, Locale.ENGLISH);
        c.setTime(start);
        Assert.assertEquals((long)-18000000L, (long)c.get(15));
        Assert.assertEquals((long)2006L, (long)c.get(1));
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)7L, (long)c.get(7));
        Assert.assertEquals((long)28L, (long)c.get(5));
        c.setTime(end);
        Assert.assertEquals((long)-18000000L, (long)c.get(15));
        Assert.assertEquals((long)2006L, (long)c.get(1));
        Assert.assertEquals((long)0L, (long)c.get(11));
        Assert.assertEquals((long)2L, (long)c.get(7));
        Assert.assertEquals((long)30L, (long)c.get(5));
        Assert.assertEquals((String)"start date", (Object)"Sun, 29 Oct 2006 00:00:00 -0400 (EDT)", (Object)this.m_dateFormat.format(start));
        Assert.assertEquals((String)"end date", (Object)"Mon, 30 Oct 2006 00:00:00 -0500 (EST)", (Object)this.m_dateFormat.format(end));
        Assert.assertEquals((String)"end date - start date", (long)90000000L, (long)(end.getTime() - start.getTime()));
    }
}

