/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Filter;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.support.DefaultPollerBackEnd;
import org.opennms.netmgt.xml.event.Event;
import org.quartz.Scheduler;

public class PollerBackEndTest
extends TestCase {
    static final int DISCONNECTED_TIMEOUT = 300000;
    private DefaultPollerBackEnd m_backEnd = new DefaultPollerBackEnd();
    private LocationMonitorDao m_locMonDao;
    private MonitoredServiceDao m_monSvcDao;
    private PollerConfig m_pollerConfig;
    private Scheduler m_scheduler;
    private TimeKeeper m_timeKeeper;
    private EventIpcManager m_eventIpcManager;
    private OnmsMonitoringLocationDefinition m_locationDefinition;
    private Package m_package;
    private ServiceSelector m_serviceSelector;
    private OnmsLocationMonitor m_locationMonitor;
    private Service m_httpSvcConfig;
    private Service m_dnsSvcConfig;
    private OnmsMonitoredService m_httpService;
    private OnmsMonitoredService m_dnsService;
    private OnmsMonitoredService[] m_monServices;
    private OnmsLocationSpecificStatus m_httpCurrentStatus;
    private OnmsLocationSpecificStatus m_dnsCurrentStatus;
    private Date m_startTime;
    private HashMap<String, String> m_pollerDetails;

    private void addParameter(Service service, String key, String value) {
        Parameter param = new Parameter();
        param.setKey(key);
        param.setValue(value);
        service.addParameter(param);
    }

    private Service addService(Package pkg, String serviceName, int serviceInterval, String ... parms) {
        PollerBackEndTest.assertTrue((parms.length % 2 == 0 ? 1 : 0) != 0);
        Service service = new Service();
        service.setName(serviceName);
        service.setInterval((long)serviceInterval);
        for (int i = 0; i < parms.length - 1; i += 2) {
            String key = parms[i];
            String value = parms[i + 1];
            this.addParameter(service, key, value);
        }
        pkg.addService(service);
        return service;
    }

    private void anticipateDisconnectedEvent() {
        this.anticipateEvent(this.createDisconnectedEvent());
    }

    private void anticipateEvent(Event e) {
        this.m_eventIpcManager.sendNow(this.eq(e));
    }

    private void anticipateMonitorStarted() {
        this.anticipateEvent(this.createMonitorStartedEvent());
    }

    private void anticipateMonitorRegisteredEvent() {
        this.anticipateEvent(this.createMonitorRegisteredEvent());
    }

    private void anticipateMonitorStoppedEvent() {
        this.anticipateEvent(this.createMonitorStoppedEvent());
    }

    private Event createDisconnectedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorDisconnected", "PollerBackEnd").addParam("locationMonitorId", 1);
        Event e = eventBuilder.getEvent();
        return e;
    }

    private Event createMonitorRegisteredEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorRegistered", "PollerBackEnd").addParam("locationMonitorId", 1);
        Event e = eventBuilder.getEvent();
        return e;
    }

    private Event createMonitorStartedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorStarted", "PollerBackEnd").addParam("locationMonitorId", 1);
        Event e = eventBuilder.getEvent();
        return e;
    }

    private Event createMonitorStoppedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorStopped", "PollerBackEnd").addParam("locationMonitorId", 1);
        return eventBuilder.getEvent();
    }

    private Package createPackage(String pkgName, String filterRule) {
        Package pkg = new Package();
        pkg.setName(pkgName);
        pkg.setFilter(new Filter());
        pkg.getFilter().setContent(filterRule);
        return pkg;
    }

    private Event createReconnectedEvent() {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/locationMonitorReconnected", "PollerBackEnd");
        eventBuilder.addParam("locationMonitorId", 1);
        return eventBuilder.getEvent();
    }

    private Event eq(Event e) {
        EasyMock.reportMatcher((IArgumentMatcher)new EventEquals(e));
        return null;
    }

    private void expectLocationMonitorStarted() {
        final Date now = new Date();
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)now);
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)this.m_locationMonitor.getId())).andReturn((Object)this.m_locationMonitor);
        this.m_locMonDao.update((Object)this.m_locationMonitor);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)mon.getStatus());
                Assert.assertEquals((Object)now, (Object)mon.getLastCheckInTime());
                Assert.assertEquals((Object)PollerBackEndTest.this.m_pollerDetails, (Object)mon.getDetails());
                return null;
            }
        });
    }

    private void expectLocationMonitorStatusChanged(OnmsLocationMonitor.MonitorStatus oldStatus, final OnmsLocationMonitor.MonitorStatus expectedStatus) {
        final Date now = new Date();
        if (oldStatus != null) {
            switch (oldStatus) {
                case DISCONNECTED: 
                case STARTED: {
                    EasyMock.expect((Object)this.m_timeKeeper.getCurrentTime()).andReturn((Object)now.getTime());
                }
            }
        }
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)now);
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)this.m_locationMonitor.getId())).andReturn((Object)this.m_locationMonitor);
        this.m_locMonDao.update((Object)this.m_locationMonitor);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((String)"unexpected new monitor state", (Object)expectedStatus, (Object)mon.getStatus());
                Assert.assertEquals((Object)now, (Object)mon.getLastCheckInTime());
                return null;
            }
        });
    }

    private void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.m_locMonDao, this.m_monSvcDao, this.m_pollerConfig, this.m_scheduler, this.m_timeKeeper, this.m_eventIpcManager});
    }

    protected void setUp() throws Exception {
        System.setProperty("opennms.home", "src/test/test-configurations/PollerBackEndTest-home");
        this.m_locMonDao = (LocationMonitorDao)EasyMock.createMock(LocationMonitorDao.class);
        this.m_monSvcDao = (MonitoredServiceDao)EasyMock.createMock(MonitoredServiceDao.class);
        this.m_pollerConfig = (PollerConfig)EasyMock.createMock(PollerConfig.class);
        this.m_scheduler = (Scheduler)EasyMock.createMock(Scheduler.class);
        this.m_timeKeeper = (TimeKeeper)EasyMock.createMock(TimeKeeper.class);
        this.m_eventIpcManager = (EventIpcManager)EasyMock.createMock(EventIpcManager.class);
        this.m_backEnd = new DefaultPollerBackEnd();
        this.m_backEnd.setLocationMonitorDao(this.m_locMonDao);
        this.m_backEnd.setMonitoredServiceDao(this.m_monSvcDao);
        this.m_backEnd.setPollerConfig(this.m_pollerConfig);
        this.m_backEnd.setTimeKeeper(this.m_timeKeeper);
        this.m_backEnd.setEventIpcManager(this.m_eventIpcManager);
        this.m_backEnd.setDisconnectedTimeout(300000);
        this.m_startTime = new Date(System.currentTimeMillis() - 600000L);
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)this.m_startTime);
        EasyMock.replay((Object[])new Object[]{this.m_timeKeeper});
        this.m_backEnd.afterPropertiesSet();
        EasyMock.verify((Object[])new Object[]{this.m_timeKeeper});
        EasyMock.reset((Object[])new Object[]{this.m_timeKeeper});
        this.m_locationDefinition = new OnmsMonitoringLocationDefinition();
        this.m_locationDefinition.setArea("Oakland");
        this.m_locationDefinition.setName("OAK");
        this.m_locationDefinition.setPollingPackageName("OAKPackage");
        this.m_package = this.createPackage(this.m_locationDefinition.getPollingPackageName(), "ipaddr = '192.168.1.1'");
        this.m_serviceSelector = new ServiceSelector(this.m_package.getFilter().getContent(), Arrays.asList("HTTP", "DNS"));
        this.m_httpSvcConfig = this.addService(this.m_package, "HTTP", 1234, "url", "http://www.opennms.org");
        this.m_dnsSvcConfig = this.addService(this.m_package, "DNS", 5678, "hostname", "www.opennms.org");
        this.m_locationMonitor = new OnmsLocationMonitor();
        this.m_locationMonitor.setId(Integer.valueOf(1));
        this.m_locationMonitor.setDefinitionName(this.m_locationDefinition.getName());
        NetworkBuilder builder = new NetworkBuilder(new OnmsDistPoller("localhost", "127.0.0.1"));
        builder.addNode("testNode").setId(Integer.valueOf(1));
        builder.addInterface("192.168.1.1").setId(1);
        this.m_httpService = builder.addService(new OnmsServiceType("HTTP"));
        this.m_httpService.setId(Integer.valueOf(1));
        this.m_dnsService = builder.addService(new OnmsServiceType("DNS"));
        this.m_dnsService.setId(Integer.valueOf(2));
        this.m_monServices = new OnmsMonitoredService[]{this.m_httpService, this.m_dnsService};
        long now = System.currentTimeMillis();
        PollStatus httpResult = PollStatus.available((Double)1000.0);
        httpResult.setTimestamp(new Date(now - 300000L));
        this.m_httpCurrentStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_httpService, httpResult);
        this.m_httpCurrentStatus.setId(Integer.valueOf(1));
        PollStatus dnsResult = PollStatus.unavailable((String)"Non responsive");
        dnsResult.setTimestamp(new Date(now - 300000L));
        this.m_dnsCurrentStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, dnsResult);
        this.m_dnsCurrentStatus.setId(Integer.valueOf(2));
        this.m_pollerDetails = new HashMap();
        this.m_pollerDetails.put("os.name", "WonkaOS");
        this.m_pollerDetails.put("os.version", "1.2.3");
    }

    public void testGetMonitoringLocations() {
        List<OnmsMonitoringLocationDefinition> locations = Collections.singletonList(this.m_locationDefinition);
        EasyMock.expect((Object)this.m_locMonDao.findAllMonitoringLocationDefinitions()).andReturn(locations);
        this.replayMocks();
        Collection returned = this.m_backEnd.getMonitoringLocations();
        this.verifyMocks();
        PollerBackEndTest.assertEquals(locations, (Object)returned);
    }

    public void testGetPollerConfiguration() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)this.m_locationMonitor.getId())).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_locMonDao.findMonitoringLocationDefinition(this.m_locationDefinition.getName())).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_locationDefinition.getPollingPackageName())).andReturn((Object)this.m_package);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceSelectorForPackage(this.m_package)).andReturn((Object)this.m_serviceSelector);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("HTTP", this.m_package)).andReturn((Object)this.m_httpSvcConfig);
        EasyMock.expect((Object)this.m_pollerConfig.getServiceInPackage("DNS", this.m_package)).andReturn((Object)this.m_dnsSvcConfig);
        EasyMock.expect((Object)this.m_monSvcDao.findMatchingServices(this.m_serviceSelector)).andReturn(Arrays.asList(this.m_monServices));
        this.replayMocks();
        PollerConfiguration config = this.m_backEnd.getPollerConfiguration(this.m_locationMonitor.getId().intValue());
        this.verifyMocks();
        PollerBackEndTest.assertNotNull((Object)config);
        PollerBackEndTest.assertEquals((Object)this.m_startTime, (Object)config.getConfigurationTimestamp());
        PollerBackEndTest.assertNotNull((Object)config.getPolledServices());
        PollerBackEndTest.assertEquals((int)2, (int)config.getPolledServices().length);
        PollerBackEndTest.assertEquals((String)this.m_dnsService.getServiceName(), (String)config.getPolledServices()[0].getSvcName());
        PollerBackEndTest.assertEquals((String)this.m_httpService.getServiceName(), (String)config.getPolledServices()[1].getSvcName());
        PollerBackEndTest.assertEquals((long)5678L, (long)config.getPolledServices()[0].getPollModel().getPollInterval());
        PollerBackEndTest.assertTrue((boolean)config.getPolledServices()[0].getMonitorConfiguration().containsKey("hostname"));
    }

    public void testGetPollerConfigurationForDeletedMonitor() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)this.m_locationMonitor.getId())).andReturn(null);
        this.replayMocks();
        PollerConfiguration config = this.m_backEnd.getPollerConfiguration(this.m_locationMonitor.getId().intValue());
        this.verifyMocks();
        PollerBackEndTest.assertNotNull((Object)config);
        PollerBackEndTest.assertTrue((boolean)this.m_startTime.after(config.getConfigurationTimestamp()));
        PollerBackEndTest.assertNotNull((Object)config.getPolledServices());
        PollerBackEndTest.assertEquals((int)0, (int)config.getPolledServices().length);
    }

    public void testGetServiceMonitorLocators() {
        ArrayList locators = new ArrayList();
        EasyMock.expect((Object)this.m_pollerConfig.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR)).andReturn(locators);
        this.replayMocks();
        Collection results = this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR);
        this.verifyMocks();
        PollerBackEndTest.assertSame(locators, (Object)results);
    }

    private void testGlobalConfigChange(OnmsLocationMonitor.MonitorStatus oldStatus, OnmsLocationMonitor.MonitorStatus newStatus, Event e) {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED);
        this.updateConfiguration();
        this.verifyPollerCheckingIn(oldStatus, newStatus, OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED, e);
    }

    public void testGlobalConfigChangeFromDisconnected() {
        this.testGlobalConfigChange(OnmsLocationMonitor.MonitorStatus.DISCONNECTED, OnmsLocationMonitor.MonitorStatus.STARTED, this.createReconnectedEvent());
    }

    public void testGlobalConfigChangeFromStarted() {
        this.testGlobalConfigChange(OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED, null);
    }

    public void testPollerCheckingInFromDisconnected() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.DISCONNECTED, OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED, this.createReconnectedEvent());
    }

    public void testPollerCheckingInFromPaused() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.PAUSED, OnmsLocationMonitor.MonitorStatus.PAUSED, OnmsLocationMonitor.MonitorStatus.PAUSED);
    }

    public void testPollerCheckingInFromStarted() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.STARTED);
    }

    public void testPollerCheckingInFromConfigChanged() {
        this.verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED, OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED);
    }

    public void testPollerStarting() {
        this.anticipateMonitorStarted();
        this.expectLocationMonitorStarted();
        this.replayMocks();
        this.m_backEnd.pollerStarting(1, this.m_pollerDetails);
        this.verifyMocks();
    }

    public void testPollerStopping() {
        this.anticipateMonitorStoppedEvent();
        this.expectLocationMonitorStatusChanged(null, OnmsLocationMonitor.MonitorStatus.STOPPED);
        this.replayMocks();
        this.m_backEnd.pollerStopping(1);
        this.verifyMocks();
    }

    public void testPollerStoppingWithBadLocationMonitorId() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn(null);
        this.replayMocks();
        this.m_backEnd.pollerStopping(1);
        this.verifyMocks();
    }

    public void testRegisterLocationMonitor() {
        EasyMock.expect((Object)this.m_locMonDao.findMonitoringLocationDefinition(this.m_locationDefinition.getName())).andReturn((Object)this.m_locationDefinition);
        this.m_locMonDao.save(EasyMock.isA(OnmsLocationMonitor.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                mon.setId(Integer.valueOf(1));
                Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.REGISTERED, (Object)mon.getStatus());
                return null;
            }
        });
        this.anticipateMonitorRegisteredEvent();
        this.replayMocks();
        int locationMonitorId = this.m_backEnd.registerLocationMonitor(this.m_locationDefinition.getName());
        this.verifyMocks();
        PollerBackEndTest.assertEquals((int)1, (int)locationMonitorId);
    }

    public void testReportResultWithBadLocationMonitorId() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn(null);
        this.replayMocks();
        this.m_backEnd.reportResult(1, 1, PollStatus.up());
        this.verifyMocks();
    }

    public void testReportResultWithBadServiceId() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)new OnmsLocationMonitor());
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(1))).andReturn(null);
        this.replayMocks();
        this.m_backEnd.reportResult(1, 1, PollStatus.up());
        this.verifyMocks();
    }

    public void testReportResultWithNullPollResult() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andThrow((Throwable)new RuntimeException("crazy location monitor exception"));
        this.replayMocks();
        this.m_backEnd.reportResult(1, 1, null);
        this.verifyMocks();
    }

    public void testStatusChangeFromDownToUp() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn((Object)this.m_dnsCurrentStatus);
        EasyMock.expect((Object)this.m_locMonDao.findMonitoringLocationDefinition(this.m_locationDefinition.getName())).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_locationDefinition.getPollingPackageName())).andReturn((Object)this.m_package);
        PollStatus newStatus = PollStatus.available((Double)1234.0);
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, newStatus);
        this.m_pollerConfig.saveResponseTimeData(Integer.toString(this.m_locationMonitor.getId()), this.m_dnsService, 1234.0, this.m_package);
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/nodes/nodeRegainedService", "PollerBackEnd").setMonitoredService(this.m_dnsService).addParam("locationMonitorId", "1");
        this.m_eventIpcManager.sendNow(this.eq(eventBuilder.getEvent()));
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        this.replayMocks();
        this.m_backEnd.reportResult(1, 2, newStatus);
        this.verifyMocks();
    }

    public void testStatusChangeFromUpToDown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_httpService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_httpService)).andReturn((Object)this.m_httpCurrentStatus);
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/nodes/nodeLostService", "PollerBackEnd").setMonitoredService(this.m_httpService).addParam("locationMonitorId", "1");
        this.m_eventIpcManager.sendNow(this.eq(eventBuilder.getEvent()));
        PollStatus newStatus = PollStatus.unavailable((String)"Test Down");
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_httpService, newStatus);
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        this.replayMocks();
        this.m_backEnd.reportResult(1, 1, newStatus);
        this.verifyMocks();
    }

    public void testStatusDownWhenDown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn((Object)this.m_dnsCurrentStatus);
        PollStatus newStatus = PollStatus.unavailable((String)"Still Down");
        this.replayMocks();
        this.m_backEnd.reportResult(1, 2, newStatus);
        this.verifyMocks();
    }

    public void testStatusDownWhenNoneKnown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn(null);
        PollStatus newStatus = PollStatus.unavailable((String)"where'd he go?");
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, newStatus);
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/remote/nodes/nodeLostService", "PollerBackEnd").setMonitoredService(this.m_dnsService).addParam("locationMonitorId", "1");
        this.m_eventIpcManager.sendNow(this.eq(eventBuilder.getEvent()));
        this.replayMocks();
        this.m_backEnd.reportResult(1, 2, newStatus);
        this.verifyMocks();
    }

    public void testStatusUpWhenNoneKnown() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(2))).andReturn((Object)this.m_dnsService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_dnsService)).andReturn(null);
        EasyMock.expect((Object)this.m_locMonDao.findMonitoringLocationDefinition(this.m_locationDefinition.getName())).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_locationDefinition.getPollingPackageName())).andReturn((Object)this.m_package);
        PollStatus newStatus = PollStatus.available((Double)1234.0);
        OnmsLocationSpecificStatus expectedStatus = new OnmsLocationSpecificStatus(this.m_locationMonitor, this.m_dnsService, newStatus);
        this.m_pollerConfig.saveResponseTimeData(Integer.toString(this.m_locationMonitor.getId()), this.m_dnsService, 1234.0, this.m_package);
        this.m_locMonDao.saveStatusChange((OnmsLocationSpecificStatus)EasyMock.isA(OnmsLocationSpecificStatus.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new StatusChecker(expectedStatus));
        this.replayMocks();
        this.m_backEnd.reportResult(1, 2, newStatus);
        this.verifyMocks();
    }

    public void testStatusUpWhenUp() {
        EasyMock.expect((Object)this.m_locMonDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_locationMonitor);
        EasyMock.expect((Object)this.m_monSvcDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.m_httpService);
        EasyMock.expect((Object)this.m_locMonDao.getMostRecentStatusChange(this.m_locationMonitor, this.m_httpService)).andReturn((Object)this.m_httpCurrentStatus);
        PollStatus newStatus = PollStatus.available((Double)1776.0);
        EasyMock.expect((Object)this.m_locMonDao.findMonitoringLocationDefinition(this.m_locationDefinition.getName())).andReturn((Object)this.m_locationDefinition);
        EasyMock.expect((Object)this.m_pollerConfig.getPackage(this.m_locationDefinition.getPollingPackageName())).andReturn((Object)this.m_package);
        this.m_pollerConfig.saveResponseTimeData(Integer.toString(this.m_locationMonitor.getId()), this.m_httpService, 1776.0, this.m_package);
        this.replayMocks();
        this.m_backEnd.reportResult(1, 1, newStatus);
        this.verifyMocks();
    }

    public void testTimeOutOnCheckin() {
        final Date now = new Date();
        this.m_locationMonitor.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        this.m_locationMonitor.setLastCheckInTime(new Date(now.getTime() - 300000L - 100L));
        EasyMock.expect((Object)this.m_locMonDao.findAll()).andReturn(Collections.singletonList(this.m_locationMonitor));
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)now);
        this.anticipateDisconnectedEvent();
        this.m_locMonDao.update((Object)this.m_locationMonitor);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsLocationMonitor mon = (OnmsLocationMonitor)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((Object)OnmsLocationMonitor.MonitorStatus.DISCONNECTED, (Object)mon.getStatus());
                Assert.assertTrue((boolean)mon.getLastCheckInTime().before(new Date(now.getTime() - 300000L)));
                return null;
            }
        });
        this.replayMocks();
        this.m_backEnd.checkForDisconnectedMonitors();
        this.verifyMocks();
    }

    private void updateConfiguration() {
        EasyMock.expect((Object)this.m_timeKeeper.getCurrentDate()).andReturn((Object)new Date());
        this.replayMocks();
        this.m_backEnd.configurationUpdated();
        this.verifyMocks();
    }

    private void verifyMocks() {
        EasyMock.verify((Object[])new Object[]{this.m_locMonDao, this.m_monSvcDao, this.m_pollerConfig, this.m_scheduler, this.m_timeKeeper, this.m_eventIpcManager});
        EasyMock.reset((Object[])new Object[]{this.m_locMonDao, this.m_monSvcDao, this.m_pollerConfig, this.m_scheduler, this.m_timeKeeper, this.m_eventIpcManager});
    }

    private void verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus oldStatus, OnmsLocationMonitor.MonitorStatus newStatus, OnmsLocationMonitor.MonitorStatus result) {
        this.verifyPollerCheckingIn(oldStatus, newStatus, result, null);
    }

    private void verifyPollerCheckingIn(OnmsLocationMonitor.MonitorStatus oldStatus, OnmsLocationMonitor.MonitorStatus newStatus, OnmsLocationMonitor.MonitorStatus result, Event e) {
        this.m_locationMonitor.setStatus(oldStatus);
        this.expectLocationMonitorStatusChanged(oldStatus, newStatus);
        if (e != null) {
            this.anticipateEvent(e);
        }
        this.replayMocks();
        PollerBackEndTest.assertEquals((String)"Unexpected result state", (Object)result, (Object)this.m_backEnd.pollerCheckingIn(1, this.m_startTime));
        this.verifyMocks();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StatusChecker
    implements IAnswer<Object> {
        private OnmsLocationSpecificStatus m_status;

        private StatusChecker(OnmsLocationSpecificStatus status) {
            this.m_status = status;
        }

        public Object answer() throws Throwable {
            OnmsLocationSpecificStatus status = (OnmsLocationSpecificStatus)EasyMock.getCurrentArguments()[0];
            Assert.assertEquals((Object)this.m_status.getLocationMonitor(), (Object)status.getLocationMonitor());
            Assert.assertEquals((Object)this.m_status.getMonitoredService(), (Object)status.getMonitoredService());
            Assert.assertEquals((int)this.m_status.getPollResult().getStatusCode(), (int)status.getPollResult().getStatusCode());
            Assert.assertEquals((Object)this.m_status.getPollResult().getResponseTime(), (Object)status.getPollResult().getResponseTime());
            Assert.assertEquals((String)this.m_status.getPollResult().getReason(), (String)status.getPollResult().getReason());
            return null;
        }
    }

    public static class EventEquals
    implements IArgumentMatcher {
        private Event m_expected;

        EventEquals(Event value) {
            this.m_expected = value;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append(this.m_expected);
        }

        public boolean matches(Object argument) {
            Event actual = (Event)argument;
            if (this.m_expected == null) {
                return actual == null;
            }
            return this.m_expected.getUei().equals(actual.getUei()) && this.nullSafeEquals(this.m_expected.getSource(), actual.getSource()) && this.m_expected.getNodeid() == actual.getNodeid() && this.nullSafeEquals(this.m_expected.getInterface(), actual.getInterface()) && this.nullSafeEquals(this.m_expected.getService(), actual.getService()) && EventUtils.getLongParm((Event)this.m_expected, (String)"locationMonitorId", (long)-1L) == EventUtils.getLongParm((Event)actual, (String)"locationMonitorId", (long)-1L);
        }

        private boolean nullSafeEquals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }
}

