/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.JUnitHttpServerExecutionListener;
import org.opennms.core.test.annotations.JUnitHttpServer;
import org.opennms.core.test.annotations.Webapp;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.PageSequenceMonitor;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, JUnitHttpServerExecutionListener.class})
@ContextConfiguration(locations={"classpath:META-INF/opennms/emptyContext.xml"})
@JUnitHttpServer(port=10342)
public class PageSequenceMonitorTest {
    PageSequenceMonitor m_monitor;
    Map<String, Object> m_params;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_monitor = new PageSequenceMonitor();
        this.m_monitor.initialize(Collections.emptyMap());
        this.m_params = new HashMap<String, Object>();
        this.m_params.put("timeout", "8000");
        this.m_params.put("retries", "1");
    }

    protected MonitoredService getHttpService(String hostname) throws Exception {
        return this.getHttpService(hostname, InetAddress.getByName(hostname).getHostAddress());
    }

    protected MonitoredService getHttpService(String hostname, String ip) throws Exception {
        MockMonitoredService svc = new MockMonitoredService(1, hostname, ip, "HTTP");
        this.m_monitor.initialize((MonitoredService)svc);
        return svc;
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testSimple() throws Exception {
        this.setPageSequenceParam("localhost");
        PollStatus googleStatus = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
    }

    @Test
    public void testSimpleBogus() throws Exception {
        this.setPageSequenceParam(null);
        this.m_params.put("timeout", "500");
        this.m_params.put("retries", "0");
        PollStatus notLikely = this.m_monitor.poll(this.getHttpService("bogus", "1.1.1.1"), this.m_params);
        Assert.assertTrue((String)"should not be available", (boolean)notLikely.isUnavailable());
    }

    private void setPageSequenceParam(String virtualHost) {
        String virtualHostParam = virtualHost == null ? "" : "virtual-host=\"" + virtualHost + "\"";
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/index.html\" port=\"10342\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"It was written by monkeys.\" " + virtualHostParam + "/>\n" + "</page-sequence>\n");
    }

    @Test
    public void testHttps() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page scheme=\"https\" path=\"/ws/eBayISAPI.dll?RegisterEnterInfo\" port=\"443\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"Hi! Ready to register with eBay?\" virtual-host=\"support.opennms.com\"/>\n</page-sequence>\n");
        PollStatus googleStatus = this.m_monitor.poll(this.getHttpService("scgi.ebay.com"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLogin() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page virtual-host=\"localhost\" path=\"/opennms/\" port=\"10342\" successMatch=\"Password\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\">\n    <parameter key=\"j_username\" value=\"demo\"/>\n    <parameter key=\"j_password\" value=\"demo\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    public void testVirtualHost() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page user-agent=\"Donald\" path=\"/\" port=\"80\" successMatch=\"Get the Network to Work\" virtual-host=\"www.opennms.com\"/>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("www.opennms.com"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    public void testVirtualHostBadBehaviorForWordpressPlugin() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/\" port=\"80\" successMatch=\"Get the Network to Work\" user-agent=\"Jakarta Commons-HttpClient/3.0.1\" virtual-host=\"www.opennms.com\"/>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("www.opennms.com"), this.m_params);
        Assert.assertTrue((String)("Expected unavailable but was " + status + ": reason = " + status.getReason()), (boolean)status.isDown());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLoginDynamicCredentials() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLoginDynamicCredentialsTwice() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&gt;Login (.)(.)(.)(.) Username and Password&lt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\"  response-range=\"300-399\" port=\"10342\" method=\"POST\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/spring_security_login?login_error\"  port=\"10342\" method=\"POST\" failureMatch=\"(?s)Log out\" failureMessage=\"Login should have Failed but did not\" successMatch=\"(?s)Your login attempt was not successful.*\" />\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\"  response-range=\"300-399\" port=\"10342\" method=\"POST\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLoginDynamicCredentialsRedirectPost() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" failureMatch=\"(?s)Your login attempt was not successful.*Reason: ([^&lt;]*)\" failureMessage=\"Login in Failed: ${1}\" successMatch=\"Log out\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.m_params.entrySet()) {
            params.put(entry.getKey(), entry.getValue());
        }
        params.put("redirect-post", "true");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testRedirectLocationMatch() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\" locationMatch=\"/opennms/\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testRedirectLocationDoesNotMatch() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\" locationMatch=\"/opensadfnms/\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected down but was " + status + ": reason = " + status.getReason()), (boolean)status.isDown());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testDsNamePerPage() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" ds-name=\"test1\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"&lt;title&gt;(.*?)&lt;/title&gt;\" />\n  <page path=\"/opennms/j_spring_security_check\" ds-name=\"test2\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"&lt;title&gt;(.*?)&lt;/title&gt;\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
        Assert.assertTrue((String)"Expected three DSes", (3 == status.getProperties().size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected a DS called 'test1' but did not find one", (boolean)status.getProperties().containsKey("test1"));
        Assert.assertTrue((String)"Expected a DS called 'test2' but did not find one", (boolean)status.getProperties().containsKey("test2"));
    }
}

