/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.JUnitHttpServerExecutionListener;
import org.opennms.core.test.annotations.JUnitHttpServer;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.HttpMonitor;
import org.opennms.netmgt.poller.monitors.HttpsMonitor;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, TransactionalTestExecutionListener.class, JUnitHttpServerExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
public class HttpMonitorTest {
    private boolean m_runTests = true;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testParms() {
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        Value parmValue = new Value();
        Assert.assertTrue((eventParms.getParmCount() == 0 ? 1 : 0) != 0);
        eventParm.setParmName("test");
        parmValue.setContent("test value");
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        Assert.assertTrue((eventParms.getParmCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((eventParms.getParm(0).getParmName() == "test" ? 1 : 0) != 0);
        Assert.assertTrue((eventParms.getParm(0).getValue().getContent() == "test value" ? 1 : 0) != 0);
    }

    @Test
    public void testPollStatusReason() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(99, "www.opennms.org", "HTTP");
        p.setKey("port");
        p.setValue("3020");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testResponseRange() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "localhost", "HTTP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-199");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
        p.setKey("response");
        p.setValue("100,200,302,400-500");
        m.put(p.getKey(), p.getValue());
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        p.setKey("response");
        p.setValue("*");
        m.put(p.getKey(), p.getValue());
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testMatchingTextInResponse() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "localhost", "HTTP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-499");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("opennmsrulz");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
        p.setKey("response-text");
        p.setValue("written by monkeys");
        m.put(p.getKey(), p.getValue());
        MockUtil.println((String)"\nliteral text check: \"written by monkeys\"");
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        p.setKey("response-text");
        p.setValue("~.*[Tt]est HTTP [Ss]erver.*");
        m.put(p.getKey(), p.getValue());
        MockUtil.println((String)"\nregex check: \".*[Tt]est HTTP [Ss]erver.*\"");
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    public void testBase64Encoding() {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        p.setKey("basic-authentication");
        p.setValue("Aladdin:open sesame");
        m.put(p.getKey(), p.getValue());
        Assert.assertEquals((Object)"QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (Object)monitor.determineBasicAuthentication(m));
        Assert.assertFalse((boolean)"QWxhZGRpbjpvcZVuIHNlc2FtZQ==".equals(monitor.determineBasicAuthentication(m)));
    }

    private MonitoredService getMonitoredService(int nodeId, String hostname, String svcName) throws UnknownHostException {
        return new MockMonitoredService(nodeId, hostname, InetAddress.getByName(hostname).getHostAddress(), svcName);
    }

    @Test
    @JUnitHttpServer(port=10342, basicAuth=true)
    public void testBasicAuthentication() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(1, "localhost", "HTTP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-302");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/");
        m.put(p.getKey(), p.getValue());
        p.setKey("basic-authentication");
        p.setValue("admin:istrator");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        p.setKey("basic-authentication");
        p.setValue("admin:flagrator");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342, https=true)
    public void testBasicAuthenticationWithHttps() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpsMonitor monitor = new HttpsMonitor();
        MonitoredService svc = this.getMonitoredService(1, "localhost", "HTTP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-302");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/index.html");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testWithUrl() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "localhost", "HTTP");
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/twinkies.html");
        m.put(p.getKey(), p.getValue());
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-499");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("~.*Don.t you love twinkies..*");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"opennms.com"})
    public void testPollInInvalidVirtualDomain() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "localhost", "HTTP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("www.google.com");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/twinkies.html");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("~.*twinkies.*");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll(svc, m);
        Assert.assertEquals((String)"poll status available", (long)2L, (long)status.getStatusCode());
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"www.opennms.org"})
    public void testPollInValidVirtualDomain() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "localhost", "HTTP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("www.opennms.org");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/twinkies.html");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("~.*twinkies.*");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll(svc, m);
        Assert.assertEquals((String)"poll status not available", (long)1L, (long)status.getStatusCode());
    }
}

