/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.FtpMonitor;

public class FtpMonitorTest
extends TestCase {
    private FtpMonitor m_monitor = new FtpMonitor();
    private ServerSocket m_serverSocket = null;
    private Thread m_serverThread = null;
    private static int TIMEOUT = 2000;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_serverSocket = new ServerSocket();
        this.m_serverSocket.bind(null);
    }

    protected void tearDown() throws Exception {
        if (this.m_serverSocket != null && !this.m_serverSocket.isClosed()) {
            this.m_serverSocket.close();
        }
        if (this.m_serverThread != null) {
            this.m_serverThread.join(1500L);
        }
        super.tearDown();
    }

    public void SKIPtestMonitorOnOpennmsOrgFtpSuccess() throws Exception {
        PollStatus status = this.m_monitor.poll((MonitoredService)new MockMonitoredService(1, "Node One", InetAddress.getByName("ftp.opennms.org").getHostAddress(), "FTP"), new HashMap());
        FtpMonitorTest.assertTrue((String)("status should be available (Up), but is: " + status), (boolean)status.isAvailable());
    }

    public void SKIPtestMonitorFailureOnRandomFtp() throws Exception {
        PollStatus status = this.m_monitor.poll((MonitoredService)new MockMonitoredService(1, "Node One", "1.1.1.1", "FTP"), new HashMap());
        FtpMonitorTest.assertTrue((String)("status should be unavailable (Down), but is: " + status), (boolean)status.isUnavailable());
    }

    public void testMonitorSuccess() throws Exception {
        Thread m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = FtpMonitorTest.this.m_serverSocket.accept();
                    s.getOutputStream().write("220 Hello!!!\r\n".getBytes());
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    if (command.equals("QUIT")) {
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        m_serverThread.start();
        PollStatus status = this.doPoll();
        FtpMonitorTest.assertTrue((String)("status should be available (Up), but is: " + status), (boolean)status.isAvailable());
    }

    public void testMonitorFailureWithBogusResponse() throws Exception {
        Thread m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = FtpMonitorTest.this.m_serverSocket.accept();
                    s.getOutputStream().write("Go away!".getBytes());
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        m_serverThread.start();
        PollStatus status = this.doPoll();
        FtpMonitorTest.assertTrue((String)("status should be unavailable (Down), but is: " + status), (boolean)status.isUnavailable());
    }

    public void testMonitorFailureWithNoResponse() throws Exception {
        Thread m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    FtpMonitorTest.this.m_serverSocket.accept();
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        m_serverThread.start();
        PollStatus status = this.doPoll();
        FtpMonitorTest.assertTrue((String)("status should be unavailable (Down), but is: " + status), (boolean)status.isUnavailable());
    }

    public void testMonitorFailureWithClosedPort() throws Exception {
        this.m_serverSocket.close();
        PollStatus status = this.doPoll();
        FtpMonitorTest.assertTrue((String)("status should be unavailable (Down), but is: " + status), (boolean)status.isUnavailable());
    }

    private PollStatus doPoll() throws UnknownHostException {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("port", this.m_serverSocket.getLocalPort());
        m.put("retries", 0);
        m.put("timeout", TIMEOUT);
        PollStatus status = this.m_monitor.poll((MonitoredService)new MockMonitoredService(1, "Node One", this.m_serverSocket.getInetAddress().getHostAddress(), "FTP"), m);
        return status;
    }
}

