/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.NotificationTask;
import org.opennms.netmgt.notifd.NotificationsTestCase;
import org.opennms.netmgt.xml.event.Event;

public class TaskCreationTest
extends NotificationsTestCase {
    private static final int INTERVAL = 1000;
    private BroadcastEventProcessor m_eventProcessor;
    private Notification m_notif;
    private Map<String, String> m_params;
    private String[] m_commands;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_eventProcessor = this.m_notifd.getBroadcastEventProcessor();
        this.m_notif = this.m_notificationManager.getNotification("nodeDown");
        MockNode node = this.m_network.getNode(1);
        Event nodeDownEvent = node.createDownEvent();
        this.m_params = BroadcastEventProcessor.buildParameterMap((Notification)this.m_notif, (Event)nodeDownEvent, (int)1);
        this.m_commands = new String[]{"email"};
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testMakeEmailTask() throws Exception {
        long startTime = this.now();
        NotificationTask task = this.m_eventProcessor.makeEmailTask(startTime, this.m_params, 1, "brozow@opennms.org", this.m_commands, new LinkedList(), null);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"brozow@opennms.org", (Object)task.getEmail());
        Assert.assertEquals((long)startTime, (long)task.getSendTime());
    }

    private long now() {
        return System.currentTimeMillis();
    }

    @Test
    public void testMakeUserTask() throws Exception {
        long startTime = this.now();
        NotificationTask task = this.m_eventProcessor.makeUserTask(startTime, this.m_params, 1, "brozow", this.m_commands, new LinkedList(), null);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"brozow@opennms.org", (Object)task.getEmail());
        Assert.assertEquals((long)startTime, (long)task.getSendTime());
    }

    private void assertTasksWithEmail(NotificationTask[] tasks, String ... emails) throws Exception {
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((String)"Unexpected number of tasks", (long)emails.length, (long)tasks.length);
        for (String email : emails) {
            Assert.assertNotNull((String)("Expected to find a task with email " + email + " in " + tasks), (Object)this.findTaskWithEmail(tasks, email));
        }
    }

    private void assertStartInterval(NotificationTask[] tasks, long startTime, long interval) {
        Assert.assertNotNull((Object)tasks);
        long expectedTime = startTime;
        for (NotificationTask task : tasks) {
            Assert.assertEquals((String)("Expected task " + task + " to have sendTime " + expectedTime), (long)expectedTime, (long)task.getSendTime());
            expectedTime += interval;
        }
    }

    @Test
    public void testMakeGroupTasks() throws Exception {
        long startTime = this.now();
        NotificationTask[] tasks = this.m_eventProcessor.makeGroupTasks(startTime, this.m_params, 1, "EscalationGroup", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(tasks, "brozow@opennms.org", "david@opennms.org");
        this.assertStartInterval(tasks, startTime, 1000L);
    }

    @Test
    public void testMakeGroupTasksWithDutySchedule() throws Exception {
        String groupName = "EscalationGroup";
        Group group = this.m_groupManager.getGroup("EscalationGroup");
        group.addDutySchedule("MoTuWeThFr0900-1700");
        this.m_groupManager.saveGroups();
        long dayTime = this.getTimeStampFor("21-FEB-2005 11:59:56");
        NotificationTask[] dayTasks = this.m_eventProcessor.makeGroupTasks(dayTime, this.m_params, 1, "EscalationGroup", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(dayTasks, "brozow@opennms.org", "david@opennms.org");
        this.assertStartInterval(dayTasks, dayTime, 1000L);
        long nightTime = this.getTimeStampFor("21-FEB-2005 23:00:00");
        NotificationTask[] nightTasks = this.m_eventProcessor.makeGroupTasks(nightTime, this.m_params, 1, "EscalationGroup", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(nightTasks, "brozow@opennms.org", "david@opennms.org");
        this.assertStartInterval(nightTasks, nightTime + 36000000L, 1000L);
    }

    @Test
    public void testMakeRoleTasks() throws Exception {
        long dayTime = this.getTimeStampFor("21-FEB-2005 11:59:56");
        NotificationTask[] tasks = this.m_eventProcessor.makeRoleTasks(dayTime, this.m_params, 1, "oncall", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(tasks, "brozow@opennms.org");
        this.assertStartInterval(tasks, dayTime, 1000L);
        long sundayTime = this.getTimeStampFor("30-JAN-2005 11:59:56");
        NotificationTask[] sundayTasks = this.m_eventProcessor.makeRoleTasks(sundayTime, this.m_params, 1, "oncall", this.m_commands, new LinkedList(), null, 1000L);
        this.assertTasksWithEmail(sundayTasks, "brozow@opennms.org", "admin@opennms.org");
        this.assertStartInterval(sundayTasks, sundayTime, 1000L);
    }

    private long getTimeStampFor(String timeString) throws ParseException {
        return new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(timeString).getTime();
    }

    private NotificationTask findTaskWithEmail(NotificationTask[] tasks, String email) throws Exception {
        Assert.assertNotNull((Object)email);
        for (NotificationTask task : tasks) {
            Assert.assertNotNull((Object)task);
            if (!email.equals(task.getEmail())) continue;
            return task;
        }
        return null;
    }
}

