/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.opennms.netmgt.mock.EventWriter;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.Outage;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.Parameter;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.SingleResultQuerier;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockDatabase
extends TemporaryDatabase
implements EventWriter {
    public MockDatabase(String dbName) throws Exception {
        this(dbName, true);
    }

    public MockDatabase() throws Exception {
        this(true);
    }

    public MockDatabase(String name, boolean createNow) throws Exception {
        super(name);
        this.setPopulateSchema(true);
        if (createNow) {
            this.create();
        }
    }

    public MockDatabase(boolean createNow) throws Exception {
        this.setPopulateSchema(true);
        if (createNow) {
            this.create();
        }
    }

    public void populate(MockNetwork network) {
        MockVisitorAdapter dbCreater = new MockVisitorAdapter(){

            public void visitNode(MockNode node) {
                MockDatabase.this.writeNode(node);
            }

            public void visitInterface(MockInterface iface) {
                MockDatabase.this.writeInterface(iface);
            }

            public void visitService(MockService svc) {
                MockDatabase.this.writeService(svc);
            }
        };
        network.visit((MockVisitor)dbCreater);
        this.getJdbcTemplate().queryForInt("SELECT setval('nodeNxtId', max(nodeid)) FROM node", new Object[0]);
    }

    public void writeNode(MockNode node) {
        Object[] values = new Object[]{new Integer(node.getNodeId()), node.getLabel(), new Timestamp(System.currentTimeMillis()), "A"};
        this.update("insert into node (dpName, nodeID, nodeLabel, nodeCreateTime, nodeType) values ('localhost', ?, ?, ?, ?);", values);
    }

    public void writeInterface(MockInterface iface) {
        this.writeSnmpInterface(iface);
        Object[] values = new Object[]{new Integer(iface.getNodeId()), iface.getIpAddr(), iface.getIfIndex(), iface.getIfIndex() == 1 ? "P" : "N", "A"};
        this.update("insert into ipInterface (nodeID, ipAddr, ifIndex, isSnmpPrimary, isManaged) values (?, ?, ?, ?, ?);", values);
    }

    public void writeSnmpInterface(MockInterface iface) {
        Object[] values = new Object[]{new Integer(iface.getNodeId()), iface.getIpAddr(), iface.getIfAlias(), iface.getIfIndex()};
        this.update("insert into snmpInterface (nodeID, ipAddr, snmpifAlias, snmpIfIndex) values (?, ?, ?, ?);", values);
    }

    public void writeService(MockService svc) {
        String svcName = svc.getSvcName();
        if (!this.serviceDefined(svcName)) {
            Object[] svcValues = new Object[]{new Integer(svc.getId()), svcName};
            this.getNextServiceId();
            this.update("insert into service (serviceID, serviceName) values (?, ?);", svcValues);
        }
        String status = svc.getMgmtStatus().toDbString();
        Object[] values = new Object[]{new Integer(svc.getNodeId()), svc.getIpAddr(), new Integer(svc.getId()), status};
        this.update("insert into ifServices (nodeID, ipAddr, serviceID, status) values (?, ?, ?, ?);", values);
    }

    private boolean serviceDefined(String svcName) {
        Querier querier = new Querier((DataSource)((Object)this), "select serviceId from service where serviceName = ?");
        querier.execute(new Object[]{svcName});
        return querier.getCount() > 0;
    }

    public String getNextOutageIdStatement() {
        return this.getNextSequenceValStatement("outageNxtId");
    }

    public Integer getNextOutageId() {
        return this.getNextId(this.getNextOutageIdStatement());
    }

    public String getNextEventIdStatement() {
        return this.getNextSequenceValStatement("eventsNxtId");
    }

    public Integer getNextEventId() {
        return this.getNextId(this.getNextEventIdStatement());
    }

    public String getNextServiceIdStatement() {
        return this.getNextSequenceValStatement("serviceNxtId");
    }

    public Integer getNextServiceId() {
        return this.getNextId(this.getNextServiceIdStatement());
    }

    public Integer getServiceID(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        SingleResultQuerier querier = new SingleResultQuerier((DataSource)((Object)this), "select serviceId from service where serviceName = ?");
        querier.execute(new Object[]{serviceName});
        return (Integer)querier.getResult();
    }

    public String getServiceName(int serviceId) {
        SingleResultQuerier querier = new SingleResultQuerier((DataSource)((Object)this), "select serviceName from service where serviceId = ?");
        querier.execute(new Object[]{new Integer(serviceId)});
        return (String)querier.getResult();
    }

    public int countOutagesForService(MockService svc) {
        return this.countOutagesForService(svc, null);
    }

    public int countOpenOutagesForService(MockService svc) {
        return this.countOutagesForService(svc, "ifRegainedService is null");
    }

    public int countOutagesForService(MockService svc, String criteria) {
        String critSql = criteria == null ? "" : " and " + criteria;
        Object[] values = new Object[]{new Integer(svc.getNodeId()), svc.getIpAddr(), new Integer(svc.getId())};
        return this.countRows("select * from outages where nodeId = ? and ipAddr = ? and serviceId = ?" + critSql, values);
    }

    public void createOutage(MockService svc, Event svcLostEvent) {
        this.createOutage(svc, svcLostEvent.getDbid(), this.convertEventTimeToTimeStamp(svcLostEvent.getTime()));
    }

    public void createOutage(MockService svc, int eventId, Timestamp time) {
        Object[] values = new Object[]{this.getNextOutageId(), new Integer(eventId), new Integer(svc.getNodeId()), svc.getIpAddr(), new Integer(svc.getId()), time};
        this.update("insert into outages (outageId, svcLostEventId, nodeId, ipAddr, serviceId, ifLostService) values (?, ?, ?, ?, ?, ?);", values);
    }

    public void resolveOutage(MockService svc, Event svcRegainEvent) {
        this.resolveOutage(svc, svcRegainEvent.getDbid(), this.convertEventTimeToTimeStamp(svcRegainEvent.getTime()));
    }

    public void resolveOutage(MockService svc, int eventId, Timestamp timestamp) {
        Object[] values = new Object[]{new Integer(eventId), timestamp, new Integer(svc.getNodeId()), svc.getIpAddr(), new Integer(svc.getId())};
        this.update("UPDATE outages set svcRegainedEventID=?, ifRegainedService=? where (nodeid = ? AND ipAddr = ? AND serviceID = ? and (ifRegainedService IS NULL));", values);
    }

    public Timestamp convertEventTimeToTimeStamp(String time) {
        try {
            Date date = EventConstants.parseToDate((String)time);
            Timestamp eventTime = new Timestamp(date.getTime());
            return eventTime;
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date format " + time, e);
        }
    }

    @Override
    public void writeEvent(Event e) {
        Integer eventId = this.getNextEventId();
        if (e.getCreationTime() == null) {
            e.setCreationTime(e.getTime());
        }
        Object[] values = new Object[]{eventId, e.getSource(), e.getUei(), this.convertEventTimeToTimeStamp(e.getCreationTime()), this.convertEventTimeToTimeStamp(e.getTime()), new Integer(OnmsSeverity.get((String)e.getSeverity()).getId()), e.hasNodeid() ? new Long(e.getNodeid()) : null, e.getInterface(), this.getServiceID(e.getService()), "localhost", "Y", "Y", e.getTticket() == null ? "" : e.getTticket().getContent(), Integer.valueOf(e.getTticket() == null ? "0" : e.getTticket().getState()), e.getParms() == null ? null : Parameter.format((Parms)e.getParms())};
        e.setDbid(eventId.intValue());
        this.update("insert into events (eventId, eventSource, eventUei, eventCreateTime, eventTime, eventSeverity, nodeId, ipAddr, serviceId, eventDpName, eventLog, eventDisplay, eventtticket, eventtticketstate, eventparms) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);", values);
    }

    public void setServiceStatus(MockService svc, char newStatus) {
        Object[] values = new Object[]{String.valueOf(newStatus), new Integer(svc.getNodeId()), svc.getIpAddr(), new Integer(svc.getId())};
        this.update("update ifServices set status = ? where nodeId = ? and ipAddr = ? and serviceId = ?", values);
    }

    public char getServiceStatus(MockService svc) {
        SingleResultQuerier querier = new SingleResultQuerier((DataSource)((Object)this), "select status from ifServices where nodeId = ? and ipAddr = ? and serviceID = ?");
        querier.execute(new Object[]{new Integer(svc.getNodeId()), svc.getIpAddr(), new Integer(svc.getId())});
        String result = (String)querier.getResult();
        if (result == null || "".equals(result)) {
            return 'X';
        }
        return result.charAt(0);
    }

    public void setInterfaceStatus(MockInterface iface, char newStatus) {
        Object[] values = new Object[]{String.valueOf(newStatus), new Integer(iface.getNodeId()), iface.getIpAddr()};
        this.update("update ipInterface set isManaged = ? where nodeId = ? and ipAddr = ?;", values);
    }

    public char getInterfaceStatus(MockInterface iface) {
        SingleResultQuerier querier = new SingleResultQuerier((DataSource)((Object)this), "select isManaged from ipInterface where nodeId = ? and ipAddr = ?");
        querier.execute(new Object[]{new Integer(iface.getNodeId()), iface.getIpAddr()});
        String result = (String)querier.getResult();
        if (result == null || "".equals(result)) {
            return 'X';
        }
        return result.charAt(0);
    }

    public int countOutages() {
        return this.countOutages(null);
    }

    public int countOpenOutages() {
        return this.countOutages("ifRegainedService is null");
    }

    public int countOutages(String criteria) {
        String critSql = criteria == null ? "" : " where " + criteria;
        return this.countRows("select * from outages" + critSql, new Object[0]);
    }

    public int countOutagesForInterface(MockInterface iface) {
        return this.countOutagesForInterface(iface, null);
    }

    public int countOpenOutagesForInterface(MockInterface iface) {
        return this.countOutagesForInterface(iface, "ifRegainedService is null");
    }

    public int countOutagesForInterface(MockInterface iface, String criteria) {
        String critSql = criteria == null ? "" : " and " + criteria;
        Object[] values = new Object[]{new Integer(iface.getNodeId()), iface.getIpAddr()};
        return this.countRows("select * from outages where nodeId = ? and ipAddr = ? " + critSql, values);
    }

    public boolean hasOpenOutage(MockService svc) {
        return this.countOpenOutagesForService(svc) > 0;
    }

    public Collection<Outage> getOutages() {
        return this.getOutages(null, new Object[0]);
    }

    public Collection<Outage> getOutages(String criteria, Object ... values) {
        String critSql = criteria == null ? "" : " where " + criteria;
        final LinkedList<Outage> outages = new LinkedList<Outage>();
        Querier loadExisting = new Querier((DataSource)((Object)this), "select * from outages " + critSql){

            public void processRow(ResultSet rs) throws SQLException {
                boolean open;
                Outage outage = new Outage(rs.getInt("nodeId"), rs.getString("ipAddr"), rs.getInt("serviceId"));
                outage.setLostEvent(rs.getInt("svcLostEventID"), rs.getTimestamp("ifLostService"));
                boolean bl = open = rs.getObject("ifRegainedService") == null;
                if (!open) {
                    outage.setRegainedEvent(rs.getInt("svcRegainedEventID"), rs.getTimestamp("ifRegainedService"));
                }
                outages.add(outage);
            }
        };
        loadExisting.execute(values);
        Querier setServiceNames = new Querier((DataSource)((Object)this), "select * from service"){

            public void processRow(ResultSet rs) throws SQLException {
                int serviceId = rs.getInt("serviceId");
                String serviceName = rs.getString("serviceName");
                for (Outage outage : outages) {
                    if (outage.getServiceId() != serviceId) continue;
                    outage.setServiceName(serviceName);
                }
            }
        };
        setServiceNames.execute(new Object[0]);
        return outages;
    }

    public Collection<Outage> getOpenOutages(MockService svc) {
        return this.getOutages("nodeId = ? and ipAddr = ? and serviceID = ? and ifRegainedService is null", svc.getNodeId(), svc.getIpAddr(), svc.getId());
    }

    public Collection<Outage> getOutages(MockService svc) {
        return this.getOutages("nodeId = ? and ipAddr = ? and serviceID = ?", svc.getNodeId(), svc.getIpAddr(), svc.getId());
    }

    public Collection<Outage> getClosedOutages(MockService svc) {
        return this.getOutages("nodeId = ? and ipAddr = ? and serviceID = ? and ifRegainedService is not null", svc.getNodeId(), svc.getIpAddr(), svc.getId());
    }

    public void reparentInterface(String ipAddr, int oldNode, int newNode) {
        this.update("delete from snmpInterface where id in (select oldif.id from snmpinterface as oldIf     where exists(         select * from snmpinterface as newIf         join ipinterface ip           on oldif.id = ip.snmpinterfaceid         where            newIf.nodeId = ? and            oldIf.nodeId = ? and            ip.ipaddr = ? and            oldIf.snmpifindex = newif.snmpifindex        ))", new Object[]{newNode, oldNode, ipAddr});
        this.update("update snmpInterface set nodeId = ? where id in (select snmpInterfaceId from ipInterface where nodeId = ? and ipAddr = ?)", new Object[]{newNode, oldNode, ipAddr});
        this.update("update ipInterface set nodeId = ? where nodeId = ? and ipAddr = ?", new Object[]{newNode, oldNode, ipAddr});
        this.update("update ifServices set nodeId = ? where nodeId = ? and ipAddr = ?", new Object[]{newNode, oldNode, ipAddr});
    }

    public String getNextNotifIdSql() {
        return this.getNextSequenceValStatement("notifyNxtId");
    }

    public void acknowledgeNoticesForEvent(Event e) {
        this.update("update notifications set respondTime = ? where eventID = ? and respondTime is null", new Object[]{new Timestamp(System.currentTimeMillis()), e.getDbid()});
    }

    public Collection<Integer> findNoticesForEvent(Event event) {
        final LinkedList<Integer> notifyIds = new LinkedList<Integer>();
        Querier loadExisting = new Querier((DataSource)((Object)this), "select notifyId from notifications where eventID = ?"){

            public void processRow(ResultSet rs) throws SQLException {
                notifyIds.add(rs.getInt(1));
            }
        };
        loadExisting.execute(new Object[]{new Integer(event.getDbid())});
        return notifyIds;
    }

    public Integer getAlarmCount(String reductionKey) {
        SingleResultQuerier querier = new SingleResultQuerier((DataSource)((Object)this), "select counter from alarms where reductionKey = ?");
        querier.execute(new Object[]{reductionKey});
        return (Integer)querier.getResult();
    }

    public Integer getAlarmId(String reductionKey) {
        SingleResultQuerier querier = new SingleResultQuerier((DataSource)((Object)this), "select alarmid from alarms where reductionKey = ?");
        querier.execute(new Object[]{reductionKey});
        return (Integer)querier.getResult();
    }

    public String getNextUserNotifIdSql() {
        return this.getNextSequenceValStatement("userNotifNxtId");
    }
}

