/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.Connection;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.netmgt.eventd.EventdServiceManager;
import org.opennms.netmgt.eventd.JdbcEventdServiceManager;
import org.opennms.netmgt.eventd.processor.JdbcEventWriter;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.trapd.EventConstants;
import org.opennms.netmgt.xml.event.Event;

public class JdbcEventWriterTest
extends PopulatedTemporaryDatabaseTestCase {
    private JdbcEventWriter m_jdbcEventWriter;

    protected void setUp() throws Exception {
        super.setUp();
        JdbcEventdServiceManager eventdServiceManager = new JdbcEventdServiceManager();
        eventdServiceManager.setDataSource(this.getDataSource());
        eventdServiceManager.afterPropertiesSet();
        this.m_jdbcEventWriter = new JdbcEventWriter();
        this.m_jdbcEventWriter.setEventdServiceManager((EventdServiceManager)eventdServiceManager);
        this.m_jdbcEventWriter.setDataSource(this.getDataSource());
        this.m_jdbcEventWriter.setGetNextIdString("SELECT nextval('eventsNxtId')");
        this.m_jdbcEventWriter.afterPropertiesSet();
    }

    public void testNextEventId() {
        int nextId = this.getJdbcTemplate().queryForInt(this.m_jdbcEventWriter.getGetNextIdString(), new Object[0]);
        JdbcEventWriterTest.assertEquals((int)1, (int)nextId);
    }

    public void testWriteEventWithNull() throws Exception {
        EventBuilder bldr = new EventBuilder("testUei", "testSource");
        bldr.setLogDest("logndisplay");
        bldr.addParam("test", "testVal");
        String testVal2 = "valWith\u0000Null\u0000";
        bldr.addParam("test2", "valWith\u0000Null\u0000");
        byte[] bytes = new byte[]{7, -41, 4, 10, 1, 23, 6, 0, 43, 0, 0};
        SnmpValue snmpVal = SnmpUtils.getValueFactory().getOctetString(bytes);
        JdbcEventWriterTest.assertFalse((boolean)snmpVal.isDisplayable());
        bldr.addParam("test3", snmpVal.toString());
        String b64 = EventConstants.toString((String)"base64", (Object)snmpVal);
        bldr.addParam("test", b64);
        this.m_jdbcEventWriter.process(null, bldr.getEvent());
        String parms = (String)this.jdbcTemplate.queryForObject("SELECT eventParms FROM events LIMIT 1", String.class, new Object[0]);
        JdbcEventWriterTest.assertEquals((String)("test=testVal(string,text);test2=valWith%0Null%0(string,text);test3=" + snmpVal.toString() + "(string,text);test=B9cECgEXBgArAAA%61(string,text)"), (String)parms);
    }

    public void testWriteEventDescrWithNull() throws Exception {
        EventBuilder bldr = new EventBuilder("testUei", "testSource");
        bldr.setLogDest("logndisplay");
        bldr.setDescription("abc\u0000def");
        this.m_jdbcEventWriter.process(null, bldr.getEvent());
        String descr = (String)this.jdbcTemplate.queryForObject("SELECT eventDescr FROM events LIMIT 1", String.class, new Object[0]);
        JdbcEventWriterTest.assertEquals((String)"abc%0def", (String)descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEventHostWithNullHost() throws Exception {
        this.jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime) VALUES (nextVal('nodeNxtId'), now())", new Object[0]);
        int nodeId = this.jdbcTemplate.queryForInt("SELECT nodeId FROM node LIMIT 1", new Object[0]);
        this.jdbcTemplate.update("INSERT into ipInterface (nodeId, ipAddr, ipHostname) VALUES (?, ?, ?)", new Object[]{nodeId, "192.168.1.1", "First Interface"});
        Event event = new Event();
        Connection connection = this.getDataSource().getConnection();
        try {
            JdbcEventWriterTest.assertEquals((String)"getHostName should return the hostname for the IP address that was passed", null, (String)this.m_jdbcEventWriter.getEventHost(event, connection));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEventHostWithHostNoNodeId() throws Exception {
        this.jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime) VALUES (nextVal('nodeNxtId'), now())", new Object[0]);
        int nodeId = this.jdbcTemplate.queryForInt("SELECT nodeId FROM node LIMIT 1", new Object[0]);
        this.jdbcTemplate.update("INSERT into ipInterface (nodeId, ipAddr, ipHostname) VALUES (?, ?, ?)", new Object[]{nodeId, "192.168.1.1", "First Interface"});
        Event event = new Event();
        event.setHost("192.168.1.1");
        Connection connection = this.getDataSource().getConnection();
        try {
            JdbcEventWriterTest.assertEquals((String)"getHostName should return the hostname for the IP address that was passed", (String)event.getHost(), (String)this.m_jdbcEventWriter.getEventHost(event, connection));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEventHostWithOneMatch() throws Exception {
        this.jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime) VALUES (nextVal('nodeNxtId'), now())", new Object[0]);
        int nodeId = this.jdbcTemplate.queryForInt("SELECT nodeId FROM node LIMIT 1", new Object[0]);
        this.jdbcTemplate.update("INSERT into ipInterface (nodeId, ipAddr, ipHostname) VALUES (?, ?, ?)", new Object[]{nodeId, "192.168.1.1", "First Interface"});
        Event event = new Event();
        event.setNodeid((long)nodeId);
        event.setHost("192.168.1.1");
        Connection connection = this.getDataSource().getConnection();
        try {
            JdbcEventWriterTest.assertEquals((String)"getHostName should return the hostname for the IP address that was passed", (String)"First Interface", (String)this.m_jdbcEventWriter.getEventHost(event, connection));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetHostNameWithOneMatch() throws Exception {
        this.jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime) VALUES (nextVal('nodeNxtId'), now())", new Object[0]);
        int nodeId = this.jdbcTemplate.queryForInt("SELECT nodeId FROM node LIMIT 1", new Object[0]);
        this.jdbcTemplate.update("INSERT into ipInterface (nodeId, ipAddr, ipHostname) VALUES (?, ?, ?)", new Object[]{nodeId, "192.168.1.1", "First Interface"});
        Connection connection = this.getDataSource().getConnection();
        try {
            JdbcEventWriterTest.assertEquals((String)"getHostName should return the hostname for the IP address that was passed", (String)"First Interface", (String)this.m_jdbcEventWriter.getHostName(1, "192.168.1.1", connection));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetHostNameWithOneMatchNullHostname() throws Exception {
        this.jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime) VALUES (nextVal('nodeNxtId'), now())", new Object[0]);
        int nodeId = this.jdbcTemplate.queryForInt("SELECT nodeId FROM node LIMIT 1", new Object[0]);
        this.jdbcTemplate.update("INSERT into ipInterface (nodeId, ipAddr) VALUES (?, ?)", new Object[]{nodeId, "192.168.1.1"});
        Connection connection = this.getDataSource().getConnection();
        try {
            JdbcEventWriterTest.assertEquals((String)"getHostName should return the IP address it was passed", (String)"192.168.1.1", (String)this.m_jdbcEventWriter.getHostName(1, "192.168.1.1", connection));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetHostNameWithTwoMatch() throws Exception {
        this.jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeLabel) VALUES (nextVal('nodeNxtId'), now(), ?)", new Object[]{"First Node"});
        int nodeId1 = this.jdbcTemplate.queryForInt("SELECT nodeId FROM node WHERE nodeLabel = ?", new Object[]{"First Node"});
        this.jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeLabel) VALUES (nextVal('nodeNxtId'), now(), ?)", new Object[]{"Second Node"});
        int nodeId2 = this.jdbcTemplate.queryForInt("SELECT nodeId FROM node WHERE nodeLabel = ?", new Object[]{"Second Node"});
        this.jdbcTemplate.update("INSERT into ipInterface (nodeId, ipAddr, ipHostname) VALUES (?, ?, ?)", new Object[]{nodeId1, "192.168.1.1", "First Interface"});
        this.jdbcTemplate.update("INSERT into ipInterface (nodeId, ipAddr, ipHostname) VALUES (?, ?, ?)", new Object[]{nodeId2, "192.168.1.1", "Second Interface"});
        Connection connection = this.getDataSource().getConnection();
        try {
            JdbcEventWriterTest.assertEquals((String)"getHostName should return the IP address it was passed", (String)"First Interface", (String)this.m_jdbcEventWriter.getHostName(nodeId1, "192.168.1.1", connection));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetHostNameWithNoHostMatch() throws Exception {
        Connection connection = this.getDataSource().getConnection();
        try {
            JdbcEventWriterTest.assertEquals((String)"getHostName should return the IP address it was passed", (String)"192.168.1.1", (String)this.m_jdbcEventWriter.getHostName(1, "192.168.1.1", connection));
        }
        finally {
            connection.close();
        }
    }

    public void testSendEventWithService() throws Exception {
        int serviceId = 1;
        String serviceName = "some bogus service";
        this.jdbcTemplate.update("insert into service (serviceId, serviceName) values (?, ?)", new Object[]{serviceId, serviceName});
        EventBuilder builder = new EventBuilder("uei.opennms.org/foo", "someSource");
        builder.setLogMessage("logndisplay");
        builder.setService(serviceName);
        this.m_jdbcEventWriter.process(null, builder.getEvent());
        JdbcEventWriterTest.assertEquals((String)"event count", (int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from events", new Object[0]));
        JdbcEventWriterTest.assertEquals((String)"event service ID", (int)serviceId, (int)this.getJdbcTemplate().queryForInt("select serviceID from events", new Object[0]));
    }
}

