/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.List;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;

public class SyslogdConfigFactoryTest
extends TestCase {
    private SyslogdConfigFactory m_factory;

    protected void setUp() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.setRelativeHomeDirectory("src/test/resources");
        daoTestConfig.afterPropertiesSet();
        super.setUp();
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        this.m_factory = new SyslogdConfigFactory(ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/etc/syslogd-configuration.xml"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetUp() {
    }

    public void testMyHostNameGrouping() {
        SyslogdConfigFactoryTest.assertEquals((int)6, (int)this.m_factory.getMatchingGroupHost());
    }

    public void testMyMessageGroup() {
        SyslogdConfigFactoryTest.assertEquals((int)8, (int)this.m_factory.getMatchingGroupMessage());
    }

    public void testPattern() {
        SyslogdConfigFactoryTest.assertEquals((String)"^.*\\s(19|20)\\d\\d([-/.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])(\\s+)(\\S+)(\\s)(\\S.+)", (String)this.m_factory.getForwardingRegexp());
    }

    public void testUEI() {
        List ueiList = this.m_factory.getUeiList().getUeiMatchCollection();
        UeiMatch uei = (UeiMatch)ueiList.get(0);
        SyslogdConfigFactoryTest.assertEquals((String)"substr", (String)uei.getMatch().getType());
        SyslogdConfigFactoryTest.assertEquals((String)"CRISCO", (String)uei.getMatch().getExpression());
        SyslogdConfigFactoryTest.assertEquals((String)"uei.opennms.org/tests/syslogd/substrUeiRewriteTest", (String)uei.getUei());
        uei = (UeiMatch)ueiList.get(1);
        SyslogdConfigFactoryTest.assertEquals((String)"regex", (String)uei.getMatch().getType());
        SyslogdConfigFactoryTest.assertEquals((String)"foo: (\\d+) out of (\\d+) tests failed for (\\S+)$", (String)uei.getMatch().getExpression());
        SyslogdConfigFactoryTest.assertEquals((String)"uei.opennms.org/tests/syslogd/regexUeiRewriteTest", (String)uei.getUei());
    }

    public void testHideTheseMessages() {
        for (HideMatch hide : this.m_factory.getHideMessages().getHideMatchCollection()) {
            boolean typeOk = hide.getMatch().getType().equals("substr") || hide.getMatch().getType().equals("regex");
            SyslogdConfigFactoryTest.assertTrue((boolean)typeOk);
            if (hide.getMatch().getType().equals("substr")) {
                SyslogdConfigFactoryTest.assertEquals((String)"TESTHIDING", (String)hide.getMatch().getExpression());
                continue;
            }
            if (!hide.getMatch().getType().equals("regex")) continue;
            SyslogdConfigFactoryTest.assertEquals((String)"[Dd]ouble[Ss]ecret", (String)hide.getMatch().getExpression());
        }
    }
}

