/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.dao.db.AbstractTransactionalTemporaryDatabaseSpringContextTests;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.notifd.mock.MockNotifdConfigManager;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;

public class NotificationManagerTest
extends AbstractTransactionalTemporaryDatabaseSpringContextTests {
    private NotificationManagerImpl m_notificationManager;
    private NotifdConfigManager m_configManager;

    protected void setUpConfiguration() {
        DaoTestConfigBean bean = new DaoTestConfigBean();
        bean.afterPropertiesSet();
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml"};
    }

    protected void onSetUpInTransactionIfEnabled() throws Exception {
        super.onSetUpInTransactionIfEnabled();
        FilterDaoFactory.setInstance(null);
        FilterDaoFactory.getInstance();
        this.m_configManager = new MockNotifdConfigManager(ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)((Object)this), (String)"notifd-configuration.xml", (String[][])new String[0][]));
        this.m_notificationManager = new NotificationManagerImpl(this.m_configManager, this.getDataSource());
        NotificationManagerTest.assertNotNull((String)"getJdbcTemplate() should not return null", (Object)this.getJdbcTemplate());
        NotificationManagerTest.assertNotNull((String)"getJdbcTemplate().getJdbcOperations() should not return null", (Object)this.getSimpleJdbcTemplate().getJdbcOperations());
        this.getJdbcTemplate().update("INSERT INTO service ( serviceId, serviceName ) VALUES ( 1, 'HTTP' )");
        this.getJdbcTemplate().update("INSERT INTO node ( nodeId, nodeCreateTime, nodeLabel ) VALUES ( 1, now(), 'node 1' )");
        this.getJdbcTemplate().update("INSERT INTO ipInterface ( nodeId, ipAddr ) VALUES ( 1, '192.168.1.1' )");
        this.getJdbcTemplate().update("INSERT INTO ifServices ( nodeId, ipAddr, serviceId ) VALUES ( 1, '192.168.1.1', 1 )");
        this.getJdbcTemplate().update("INSERT INTO node ( nodeId, nodeCreateTime, nodeLabel ) VALUES ( 2, now(), 'node 2' )");
        this.getJdbcTemplate().update("INSERT INTO ipInterface ( nodeId, ipAddr ) VALUES ( 2, '192.168.1.1' )");
        this.getJdbcTemplate().update("INSERT INTO ipInterface ( nodeId, ipAddr ) VALUES ( 2, '0.0.0.0' )");
        this.getJdbcTemplate().update("INSERT INTO ifServices ( nodeId, ipAddr, serviceId ) VALUES ( 2, '192.168.1.1', 1 )");
        this.getJdbcTemplate().update("INSERT INTO node ( nodeId, nodeCreateTime, nodeLabel ) VALUES ( 3, now(), 'node 3' )");
        this.getJdbcTemplate().update("INSERT INTO ipInterface ( nodeId, ipAddr ) VALUES ( 3, '192.168.1.2' )");
        this.getJdbcTemplate().update("INSERT INTO ifServices ( nodeId, ipAddr, serviceId ) VALUES ( 3, '192.168.1.2', 1 )");
        this.getJdbcTemplate().update("INSERT INTO node ( nodeId, nodeCreateTime, nodeLabel ) VALUES ( 4, now(), 'node 4' )");
        this.getJdbcTemplate().update("INSERT INTO ipInterface ( nodeId, ipAddr ) VALUES ( 4, '192.168.1.3' )");
        this.getJdbcTemplate().update("INSERT INTO node ( nodeId, nodeCreateTime, nodeLabel ) VALUES ( 5, now(), 'node 5' )");
        this.getJdbcTemplate().update("INSERT INTO categories ( categoryId, categoryName ) VALUES ( 1, 'CategoryOne' )");
        this.getJdbcTemplate().update("INSERT INTO categories ( categoryId, categoryName ) VALUES ( 2, 'CategoryTwo' )");
        this.getJdbcTemplate().update("INSERT INTO categories ( categoryId, categoryName ) VALUES ( 3, 'CategoryThree' )");
        this.getJdbcTemplate().update("INSERT INTO categories ( categoryId, categoryName ) VALUES ( 4, 'CategoryFour' )");
        this.getJdbcTemplate().update("INSERT INTO category_node ( categoryId, nodeId ) VALUES ( 1, 1 )");
        this.getJdbcTemplate().update("INSERT INTO category_node ( categoryId, nodeId ) VALUES ( 2, 1 )");
        this.getJdbcTemplate().update("INSERT INTO category_node ( categoryId, nodeId ) VALUES ( 3, 1 )");
        this.getJdbcTemplate().update("INSERT INTO category_node ( categoryId, nodeId ) VALUES ( 1, 2 )");
        this.getJdbcTemplate().update("INSERT INTO category_node ( categoryId, nodeId ) VALUES ( 2, 2 )");
        this.getJdbcTemplate().update("INSERT INTO category_node ( categoryId, nodeId ) VALUES ( 4, 2 )");
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
    }

    public void testSetUp() {
    }

    public void testNoElement() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, null, null, "(ipaddr IPLIKE *.*.*.*)", true);
    }

    public void testNoNodeIdWithIpAddr() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, "192.168.1.1", null, "(ipaddr == '192.168.1.1')", true);
    }

    public void testNoNodeIdWithIpAddrNotInDb() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, "192.168.1.2", null, "(ipaddr == '192.168.1.1')", false);
    }

    public void testNoNodeIdWithService() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, null, "HTTP", "(ipaddr == '192.168.1.1')", true);
    }

    public void testRuleBogus() {
        try {
            this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(aklsdfjweklj89jaikj)", false);
            NotificationManagerTest.fail((String)"Expected exception to be thrown!");
        }
        catch (FilterParseException filterParseException) {
            // empty catch block
        }
    }

    public void testIplikeAllStars() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(ipaddr IPLIKE *.*.*.*)", true);
    }

    public void testNodeOnlyMatch() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, null, null, "(ipaddr == '192.168.1.1')", true);
    }

    public void testNodeOnlyMatchZeroesIpAddr() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "0.0.0.0", null, "(ipaddr == '192.168.1.1')", true);
    }

    public void testNodeOnlyNoMatch() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 3, null, null, "(ipaddr == '192.168.1.1')", false);
    }

    public void testWrongNodeId() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 2, "192.168.1.1", "HTTP", "(nodeid == 1)", false);
    }

    public void testIpAddrSpecificPass() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", null, "(ipaddr == '192.168.1.1')", true);
    }

    public void testIpAddrSpecificFail() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", null, "(ipaddr == '192.168.1.2')", false);
    }

    public void testIpAddrServiceSpecificPass() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(ipaddr == '192.168.1.1')", true);
    }

    public void testIpAddrServiceSpecificFail() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(ipaddr == '192.168.1.2')", false);
    }

    public void testIpAddrServiceSpecificWrongService() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "ICMP", "(ipaddr == '192.168.1.1')", false);
    }

    public void testIpAddrServiceSpecificWrongIP() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.2", "HTTP", "(ipaddr == '192.168.1.1')", false);
    }

    public void testMultipleCategories() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(catincCategoryOne) & (catincCategoryTwo) & (catincCategoryThree)", true);
    }

    public void testMultipleCategoriesNotMember() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 2, "192.168.1.1", "HTTP", "(catincCategoryOne) & (catincCategoryTwo) & (catincCategoryThree)", false);
    }

    public void testIpAddrMatchWithNoServiceOnInterface() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 4, null, null, "(ipaddr == '192.168.1.3')", true);
    }

    public void testNodeMatchWithNoInterfacesOnNode() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 5, null, null, "(nodeId == 5)", false);
    }

    public void testRuleWithOrNoMatch() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 3, "192.168.1.2", "HTTP", "(nodelabel=='node 1') | (nodelabel=='node 2')", false);
    }

    private void doTestNodeInterfaceServiceWithRule(String description, int nodeId, String intf, String svc, String rule, boolean matches) {
        Notification notif = new Notification();
        notif.setName("a notification");
        notif.setRule(rule);
        EventBuilder builder = new EventBuilder("uei.opennms.org/doNotCareAboutTheUei", "Test.Event");
        builder.setNodeid(nodeId);
        builder.setInterface(intf);
        builder.setService(svc);
        NotificationManagerTest.assertEquals((String)description, (boolean)matches, (boolean)this.m_notificationManager.nodeInterfaceServiceValid(notif, builder.getEvent()));
    }

    public class NotificationManagerImpl
    extends NotificationManager {
        protected NotificationManagerImpl(NotifdConfigManager configManager, DataSource dcf) {
            super(configManager, dcf);
        }

        protected void saveXML(String xmlString) throws IOException {
        }

        public void update() throws IOException, MarshalException, ValidationException {
        }
    }
}

