/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.MonitoringLocationsFactory;
import org.opennms.netmgt.config.PollerConfigManager;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class})
public class MonitoringLocationsFactoryTest {
    private MonitoringLocationsFactory m_locationFactory;
    private PollerConfigManager m_pollerConfigManager;

    @Before
    public void setUp() throws Exception {
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        InputStream stream = this.getClass().getResourceAsStream("/org/opennms/netmgt/config/monitoring-locations.testdata.xml");
        this.m_locationFactory = new MonitoringLocationsFactory(stream);
        stream.close();
        SnmpPeerFactory.init();
        stream = this.getClass().getResourceAsStream("/org/opennms/netmgt/config/poller-configuration.testdata.xml");
        this.m_pollerConfigManager = new TestPollerConfigManager(stream, "localhost", false);
        stream.close();
    }

    @Test
    public void testGetName() throws MarshalException, ValidationException, IOException {
        String locationName = "RDU";
        LocationDef def = this.m_locationFactory.getDef("RDU");
        Assert.assertNotNull((Object)def);
        Assert.assertEquals((Object)"RDU", (Object)def.getLocationName());
        Assert.assertEquals((Object)"raleigh", (Object)def.getMonitoringArea());
        Assert.assertNotNull((Object)this.m_pollerConfigManager.getPackage(def.getPollingPackageName()));
    }

    static class TestPollerConfigManager
    extends PollerConfigManager {
        String m_xml;

        @Deprecated
        public TestPollerConfigManager(Reader rdr, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
            super(rdr, localServer, verifyServer);
            this.save();
        }

        public TestPollerConfigManager(InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
            super(stream, localServer, verifyServer);
        }

        public void update() throws IOException, MarshalException, ValidationException {
            this.m_config = (PollerConfiguration)CastorUtils.unmarshal(PollerConfiguration.class, (Reader)new StringReader(this.m_xml));
            this.setUpInternalData();
        }

        protected void saveXml(String xml) throws IOException {
            this.m_xml = xml;
        }

        public String getXml() {
            return this.m_xml;
        }
    }
}

