/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.ConfigurationTestUtils;

public class ConfigureSnmpTest
extends TestCase {
    private final int m_startingDefCount = 5;

    protected void setUp() throws Exception {
        super.setUp();
        Reader rdr = ConfigurationTestUtils.getReaderForResource((Object)((Object)this), (String)"snmp-config-configureSnmpTest.xml");
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(rdr));
    }

    public void testToLongToAddr() throws UnknownHostException {
        String addr = "192.168.1.1";
        ConfigureSnmpTest.assertEquals((String)addr, (String)InetAddressUtils.toIpAddrString((long)InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName(addr))));
    }

    public void testCreateSnmpEventInfo() throws UnknownHostException {
        Event event = this.createConfigureSnmpEvent("192.168.1.1", null);
        this.addCommunityStringToEvent(event, "seemore");
        SnmpEventInfo info = new SnmpEventInfo(event);
        ConfigureSnmpTest.assertNotNull((Object)info);
        ConfigureSnmpTest.assertEquals((String)"192.168.1.1", (String)info.getFirstIPAddress());
        ConfigureSnmpTest.assertEquals((long)InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName("192.168.1.1")), (long)info.getFirst());
        ConfigureSnmpTest.assertNull((Object)info.getLastIPAddress());
        ConfigureSnmpTest.assertTrue((boolean)info.isSpecific());
    }

    public void testSnmpEventInfoClassWithSpecific() throws UnknownHostException {
        String addr = "192.168.0.5";
        Event event = this.createConfigureSnmpEvent("192.168.0.5", null);
        this.addCommunityStringToEvent(event, "abc");
        SnmpEventInfo info = new SnmpEventInfo(event);
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        mgr.mergeIntoConfig(info.createDef());
        SnmpAgentConfig agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.0.5"));
        ConfigureSnmpTest.assertEquals((String)agent.getAddress().getHostAddress(), (String)"192.168.0.5");
        ConfigureSnmpTest.assertEquals((String)"abc", (String)agent.getReadCommunity());
    }

    public void testSnmpEventInfoClassWithRangeReplacingSpecific() throws UnknownHostException {
        String addr1 = "192.168.0.5";
        String addr2 = "192.168.0.7";
        SnmpAgentConfig agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.0.5"));
        ConfigureSnmpTest.assertEquals((int)2, (int)agent.getVersion());
        Event event = this.createConfigureSnmpEvent("192.168.0.5", "192.168.0.7");
        SnmpEventInfo info = new SnmpEventInfo(event);
        info.setVersion("v2c");
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        mgr.mergeIntoConfig(info.createDef());
        agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.0.5"));
        ConfigureSnmpTest.assertEquals((String)agent.getAddress().getHostAddress(), (String)"192.168.0.5");
        ConfigureSnmpTest.assertEquals((int)2, (int)agent.getVersion());
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public void testSnmpEventInfoClassWithRangeSuperSettingDefRanges() throws UnknownHostException {
        String addr1 = "192.168.99.1";
        String addr2 = "192.168.108.254";
        SnmpAgentConfig agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.99.1"));
        ConfigureSnmpTest.assertEquals((int)1, (int)agent.getVersion());
        Event event = this.createConfigureSnmpEvent("192.168.99.1", "192.168.108.254");
        SnmpEventInfo info = new SnmpEventInfo(event);
        info.setCommunityString("opennmsrules");
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        mgr.mergeIntoConfig(info.createDef());
        agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.99.1"));
        ConfigureSnmpTest.assertEquals((String)agent.getAddress().getHostAddress(), (String)"192.168.99.1");
        ConfigureSnmpTest.assertEquals((int)1, (int)agent.getVersion());
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public void testSplicingSpecificsIntoRanges() throws UnknownHostException {
        ConfigureSnmpTest.assertEquals((int)3, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getRangeCount());
        ConfigureSnmpTest.assertEquals((int)6, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getSpecificCount());
        String specificAddr = "10.1.1.7";
        Event event = this.createConfigureSnmpEvent("10.1.1.7", null);
        SnmpEventInfo info = new SnmpEventInfo(event);
        info.setCommunityString("splice-test");
        info.setVersion("v2c");
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        mgr.mergeIntoConfig(info.createDef());
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getRangeCount());
        ConfigureSnmpTest.assertEquals((String)"10.1.1.10", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getSpecific(0));
        ConfigureSnmpTest.assertEquals((int)1, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getSpecificCount());
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public void testSplice2() throws UnknownHostException {
        ConfigureSnmpTest.assertEquals((int)3, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRangeCount());
        ConfigureSnmpTest.assertEquals((int)1, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecificCount());
        ConfigureSnmpTest.assertEquals((String)"10.1.1.10", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecific(0));
        ConfigureSnmpTest.assertEquals((String)"10.1.1.11", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRange(0).getBegin());
        String specificAddr = "10.1.1.7";
        Event event = this.createConfigureSnmpEvent("10.1.1.7", null);
        SnmpEventInfo info = new SnmpEventInfo(event);
        info.setCommunityString("splice2-test");
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        mgr.mergeIntoConfig(info.createDef());
        ConfigureSnmpTest.assertEquals((int)3, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRangeCount());
        ConfigureSnmpTest.assertEquals((int)1, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecificCount());
        ConfigureSnmpTest.assertEquals((String)"10.1.1.7", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecific(0));
        ConfigureSnmpTest.assertEquals((String)"10.1.1.10", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRange(0).getBegin());
        String marshalledConfig = SnmpPeerFactory.marshallConfig();
        ConfigureSnmpTest.assertNotNull((Object)marshalledConfig);
    }

    private Event createConfigureSnmpEvent(String firstIp, String lastIp) {
        Event event = new Event();
        event.setUei("uei.opennms.org/internal/configureSNMP");
        Parm vParm = new Parm();
        vParm.setParmName("firstIPAddress");
        Value value = new Value();
        value.setContent(firstIp);
        value.setType("String");
        vParm.setValue(value);
        Parms parms = new Parms();
        parms.addParm(vParm);
        vParm = new Parm();
        vParm.setParmName("lastIPAddress");
        value = new Value();
        value.setContent(lastIp);
        value.setType("String");
        vParm.setValue(value);
        parms.addParm(vParm);
        event.setParms(parms);
        return event;
    }

    private void addCommunityStringToEvent(Event event, String commStr) {
        Parms parms = event.getParms();
        Parm vParm = new Parm();
        vParm.setParmName("communityString");
        Value value = new Value();
        value.setContent(commStr);
        value.setType("String");
        vParm.setValue(value);
        parms.addParm(vParm);
    }
}

