/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.Reader;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class})
public class CollectdConfigFactoryTest {
    private CollectdConfigFactory m_factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        FilterDaoFactory.getInstance();
        Reader rdr = ConfigurationTestUtils.getReaderForResource((Object)this, (String)"collectd-testdata.xml");
        try {
            this.m_factory = new CollectdConfigFactory(rdr, "localhost", false);
        }
        finally {
            rdr.close();
        }
    }

    @Test
    public void testGetName() {
        String pkgName = "example1";
        CollectdPackage wpkg = this.m_factory.getPackage(pkgName);
        Assert.assertNotNull((Object)wpkg);
        Assert.assertEquals((Object)pkgName, (Object)wpkg.getName());
    }
}

