/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.IntervalTestCase;
import org.opennms.netmgt.config.OwnedInterval;
import org.opennms.netmgt.config.OwnedIntervalSequence;
import org.opennms.netmgt.config.Owner;
import org.opennms.netmgt.config.TimeInterval;
import org.opennms.netmgt.config.TimeIntervalSequence;
import org.opennms.netmgt.config.common.BasicSchedule;
import org.opennms.netmgt.config.common.Time;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.test.mock.MockLogAppender;

public class BasicScheduleUtilsTest
extends IntervalTestCase {
    protected void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    protected void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testSimpleScheduleExcluded() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"specific\">               <time begins=\"20-Aug-2005 13:00:00\" ends=\"20-Aug-2005 14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0);
        OwnedIntervalSequence intervals = BasicScheduleUtils.getIntervalsCovering((TimeInterval)this.aug(18), (BasicSchedule)simpleSchedule, (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)intervals);
        this.assertTimeIntervalSequence((TimeInterval[])new OwnedInterval[0], (TimeIntervalSequence)intervals);
    }

    public void testSimpleScheduleIncluded() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"specific\">               <time begins=\"18-Aug-2005 13:00:00\" ends=\"18-Aug-2005 14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0);
        OwnedIntervalSequence intervals = BasicScheduleUtils.getIntervalsCovering((TimeInterval)this.aug(18), (BasicSchedule)simpleSchedule, (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)intervals);
        this.assertTimeIntervalSequence((TimeInterval[])new OwnedInterval[]{this.owned(owner, this.aug(18, 13, 14))}, (TimeIntervalSequence)intervals);
    }

    public void testDoubleScheduleIncluded() throws Exception {
        String schedSpec = "           <schedule name=\"double\" type=\"specific\">               <time begins=\"18-Aug-2005 13:00:00\" ends=\"18-Aug-2005 14:00:00\"/>\n               <time begins=\"18-Aug-2005 16:00:00\" ends=\"18-Aug-2005 17:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "double", 0);
        OwnedIntervalSequence intervals = BasicScheduleUtils.getIntervalsCovering((TimeInterval)this.aug(18), (BasicSchedule)simpleSchedule, (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)intervals);
        this.assertTimeIntervalSequence(new TimeInterval[]{this.owned(owner, this.aug(18, 13, 14)), this.owned(owner, this.aug(18, 16, 17))}, (TimeIntervalSequence)intervals);
    }

    public void testComplexScheduleIncluded() throws Exception {
        String schedSpec = "           <schedule name=\"complex\" type=\"specific\">               <time day=\"thursday\" begins=\"13:00:00\" ends=\"14:00:00\"/>\n               <time day=\"friday\" begins=\"07:00:00\" ends=\"08:00:00\"/>\n               <time day=\"18\" begins=\"19:00:00\" ends=\"20:00:00\"/>\n               <time day=\"19\" begins=\"09:00:00\" ends=\"10:00:00\"/>\n               <time begins=\"18-Aug-2005 16:00:00\" ends=\"18-Aug-2005 17:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "complex", 0);
        OwnedIntervalSequence intervals = BasicScheduleUtils.getIntervalsCovering((TimeInterval)this.aug(18), (BasicSchedule)simpleSchedule, (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)intervals);
        TimeInterval[] expected = new TimeInterval[]{this.owned(owner, this.aug(18, 13, 14)), this.owned(owner, this.aug(18, 16, 17)), this.owned(owner, this.aug(18, 19, 20))};
        this.assertTimeIntervalSequence(expected, (TimeIntervalSequence)intervals);
    }

    public void testSpecificInterval() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"specific\">               <time begins=\"18-Aug-2005 13:00:00\" ends=\"18-Aug-2005 14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0, 0);
        OwnedInterval interval = BasicScheduleUtils.getInterval((Date)new Date(), (Time)simpleSchedule.getTime(0), (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)interval);
        this.assertInterval((TimeInterval)this.owned(owner, this.aug(18, 13, 14)), (TimeInterval)interval);
    }

    public void testMonthlyInterval() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"specific\">               <time day=\"18\" begins=\"13:00:00\" ends=\"14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0, 0);
        OwnedInterval interval = BasicScheduleUtils.getInterval((Date)this.aug(18).getStart(), (Time)simpleSchedule.getTime(0), (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)interval);
        this.assertInterval((TimeInterval)this.owned(owner, this.aug(18, 13, 14)), (TimeInterval)interval);
    }

    public void testWeeklyInterval() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"specific\">               <time day=\"thursday\" begins=\"13:00:00\" ends=\"14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0, 0);
        OwnedInterval interval = BasicScheduleUtils.getInterval((Date)this.aug(18).getStart(), (Time)simpleSchedule.getTime(0), (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)interval);
        this.assertInterval((TimeInterval)this.owned(owner, this.aug(18, 13, 14)), (TimeInterval)interval);
    }

    public void testGetIntervalsWeekly() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"weekly\">               <time day=\"thursday\" begins=\"11:00:00\" ends=\"14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0, 0);
        OwnedIntervalSequence intervals = BasicScheduleUtils.getIntervals((TimeInterval)this.aug(4, 13, 25, 12), (Time)simpleSchedule.getTime(0), (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)intervals);
        TimeInterval[] expected = new TimeInterval[]{this.owned(owner, this.aug(4, 13, 14)), this.owned(owner, this.aug(11, 11, 14)), this.owned(owner, this.aug(18, 11, 14)), this.owned(owner, this.aug(25, 11, 12))};
        this.assertTimeIntervalSequence(expected, (TimeIntervalSequence)intervals);
    }

    public void testGetIntervalsMonthly() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"monthly\">               <time day=\"7\" begins=\"11:00:00\" ends=\"14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0, 0);
        OwnedIntervalSequence intervals = BasicScheduleUtils.getIntervals((TimeInterval)this.interval(6, 7, 13, 11, 7, 12), (Time)simpleSchedule.getTime(0), (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)intervals);
        TimeInterval[] expected = new TimeInterval[]{this.owned(owner, this.jun(7, 13, 14)), this.owned(owner, this.jul(7, 11, 14)), this.owned(owner, this.aug(7, 11, 14)), this.owned(owner, this.sep(7, 11, 14)), this.owned(owner, this.oct(7, 11, 14)), this.owned(owner, this.nov(7, 11, 12))};
        this.assertTimeIntervalSequence(expected, (TimeIntervalSequence)intervals);
    }

    public void testGetIntervalsDaily() throws Exception {
        String schedSpec = "           <schedule name=\"simple\" type=\"daily\">               <time begins=\"11:00:00\" ends=\"14:00:00\"/>\n           </schedule>";
        Schedule simpleSchedule = (Schedule)CastorUtils.unmarshal(Schedule.class, (InputStream)new ByteArrayInputStream(schedSpec.getBytes()), (boolean)false);
        Owner owner = new Owner("unnamed", "simple", 0, 0);
        OwnedIntervalSequence intervals = BasicScheduleUtils.getIntervals((TimeInterval)this.interval(6, 1, 0, 7, 1, 0), (Time)simpleSchedule.getTime(0), (Owner)owner);
        BasicScheduleUtilsTest.assertNotNull((Object)intervals);
        ArrayList<OwnedInterval> expected = new ArrayList<OwnedInterval>();
        for (int i = 1; i < 31; ++i) {
            expected.add(this.owned(owner, this.jun(i, 11, i, 14)));
        }
        System.err.println(expected);
        this.assertTimeIntervalSequence(expected.toArray(new TimeInterval[0]), (TimeIntervalSequence)intervals);
    }
}

