/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.mock.snmp.JUnitSnmpAgent;
import org.opennms.mock.snmp.JUnitSnmpAgentExecutionListener;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.mock.snmp.MockSnmpAgentAware;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectorTestUtils;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.JUnitCollector;
import org.opennms.netmgt.collectd.JUnitCollectorExecutionListener;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, TemporaryDatabaseExecutionListener.class, JUnitCollectorExecutionListener.class, JUnitSnmpAgentExecutionListener.class, DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml"})
@Transactional
public class SnmpCollectorMinMaxValTest
implements MockSnmpAgentAware {
    @Autowired
    private MockEventIpcManager m_mockEventIpcManager;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    private TestContext m_context;
    private String m_testHostName;
    private static final String TEST_NODE_LABEL = "TestNode";
    private CollectionSpecification m_collectionSpecification;
    private CollectionAgent m_collectionAgent;
    private MockSnmpAgent m_agent;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        Assert.assertNotNull((Object)this.m_mockEventIpcManager);
        Assert.assertNotNull((Object)this.m_transactionManager);
        Assert.assertNotNull((Object)this.m_nodeDao);
        Assert.assertNotNull((Object)this.m_ipInterfaceDao);
        Assert.assertNotNull((Object)this.m_serviceTypeDao);
        RrdUtils.setStrategy((RrdStrategy)RrdUtils.getSpecificStrategy((RrdUtils.StrategyName)RrdUtils.StrategyName.basicRrdStrategy));
        this.m_testHostName = InetAddress.getLocalHost().getHostAddress();
        OnmsIpInterface iface = null;
        OnmsNode testNode = null;
        Collection testNodes = this.m_nodeDao.findByLabel(TEST_NODE_LABEL);
        if (testNodes == null || testNodes.size() < 1) {
            NetworkBuilder builder = new NetworkBuilder();
            builder.addNode(TEST_NODE_LABEL).setId(Integer.valueOf(1)).setSysObjectId(".1.3.6.1.4.1.1588.2.1.1.1");
            builder.addSnmpInterface(this.m_testHostName, 1).setIfName("lo0").setPhysAddr("00:11:22:33:44");
            builder.addSnmpInterface(this.m_testHostName, 2).setIfName("gif0").setPhysAddr("00:11:22:33:45").setIfType(Integer.valueOf(55));
            builder.addSnmpInterface(this.m_testHostName, 3).setIfName("stf0").setPhysAddr("00:11:22:33:46").setIfType(Integer.valueOf(57));
            NetworkBuilder.InterfaceBuilder ifBldr = builder.addInterface(this.m_testHostName).setIsSnmpPrimary("P");
            ifBldr.addSnmpInterface(this.m_testHostName, 6).setIfName("fw0").setPhysAddr("44:33:22:11:00").setIfType(Integer.valueOf(144)).setCollectionEnabled(true);
            testNode = builder.getCurrentNode();
            Assert.assertNotNull((Object)testNode);
            this.m_nodeDao.save((Object)testNode);
            this.m_nodeDao.flush();
        } else {
            testNode = (OnmsNode)testNodes.iterator().next();
        }
        Set ifaces = testNode.getIpInterfaces();
        Assert.assertEquals((long)1L, (long)ifaces.size());
        iface = (OnmsIpInterface)ifaces.iterator().next();
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<snmp-config port=\"9161\" retry=\"1\" timeout=\"1000\" read-community=\"public\" version=\"v2c\">\n</snmp-config>".getBytes("UTF-8"))));
        SnmpCollector collector = new SnmpCollector();
        collector.initialize(null);
        this.m_collectionSpecification = CollectorTestUtils.createCollectionSpec("SNMP", (ServiceCollector)collector, "default");
        this.m_collectionAgent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)this.m_transactionManager);
    }

    @After
    public void tearDown() throws Exception {
        MockUtil.println((String)"------------ End Test --------------------------");
    }

    @Test
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-minmax-persistTest-config.xml", datacollectionType="snmp", anticipateFiles={"1", "1/fw0"}, anticipateRrds={"1/tcpCurrEstab", "1/fw0/ifInOctets"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/snmpTestData1.properties")
    public void testPersist() throws Exception {
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        File nodeDir = new File(snmpRrdDirectory, "1");
        File rrdFile = new File(nodeDir, SnmpCollectorMinMaxValTest.rrd("tcpCurrEstab"));
        File ifDir = new File(nodeDir, "fw0");
        File ifRrdFile = new File(ifDir, SnmpCollectorMinMaxValTest.rrd("ifInOctets"));
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, numUpdates);
        Assert.assertEquals((Object)new Double(123.0), (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)stepSizeInMillis, (int)stepSizeInMillis));
        Assert.assertEquals((Object)new Double(1234567.0), (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)stepSizeInMillis, (int)stepSizeInMillis));
        this.m_agent.updateIntValue(".1.3.6.1.2.1.6.9.0", 456);
        this.m_agent.updateCounter32Value(".1.3.6.1.2.1.2.2.1.10.6", 7654321);
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, numUpdates);
        Assert.assertEquals((Object)new Double(456.0), (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)stepSizeInMillis, (int)stepSizeInMillis));
        Assert.assertEquals((Object)new Double(1234567.0), (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)stepSizeInMillis, (int)(stepSizeInMillis + 20000)));
        this.m_agent.updateIntValue(".1.3.6.1.2.1.6.9.0", 456);
        this.m_agent.updateCounter32Value(".1.3.6.1.2.1.2.2.1.10.6", 1234567);
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, numUpdates);
        Assert.assertEquals((Object)new Double(456.0), (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)stepSizeInMillis, (int)stepSizeInMillis));
        Assert.assertEquals((Object)new Double(1234567.0), (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)stepSizeInMillis, (int)(stepSizeInMillis + 20000)));
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }

    private static String rrd(String file) {
        return file + RrdUtils.getExtension();
    }

    public void setMockSnmpAgent(MockSnmpAgent agent) {
        this.m_agent = agent;
    }

    public void setTestContext(TestContext context) {
        this.m_context = context;
    }
}

