/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.BasePersister;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.mock.MockPlatformTransactionManager;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValueFactory;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.transaction.PlatformTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpAttributeTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private IpInterfaceDao m_ipInterfaceDao = (IpInterfaceDao)this.m_mocks.createMock(IpInterfaceDao.class);
    private RrdStrategy m_rrdStrategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);

    protected void setUp() throws Exception {
        super.setUp();
        RrdTestUtils.initializeNullStrategy();
        RrdUtils.setStrategy((RrdStrategy)this.m_rrdStrategy);
    }

    protected void runTest() throws Throwable {
        super.runTest();
        this.m_mocks.verifyAll();
    }

    public void testNumericAttributeFloatValueInString() throws Exception {
        String stringValue = "7.69";
        this.testPersisting(stringValue, new Snmp4JValueFactory().getOctetString(stringValue.getBytes()));
    }

    public void testNumericAttributeCounterValue() throws Exception {
        int intValue = 769;
        this.testPersisting(Integer.toString(intValue), new Snmp4JValueFactory().getCounter32((long)intValue));
    }

    private void testPersisting(String matchValue, SnmpValue snmpValue) throws Exception {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(3));
        OnmsIpInterface ipInterface = new OnmsIpInterface();
        ipInterface.setId(Integer.valueOf(1));
        ipInterface.setNode(node);
        ipInterface.setIpAddress("192.168.1.1");
        EasyMock.expect((Object)this.m_ipInterfaceDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)ipInterface).times(3);
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".myLittleEasyMockedStrategyAndMe").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), this.isAList(RrdDataSource.class), this.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.matches((String)(".*:" + matchValue)));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        this.m_mocks.replayAll();
        CollectionAgent agent = DefaultCollectionAgent.create((Integer)ipInterface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)new MockPlatformTransactionManager());
        OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)new MockDataCollectionConfig());
        NodeResourceType resourceType = new NodeResourceType(agent, snmpCollection);
        NodeInfo nodeInfo = new NodeInfo(resourceType, agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.3.6.1.4.1.12238.55.9997.4.1.2.9.116.101.109.112.95.117.108.107.111");
        mibObject.setInstance("1");
        mibObject.setAlias("temp_ulko");
        mibObject.setType("gauge");
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, snmpCollection.getName(), mibObject, new AttributeGroupType("foo", "ignore"));
        SnmpAttribute attr = new SnmpAttribute((CollectionResource)nodeInfo, (SnmpAttributeType)attributeType, snmpValue);
        RrdRepository repository = new RrdRepository();
        repository.setRraList(new ArrayList<String>(Collections.singleton("RRA:AVERAGE:0.5:1:2016")));
        BasePersister persister = new BasePersister(new ServiceParameters(new HashMap()), repository);
        persister.createBuilder((CollectionResource)nodeInfo, "baz", (AttributeDefinition)attributeType);
        attr.storeAttribute((Persister)persister);
        persister.commitBuilder();
    }

    private <T> List<T> isAList(Class<T> clazz) {
        return (List)EasyMock.isA(List.class);
    }
}

