/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.PersistOperationBuilder;
import org.opennms.netmgt.collectd.ResourceIdentifier;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.mock.MockPlatformTransactionManager;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.transaction.PlatformTransactionManager;

public class PersistOperationBuilderTest
extends TestCase {
    private FileAnticipator m_fileAnticipator;
    private File m_snmpDirectory;
    private OnmsIpInterface m_intf;
    private OnmsNode m_node;
    private PlatformTransactionManager m_transMgr = new MockPlatformTransactionManager();
    private IpInterfaceDao m_ifDao;

    protected void setUp() throws Exception {
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_intf = new OnmsIpInterface();
        this.m_node = new OnmsNode();
        this.m_node.setId(Integer.valueOf(1));
        this.m_intf.setNode(this.m_node);
        this.m_intf.setIpAddress("1.1.1.1");
        this.m_intf.setId(Integer.valueOf(27));
        this.m_ifDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
        EasyMock.expect((Object)this.m_ifDao.load((Serializable)this.m_intf.getId())).andReturn((Object)this.m_intf).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.m_ifDao});
    }

    protected void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
        this.m_fileAnticipator.deleteExpected();
    }

    protected void tearDown() throws Exception {
        this.m_fileAnticipator.deleteExpected(true);
        this.m_fileAnticipator.tearDown();
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
        super.tearDown();
    }

    private CollectionAgent getCollectionAgent() {
        return DefaultCollectionAgent.create((Integer)this.m_intf.getId(), (IpInterfaceDao)this.m_ifDao, (PlatformTransactionManager)this.m_transMgr);
    }

    public void testCommitWithNoDeclaredAttributes() throws Exception {
        RrdRepository repository = this.createRrdRepository();
        CollectionAgent agent = this.getCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        PersistOperationBuilder builder = new PersistOperationBuilder(repository, (ResourceIdentifier)resource, "rrdName");
        builder.commit();
    }

    public void testCommitWithDeclaredAttribute() throws Exception {
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "rrdName" + RrdUtils.getExtension());
        RrdRepository repository = this.createRrdRepository();
        CollectionAgent agent = this.getCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias("mibObjectAlias");
        mibObject.setType("string");
        mibObject.setInstance("0");
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        StringAttributeType attributeType = new StringAttributeType((ResourceType)resourceType, "some-collection", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        PersistOperationBuilder builder = new PersistOperationBuilder(repository, (ResourceIdentifier)resource, "rrdName");
        builder.declareAttribute((AttributeDefinition)attributeType);
        builder.commit();
    }

    public void testCommitWithDeclaredAttributeAndValue() throws Exception {
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "rrdName" + RrdUtils.getExtension());
        RrdRepository repository = this.createRrdRepository();
        CollectionAgent agent = this.getCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias("mibObjectAlias");
        mibObject.setType("string");
        mibObject.setInstance("0");
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        StringAttributeType attributeType = new StringAttributeType((ResourceType)resourceType, "some-collection", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        PersistOperationBuilder builder = new PersistOperationBuilder(repository, (ResourceIdentifier)resource, "rrdName");
        builder.declareAttribute((AttributeDefinition)attributeType);
        builder.setAttributeValue((AttributeDefinition)attributeType, "6.022E23");
        builder.commit();
    }

    private RrdRepository createRrdRepository() throws IOException {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRrdDirectory());
        repository.setHeartBeat(600);
        repository.setStep(300);
        repository.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        return repository;
    }

    private File getSnmpRrdDirectory() throws IOException {
        if (this.m_snmpDirectory == null) {
            this.m_snmpDirectory = this.m_fileAnticipator.tempDir("snmp");
        }
        return this.m_snmpDirectory;
    }
}

