/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.collectd.JUnitCollector;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.dao.castor.DefaultDataCollectionConfigDao;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.FileAnticipator;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class JUnitCollectorExecutionListener
extends AbstractTestExecutionListener {
    private File m_snmpRrdDirectory;
    private FileAnticipator m_fileAnticipator;

    public void beforeTestMethod(TestContext testContext) throws Exception {
        JUnitCollector config = JUnitCollectorExecutionListener.findCollectorAnnotation(testContext);
        if (config == null) {
            return;
        }
        Method m = ReflectionUtils.findMethod((Class)testContext.getTestClass(), (String)"setTestContext", (Class[])new Class[]{TestContext.class});
        if (m != null && testContext.getTestInstance() != null) {
            System.err.println("invoking setTestContext on " + testContext.getTestInstance());
            m.invoke(testContext.getTestInstance(), testContext);
        }
        RrdTestUtils.initialize();
        InputStream is = ConfigurationTestUtils.getInputStreamForResource((Object)testContext.getTestInstance(), (String)config.schemaConfig());
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(is));
        is.close();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_snmpRrdDirectory = this.m_fileAnticipator.tempDir("snmp");
        this.m_snmpRrdDirectory.mkdirs();
        testContext.setAttribute("fileAnticipator", (Object)this.m_fileAnticipator);
        testContext.setAttribute("rrdDirectory", (Object)this.m_snmpRrdDirectory);
        if (config.datacollectionType().equalsIgnoreCase("http")) {
            is = ConfigurationTestUtils.getInputStreamForResourceWithReplacements((Object)testContext.getTestInstance(), (String)config.datacollectionConfig(), (String[][])new String[][]{{"%rrdRepository%", this.m_snmpRrdDirectory.getAbsolutePath()}});
            HttpCollectionConfigFactory factory = new HttpCollectionConfigFactory(is);
            HttpCollectionConfigFactory.setInstance((HttpCollectionConfigFactory)factory);
            HttpCollectionConfigFactory.init();
        } else if (config.datacollectionType().equalsIgnoreCase("snmp")) {
            Resource r = ConfigurationTestUtils.getSpringResourceForResourceWithReplacements((Object)testContext.getTestInstance(), (String)config.datacollectionConfig(), (String[][])new String[][]{{"%rrdRepository%", this.m_snmpRrdDirectory.getAbsolutePath()}});
            DefaultDataCollectionConfigDao dataCollectionDao = new DefaultDataCollectionConfigDao();
            dataCollectionDao.setConfigResource(r);
            dataCollectionDao.afterPropertiesSet();
            DataCollectionConfigFactory.setInstance((DataCollectionConfig)dataCollectionDao);
        } else {
            throw new UnsupportedOperationException("data collection type '" + config.datacollectionType() + "' not supported");
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        JUnitCollector config = JUnitCollectorExecutionListener.findCollectorAnnotation(testContext);
        if (config == null) {
            return;
        }
        if (config.anticipateFiles().length > 0 || config.anticipateRrds().length > 0) {
            Thread.sleep(1000L);
        }
        if (config.anticipateRrds().length > 0) {
            for (String rrdFile : config.anticipateRrds()) {
                this.m_fileAnticipator.expecting(this.m_snmpRrdDirectory, rrdFile + RrdUtils.getExtension());
            }
        }
        if (config.anticipateFiles().length > 0) {
            for (String file : config.anticipateFiles()) {
                this.m_fileAnticipator.expecting(this.m_snmpRrdDirectory, file);
            }
        }
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
        JUnitCollectorExecutionListener.deleteChildDirectories(this.m_snmpRrdDirectory);
        this.m_fileAnticipator.tearDown();
    }

    private static void deleteChildDirectories(File directory) {
        for (File f : directory.listFiles()) {
            if (!f.isDirectory()) continue;
            JUnitCollectorExecutionListener.deleteChildDirectories(f);
            if (f.list().length != 0) continue;
            f.delete();
        }
    }

    private static JUnitCollector findCollectorAnnotation(TestContext testContext) {
        Method testMethod = testContext.getTestMethod();
        JUnitCollector config = testMethod.getAnnotation(JUnitCollector.class);
        if (config != null) {
            return config;
        }
        Class testClass = testContext.getTestClass();
        return testClass.getAnnotation(JUnitCollector.class);
    }
}

