/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.JUnitHttpServerExecutionListener;
import org.opennms.core.test.annotations.JUnitHttpServer;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectorTestUtils;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.HttpCollector;
import org.opennms.netmgt.collectd.JUnitCollector;
import org.opennms.netmgt.collectd.JUnitCollectorExecutionListener;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, TemporaryDatabaseExecutionListener.class, JUnitCollectorExecutionListener.class, JUnitHttpServerExecutionListener.class, DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml"})
@JUnitHttpServer(port=10342, vhosts={"127.0.0.1"})
public class HttpCollectorTest {
    @Autowired
    private MockEventIpcManager m_mockEventIpcManager;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    private TestContext m_context;
    private final OnmsDistPoller m_distPoller = new OnmsDistPoller("localhost", "127.0.0.1");
    private final String m_testHostName = "127.0.0.1";
    private CollectionSpecification m_collectionSpecification;
    private CollectionAgent m_collectionAgent;

    public void setTestContext(TestContext t) {
        this.m_context = t;
    }

    private OnmsServiceType getServiceType(String name) {
        OnmsServiceType serviceType = this.m_serviceTypeDao.findByName(name);
        if (serviceType == null) {
            serviceType = new OnmsServiceType(name);
            this.m_serviceTypeDao.save((Object)serviceType);
            this.m_serviceTypeDao.flush();
        }
        return serviceType;
    }

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        Assert.assertNotNull((Object)this.m_mockEventIpcManager);
        Assert.assertNotNull((Object)this.m_ipInterfaceDao);
        Assert.assertNotNull((Object)this.m_nodeDao);
        if (this.m_nodeDao.findByLabel("testnode").size() == 0) {
            NetworkBuilder builder = new NetworkBuilder(this.m_distPoller);
            builder.addNode("testnode");
            builder.addInterface(InetAddress.getByName("127.0.0.1").getHostAddress()).setIsManaged("M").setIsSnmpPrimary("P");
            builder.addService(this.getServiceType("ICMP"));
            builder.addService(this.getServiceType("HTTP"));
            if (this.m_nodeDao == null) {
                throw new Exception("node DAO does not exist!");
            }
            OnmsNode n = builder.getCurrentNode();
            Assert.assertNotNull((Object)n);
            this.m_nodeDao.save((Object)n);
            this.m_nodeDao.flush();
        }
        HttpCollector collector = new HttpCollector();
        Collection ifaces = this.m_ipInterfaceDao.findByIpAddress("127.0.0.1");
        Assert.assertEquals((long)1L, (long)ifaces.size());
        OnmsIpInterface iface = (OnmsIpInterface)ifaces.iterator().next();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("collection", "default");
        collector.initialize(parameters);
        this.m_collectionSpecification = CollectorTestUtils.createCollectionSpec("HTTP", (ServiceCollector)collector, "default");
        this.m_collectionAgent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)this.m_transactionManager);
    }

    @Test
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-config.xml", datacollectionType="http", anticipateRrds={"1/documentCount", "1/greatAnswer", "1/someNumber"}, anticipateFiles={"1/strings.properties"})
    public final void testCollect() throws Exception {
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectionSet collectionSet = this.m_collectionSpecification.collect(this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (long)1L, (long)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_collectionSpecification, collectionSet);
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }

    @Test
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-persist-test-config.xml", datacollectionType="http", anticipateRrds={"1/documentCount", "1/greatAnswer", "1/someNumber"}, anticipateFiles={"1/strings.properties"})
    public final void testPersist() throws Exception {
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        FileAnticipator anticipator = (FileAnticipator)this.m_context.getAttribute("fileAnticipator");
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, numUpdates);
        File nodeDir = CollectorTestUtils.anticipatePath(anticipator, snmpRrdDirectory, "1");
        File documentCountRrdFile = new File(nodeDir, CollectorTestUtils.rrd("documentCount"));
        File someNumberRrdFile = new File(nodeDir, CollectorTestUtils.rrd("someNumber"));
        File greatAnswerRrdFile = new File(nodeDir, CollectorTestUtils.rrd("greatAnswer"));
        Assert.assertEquals((String)"documentCount", (Object)5.0, (Object)RrdUtils.fetchLastValueInRange((String)documentCountRrdFile.getAbsolutePath(), (String)"documentCount", (int)stepSizeInMillis, (int)stepSizeInMillis));
        Assert.assertEquals((String)"documentType", (Object)17.0, (Object)RrdUtils.fetchLastValueInRange((String)someNumberRrdFile.getAbsolutePath(), (String)"someNumber", (int)stepSizeInMillis, (int)stepSizeInMillis));
        Assert.assertEquals((String)"greatAnswer", (Object)42.0, (Object)RrdUtils.fetchLastValueInRange((String)greatAnswerRrdFile.getAbsolutePath(), (String)"greatAnswer", (int)stepSizeInMillis, (int)stepSizeInMillis));
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }
}

