/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.CollectorConfigDao;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.poller.mock.MockScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.SimpleTransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectdTest
extends TestCase {
    EasyMockUtils m_easyMockUtils = new EasyMockUtils();
    private Collectd m_collectd;
    private FilterDao m_filterDao;
    private EventIpcManager m_eventIpcManager;
    private CollectorConfigDao m_collectorConfigDao;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipIfDao;
    private ServiceCollector m_collector;
    private MockScheduler m_scheduler;
    private PlatformTransactionManager m_transactionManager;
    private CollectdPackage m_collectdPackage;

    protected void setUp() throws Exception {
        MockLogAppender.setupLogging();
        ClassPathResource threshdResource = new ClassPathResource("/etc/thresholds.xml");
        File homeDir = threshdResource.getFile().getParentFile().getParentFile();
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
        this.m_eventIpcManager = (EventIpcManager)this.m_easyMockUtils.createMock(EventIpcManager.class);
        this.m_collectorConfigDao = (CollectorConfigDao)this.m_easyMockUtils.createMock(CollectorConfigDao.class);
        this.m_nodeDao = (NodeDao)this.m_easyMockUtils.createMock(NodeDao.class);
        this.m_ipIfDao = (IpInterfaceDao)this.m_easyMockUtils.createMock(IpInterfaceDao.class);
        this.m_collector = (ServiceCollector)this.m_easyMockUtils.createMock(ServiceCollector.class);
        this.m_scheduler = new MockScheduler();
        this.m_eventIpcManager.addEventListener((EventListener)EasyMock.isA(EventListener.class));
        EasyMock.expectLastCall().anyTimes();
        this.m_eventIpcManager.addEventListener((EventListener)EasyMock.isA(EventListener.class), this.isACollection(String.class));
        EasyMock.expectLastCall().anyTimes();
        this.m_eventIpcManager.addEventListener((EventListener)EasyMock.isA(EventListener.class), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().anyTimes();
        this.m_eventIpcManager.removeEventListener((EventListener)EasyMock.isA(EventListener.class));
        EasyMock.expectLastCall().anyTimes();
        this.m_filterDao = (FilterDao)EasyMock.createMock(FilterDao.class);
        ArrayList<String> allIps = new ArrayList<String>();
        allIps.add("192.168.1.1");
        allIps.add("192.168.1.2");
        allIps.add("192.168.1.3");
        allIps.add("192.168.1.4");
        allIps.add("192.168.1.5");
        EasyMock.expect((Object)this.m_filterDao.getIPList("IPADDR IPLIKE *.*.*.*")).andReturn(allIps).atLeastOnce();
        EasyMock.expect((Object)this.m_filterDao.getIPList("IPADDR IPLIKE 1.1.1.1")).andReturn(new ArrayList(0)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.m_filterDao});
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        ClassPathResource resource = new ClassPathResource("etc/poll-outages.xml");
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)new PollOutagesConfigFactory((Resource)resource));
        CollectdConfigFactory collectdConfig = new CollectdConfigFactory(ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/org/opennms/netmgt/config/collectd-testdata.xml"), "nms1", false);
        CollectdConfigFactory.setInstance((CollectdConfigFactory)collectdConfig);
        this.m_collectd = new Collectd();
        this.m_collectd.setEventIpcManager(this.getEventIpcManager());
        this.m_collectd.setCollectorConfigDao(this.getCollectorConfigDao());
        this.m_collectd.setNodeDao(this.getNodeDao());
        this.m_collectd.setIpInterfaceDao(this.getIpInterfaceDao());
        this.m_collectd.setScheduler((Scheduler)this.m_scheduler);
        Package pkg = new Package();
        pkg.setName("pkg");
        Filter filter = new Filter();
        filter.setContent("IPADDR IPLIKE *.*.*.*");
        pkg.setFilter(filter);
        Service svc = new Service();
        pkg.addService(svc);
        svc.setName("SNMP");
        svc.setStatus("on");
        Parameter parm = new Parameter();
        parm.setKey("collection");
        parm.setValue("default");
        svc.addParameter(parm);
        parm = new Parameter();
        parm.setKey("thresholding-enabled");
        parm.setValue("true");
        svc.addParameter(parm);
        svc.setStatus("on");
        this.m_collectdPackage = new CollectdPackage(pkg, "localhost", false);
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory(ConfigurationTestUtils.getInputStreamForConfigFile((String)"thresholds.xml")));
    }

    public void runTest() throws Throwable {
        super.runTest();
        EasyMock.verify((Object[])new Object[]{this.m_filterDao});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private ServiceCollector getCollector() {
        return this.m_collector;
    }

    private NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    private IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipIfDao;
    }

    private CollectorConfigDao getCollectorConfigDao() {
        return this.m_collectorConfigDao;
    }

    private EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    private OnmsIpInterface getInterface() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        OnmsIpInterface iface = new OnmsIpInterface("192.168.1.1", node);
        iface.setId(Integer.valueOf(1));
        return iface;
    }

    public void testCreate() {
        this.setupTransactionManager();
        String svcName = "SNMP";
        this.setupCollector(svcName);
        this.setupTransactionManager();
        Scheduler m_scheduler = (Scheduler)this.m_easyMockUtils.createMock(Scheduler.class);
        this.m_collectd.setScheduler(m_scheduler);
        m_scheduler.schedule(EasyMock.eq((long)0L), (ReadyRunnable)EasyMock.isA(ReadyRunnable.class));
        m_scheduler.start();
        m_scheduler.stop();
        this.m_easyMockUtils.replayAll();
        this.m_collectd.init();
        this.m_collectd.start();
        this.m_collectd.stop();
        this.m_easyMockUtils.verifyAll();
    }

    public void testOverrides() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("max-repetitions", "11");
        map.put("read-community", "notPublic");
        ServiceParameters params = new ServiceParameters(map);
        int reps = params.getSnmpMaxRepetitions(6);
        CollectdTest.assertEquals((String)"Overriding max repetitions failed.", (int)11, (int)reps);
        params = new ServiceParameters(map);
        map.remove("max-repetitions");
        map.put("maxRepetitions", "11");
        CollectdTest.assertEquals((String)"Overriding max repetitions failed.", (int)11, (int)reps);
        String s = params.getSnmpReadCommunity("public");
        CollectdTest.assertEquals((String)"Overriding read community failed.", (String)"notPublic", (String)s);
        map.remove("read-community");
        map.put("readCommunity", "notPublic");
        params = new ServiceParameters(map);
        s = params.getSnmpReadCommunity("public");
        CollectdTest.assertEquals((String)"Overriding read community failed.", (String)"notPublic", (String)s);
    }

    public void testNoMatchingSpecs() {
        String svcName = "SNMP";
        this.setupCollector(svcName);
        EasyMock.expect((Object)this.m_ipIfDao.findByServiceType(svcName)).andReturn(new ArrayList(0));
        this.setupTransactionManager();
        this.m_easyMockUtils.replayAll();
        this.m_collectd.init();
        this.m_collectd.start();
        this.m_scheduler.next();
        CollectdTest.assertEquals((int)0, (int)this.m_scheduler.getEntryCount());
        this.m_collectd.stop();
        this.m_easyMockUtils.verifyAll();
    }

    public void testOneMatchingSpec() throws CollectionException {
        String svcName = "SNMP";
        OnmsIpInterface iface = this.getInterface();
        this.setupCollector(svcName);
        this.m_collector.initialize((CollectionAgent)EasyMock.isA(CollectionAgent.class), (Map)EasyMock.isA(Map.class));
        CollectionSet collectionSetResult = new CollectionSet(){

            public int getStatus() {
                return 1;
            }

            public void visit(CollectionSetVisitor visitor) {
                visitor.visitCollectionSet((CollectionSet)this);
                visitor.completeCollectionSet((CollectionSet)this);
            }

            public boolean ignorePersist() {
                return false;
            }
        };
        EasyMock.expect((Object)this.m_collector.collect((CollectionAgent)EasyMock.isA(CollectionAgent.class), (EventProxy)EasyMock.isA(EventProxy.class), CollectdTest.isAMap(String.class, String.class))).andReturn((Object)collectionSetResult);
        this.setupInterface(iface);
        this.setupTransactionManager();
        EasyMock.expect((Object)this.m_collectorConfigDao.getPackages()).andReturn(Collections.singleton(this.m_collectdPackage));
        this.m_easyMockUtils.replayAll();
        this.m_collectd.init();
        this.m_collectd.start();
        this.m_scheduler.next();
        CollectdTest.assertEquals((String)"scheduler entry count", (int)1, (int)this.m_scheduler.getEntryCount());
        this.m_scheduler.next();
        this.m_collectd.stop();
        this.m_easyMockUtils.verifyAll();
    }

    private <K> Collection<K> isACollection(Class<K> innerClass) {
        return (Collection)EasyMock.isA(Collection.class);
    }

    private static <K, V> Map<K, V> isAMap(Class<K> keyClass, Class<V> valueClass) {
        return (Map)EasyMock.isA(Map.class);
    }

    private void setupTransactionManager() {
        this.m_transactionManager = (PlatformTransactionManager)this.m_easyMockUtils.createMock(PlatformTransactionManager.class);
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.m_transactionManager);
        this.m_collectd.setTransactionTemplate(transactionTemplate);
        EasyMock.expect((Object)this.m_transactionManager.getTransaction((TransactionDefinition)EasyMock.isA(TransactionDefinition.class))).andReturn((Object)new SimpleTransactionStatus()).anyTimes();
        this.m_transactionManager.rollback((TransactionStatus)EasyMock.isA(TransactionStatus.class));
        EasyMock.expectLastCall().anyTimes();
        this.m_transactionManager.commit((TransactionStatus)EasyMock.isA(TransactionStatus.class));
        EasyMock.expectLastCall().anyTimes();
    }

    private void setupInterface(OnmsIpInterface iface) {
        EasyMock.expect((Object)this.m_ipIfDao.findByServiceType("SNMP")).andReturn(Collections.singleton(iface));
        EasyMock.expect((Object)this.m_ipIfDao.load((Serializable)iface.getId())).andReturn((Object)iface).atLeastOnce();
    }

    private void setupCollector(String svcName) {
        Collector collector = new Collector();
        collector.setService(svcName);
        collector.setClassName(MockServiceCollector.class.getName());
        MockServiceCollector.setDelegate(this.getCollector());
        EasyMockUtils m_mockUtils = new EasyMockUtils();
        this.m_collectd.setNodeDao((NodeDao)m_mockUtils.createMock(NodeDao.class));
        this.m_collector.initialize(Collections.EMPTY_MAP);
        EasyMock.expect((Object)this.m_collectorConfigDao.getCollectors()).andReturn(Collections.singleton(collector));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockServiceCollector
    implements ServiceCollector {
        private static ServiceCollector s_delegate;

        public static void setDelegate(ServiceCollector delegate) {
            s_delegate = delegate;
        }

        public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) throws CollectionException {
            return s_delegate.collect(agent, eproxy, parameters);
        }

        public void initialize(Map parameters) {
            s_delegate.initialize(parameters);
        }

        public void initialize(CollectionAgent agent, Map parameters) {
            s_delegate.initialize(agent, parameters);
        }

        public void release() {
            s_delegate.release();
        }

        public void release(CollectionAgent agent) {
            s_delegate.release(agent);
        }

        public RrdRepository getRrdRepository(String collectionName) {
            RrdRepository repo = new RrdRepository();
            ArrayList<String> rras = new ArrayList<String>();
            rras.add("RRA:AVERAGE:0.5:1:8928");
            repo.setRrdBaseDir(new File("/usr/local/opennms/share/rrd/snmp/"));
            repo.setRraList(rras);
            repo.setStep(300);
            repo.setHeartBeat(600);
            return repo;
        }
    }
}

