/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.CollectorConfigDao;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockTransactionTemplate;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.support.TransactionTemplate;

public class CollectdIntegrationTest
extends TestCase {
    private static final String TEST_KEY_PARM_NAME = "key";
    private static Map<String, CollectdIntegrationTest> m_tests = new HashMap<String, CollectdIntegrationTest>();
    private MockEventIpcManager m_eventIpcManager;
    private Collectd m_collectd;
    private EasyMockUtils m_mockUtils;
    private CollectorConfigDao m_collectorConfigDao;
    private String m_key;
    private MockServiceCollector m_serviceCollector;
    private IpInterfaceDao m_ifaceDao;
    private NodeDao m_nodeDao;
    private FilterDao m_filterDao;

    protected void setUp() throws Exception {
        this.m_eventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)this.m_eventIpcManager);
        this.m_mockUtils = new EasyMockUtils();
        this.m_filterDao = (FilterDao)this.m_mockUtils.createMock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        ClassPathResource resource = new ClassPathResource("etc/poll-outages.xml");
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)new PollOutagesConfigFactory((Resource)resource));
        File homeDir = resource.getFile().getParentFile().getParentFile();
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
        resource = new ClassPathResource("/test-thresholds.xml");
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory(resource.getInputStream()));
        this.m_key = this.getName() + System.nanoTime();
        m_tests.put(this.m_key, this);
        Collector collector = new Collector();
        collector.setService("SNMP");
        collector.setClassName(MockServiceCollector.class.getName());
        Parameter param = new Parameter();
        param.setKey(TEST_KEY_PARM_NAME);
        param.setValue(this.m_key);
        collector.addParameter(param);
        MockTransactionTemplate transTemplate = new MockTransactionTemplate();
        this.m_collectorConfigDao = (CollectorConfigDao)this.m_mockUtils.createMock(CollectorConfigDao.class);
        EasyMock.expect((Object)this.m_collectorConfigDao.getCollectors()).andReturn(Collections.singleton(collector));
        EasyMock.expect((Object)this.m_collectorConfigDao.getSchedulerThreads()).andReturn((Object)1);
        this.m_ifaceDao = (IpInterfaceDao)this.m_mockUtils.createMock(IpInterfaceDao.class);
        this.m_nodeDao = (NodeDao)this.m_mockUtils.createMock(NodeDao.class);
        this.m_collectd = new Collectd(){

            protected void handleInsufficientInfo(InsufficientInformationException e) {
                Assert.fail((String)("Invalid event received: " + e.getMessage()));
            }
        };
        this.m_collectd.setCollectorConfigDao(this.m_collectorConfigDao);
        this.m_collectd.setEventIpcManager((EventIpcManager)this.m_eventIpcManager);
        this.m_collectd.setTransactionTemplate((TransactionTemplate)transTemplate);
        this.m_collectd.setIpInterfaceDao(this.m_ifaceDao);
        this.m_collectd.setNodeDao(this.m_nodeDao);
    }

    public static void setServiceCollectorInTest(String testKey, MockServiceCollector collector) {
        CollectdIntegrationTest test = m_tests.get(testKey);
        CollectdIntegrationTest.assertNotNull((Object)((Object)test));
        test.setServiceCollector(collector);
    }

    private void setServiceCollector(MockServiceCollector collector) {
        this.m_serviceCollector = collector;
    }

    protected void tearDown() throws Exception {
        m_tests.remove(this.m_key);
    }

    public void testIt() throws InterruptedException {
        OnmsServiceType snmp = new OnmsServiceType("SNMP");
        NetworkBuilder netBuilder = new NetworkBuilder("localhost", "127.0.0.1");
        NetworkBuilder.NodeBuilder nodeBuilder = netBuilder.addNode("node1").setId(Integer.valueOf(1));
        NetworkBuilder.InterfaceBuilder ifaceBlder = netBuilder.addInterface("192.168.1.1").setId(2).setIsSnmpPrimary("P");
        ifaceBlder.addSnmpInterface("192.168.1.1", 1);
        OnmsMonitoredService svc = netBuilder.addService(snmp);
        Set initialIfs = Collections.emptySet();
        EasyMock.expect((Object)this.m_ifaceDao.findByServiceType(snmp.getName())).andReturn(initialIfs);
        this.m_collectorConfigDao.rebuildPackageIpListMap();
        EasyMock.expect((Object)this.m_nodeDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)nodeBuilder.getNode()).anyTimes();
        this.createGetPackagesExpectation(svc);
        EasyMock.expect((Object)this.m_ifaceDao.load((Serializable)Integer.valueOf(2))).andReturn((Object)ifaceBlder.getInterface()).anyTimes();
        this.m_mockUtils.replayAll();
        this.m_collectd.init();
        this.m_collectd.start();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedService", "Test");
        bldr.setNodeid(1);
        bldr.setInterface("192.168.1.1");
        bldr.setService("SNMP");
        this.m_collectd.onEvent(bldr.getEvent());
        Thread.sleep(2000L);
        CollectdIntegrationTest.assertNotNull((Object)this.m_serviceCollector);
        CollectdIntegrationTest.assertEquals((Object)1, (Object)this.m_serviceCollector.getCollectCount());
        this.m_mockUtils.verifyAll();
    }

    private void createGetPackagesExpectation(OnmsMonitoredService svc) {
        String rule = "ipaddr = '" + svc.getIpAddress() + "'";
        EasyMock.expect((Object)this.m_filterDao.getIPList(rule)).andReturn(Collections.singletonList(svc.getIpAddress()));
        final Package pkg = new Package();
        pkg.setName("testPackage");
        Filter filter = new Filter();
        filter.setContent(rule);
        pkg.setFilter(filter);
        Service collector = new Service();
        collector.setName("SNMP");
        collector.setStatus("on");
        collector.setInterval(3000L);
        Parameter parm = new Parameter();
        parm.setKey(TEST_KEY_PARM_NAME);
        parm.setValue(this.m_key);
        collector.setParameter(Collections.singletonList(parm));
        pkg.addService(collector);
        EasyMock.expect((Object)this.m_collectorConfigDao.getPackages()).andAnswer((IAnswer)new IAnswer<Collection<CollectdPackage>>(){

            public Collection<CollectdPackage> answer() throws Throwable {
                CollectdPackage cPkg = new CollectdPackage(pkg, "localhost", false);
                return Collections.singleton(cPkg);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockServiceCollector
    implements ServiceCollector {
        int m_collectCount = 0;

        public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) {
            ++this.m_collectCount;
            CollectionSet collectionSetResult = new CollectionSet(){

                public int getStatus() {
                    return 1;
                }

                public void visit(CollectionSetVisitor visitor) {
                    visitor.visitCollectionSet((CollectionSet)this);
                    visitor.completeCollectionSet((CollectionSet)this);
                }

                public boolean ignorePersist() {
                    return false;
                }
            };
            return collectionSetResult;
        }

        public Object getCollectCount() {
            return this.m_collectCount;
        }

        public void initialize(Map parameters) {
        }

        public void initialize(CollectionAgent agent, Map parameters) {
            String testKey = (String)parameters.get(CollectdIntegrationTest.TEST_KEY_PARM_NAME);
            Assert.assertNotNull((Object)testKey);
            CollectdIntegrationTest.setServiceCollectorInTest(testKey, this);
        }

        public void release() {
            throw new UnsupportedOperationException("MockServiceCollector.release is not yet implemented");
        }

        public void release(CollectionAgent agent) {
            throw new UnsupportedOperationException("MockServiceCollector.release is not yet implemented");
        }

        public RrdRepository getRrdRepository(String collectionName) {
            RrdRepository repo = new RrdRepository();
            ArrayList<String> rras = new ArrayList<String>();
            rras.add("RRA:AVERAGE:0.5:1:8928");
            repo.setRrdBaseDir(new File("/usr/local/opennms/share/rrd/snmp/"));
            repo.setRraList(rras);
            repo.setStep(300);
            repo.setHeartBeat(600);
            return repo;
        }
    }
}

