/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import junit.framework.TestCase;
import org.opennms.netmgt.capsd.plugins.FtpPlugin;

public class FtpPluginTest
extends TestCase {
    private FtpPlugin m_plugin = new FtpPlugin();
    private ServerSocket m_serverSocket = null;
    private Thread m_serverThread = null;
    private static int TIMEOUT = 2000;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_serverSocket = new ServerSocket();
        this.m_serverSocket.bind(null);
    }

    protected void tearDown() throws Exception {
        if (this.m_serverSocket != null && !this.m_serverSocket.isClosed()) {
            this.m_serverSocket.close();
        }
        if (this.m_serverThread != null) {
            this.m_serverThread.join(1500L);
        }
        super.tearDown();
    }

    public void SKIPtestOpennmsOrgFtpSuccess() throws Exception {
        FtpPluginTest.assertTrue((String)"Test for protocol FTP on ftp.opennms.org should have passed", (boolean)this.m_plugin.isProtocolSupported(InetAddress.getByName("ftp.opennms.org")));
    }

    public void SKIPtestRandomFtpFailure() throws Exception {
        FtpPluginTest.assertFalse((String)"Test for protocol FTP on 1.1.1.1 should have failed (on most networks, at least)", (boolean)this.m_plugin.isProtocolSupported(InetAddress.getByName("1.1.1.1")));
    }

    public void testSuccess() throws Exception {
        Thread m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FtpPluginTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = FtpPluginTest.this.m_serverSocket.accept();
                    s.getOutputStream().write("220 Hello!!!\r\n".getBytes());
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    if (command.equals("QUIT")) {
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        m_serverThread.start();
        FtpPluginTest.assertTrue((String)"Test for protocol FTP should have passed", (boolean)this.doCheck());
    }

    public void testSuccessMultiLineResponse() throws Exception {
        Thread m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FtpPluginTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = FtpPluginTest.this.m_serverSocket.accept();
                    s.getOutputStream().write("220-Hello!!!\r\n".getBytes());
                    s.getOutputStream().write("How are you?\r\n".getBytes());
                    s.getOutputStream().write("220 Nice weather we're having.\r\n".getBytes());
                    s.getOutputStream().flush();
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    if (command.equals("QUIT")) {
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        m_serverThread.start();
        FtpPluginTest.assertTrue((String)"Test for protocol FTP should have passed", (boolean)this.doCheck());
    }

    public void testFailureWithBogusResponse() throws Exception {
        Thread m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FtpPluginTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = FtpPluginTest.this.m_serverSocket.accept();
                    s.getOutputStream().write("Go away!".getBytes());
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        }, ((Object)((Object)this)).getClass().getSimpleName() + "-serverThread");
        m_serverThread.start();
        FtpPluginTest.assertFalse((String)"Test for protocol FTP should have failed", (boolean)this.doCheck());
    }

    public void testMonitorFailureWithNoResponse() throws Exception {
        Thread m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FtpPluginTest.this.m_serverSocket.setSoTimeout(1000);
                    FtpPluginTest.this.m_serverSocket.accept();
                    Thread.sleep(TIMEOUT);
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        }, ((Object)((Object)this)).getClass().getSimpleName() + "-serverThread");
        m_serverThread.start();
        FtpPluginTest.assertFalse((String)"Test for protocol FTP should have failed", (boolean)this.doCheck());
    }

    public void testMonitorFailureWithClosedPort() throws Exception {
        this.m_serverSocket.close();
        FtpPluginTest.assertFalse((String)"Test for protocol FTP should have failed", (boolean)this.doCheck());
    }

    private boolean doCheck() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("port", this.m_serverSocket.getLocalPort());
        m.put("retries", 0);
        m.put("timeout", TIMEOUT);
        return this.m_plugin.isProtocolSupported(this.m_serverSocket.getInetAddress(), m);
    }
}

