/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.spring.xmlrpc;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.opennms.core.utils.ThreadCategory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.remoting.support.RemoteExporter;

public class XmlRpcServiceExporter
extends RemoteExporter
implements InitializingBean,
DisposableBean,
XmlRpcHandler {
    private WebServer webServer;
    private Object proxy;
    private String serviceName;

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.webServer == null) {
            throw new IllegalArgumentException("webServer is required");
        }
        this.checkService();
        this.checkServiceInterface();
        this.proxy = this.getProxyForService();
        if (this.serviceName == null || "".equals(this.serviceName)) {
            this.webServer.addHandler("$default", (Object)this);
        } else {
            this.webServer.addHandler(this.serviceName, (Object)this);
        }
    }

    public void destroy() throws Exception {
        if (this.serviceName == null || "".equals(this.serviceName)) {
            this.webServer.removeHandler("$default");
        } else {
            this.webServer.removeHandler(this.serviceName);
        }
    }

    public Object execute(String method, Vector params) throws Exception {
        this.log().debug("calling: " + method + '(' + this.toArgList(params) + ')');
        ArgumentConvertingMethodInvoker invoker = new ArgumentConvertingMethodInvoker();
        invoker.setTargetObject(this.proxy);
        invoker.setTargetMethod(this.getMethodName(method));
        invoker.setArguments(params.toArray());
        invoker.prepare();
        try {
            Cloneable returnValue = invoker.invoke();
            if (returnValue == null && invoker.getPreparedMethod().getReturnType() == Void.TYPE) {
                returnValue = "void";
            } else if (returnValue instanceof Map && !(returnValue instanceof Hashtable)) {
                returnValue = new Hashtable(returnValue);
            } else if (returnValue instanceof Collection && !(returnValue instanceof Vector)) {
                returnValue = new Vector((Collection)((Object)returnValue));
            }
            this.log().debug("returning from: " + method + '(' + this.toArgList(params) + ") result = " + returnValue);
            return returnValue;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IllegalArgumentException) {
                throw new MsgPreservingXmlRpcException(1, targetException.getMessage());
            }
            if (targetException instanceof MalformedURLException) {
                throw new MsgPreservingXmlRpcException(2, targetException.getMessage());
            }
            if (targetException instanceof Exception && targetException.toString() != null) {
                throw (Exception)targetException;
            }
            String msg = targetException.toString();
            if (msg == null) {
                msg = targetException.getClass().getName();
            }
            Exception ex = new Exception(msg, targetException);
            ex.setStackTrace(targetException.getStackTrace());
            throw ex;
        }
    }

    private String toArgList(Vector params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(params.get(i));
        }
        return sb.toString();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    private String getMethodName(String method) {
        if (this.serviceName == null || "".equals(this.serviceName)) {
            return method;
        }
        return method.substring(this.serviceName.length());
    }

    public static class MsgPreservingXmlRpcException
    extends XmlRpcException {
        public MsgPreservingXmlRpcException(int code, String message) {
            super(code, message);
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

