/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public final class XmlrpcUtil {
    public static void createAndSendXmlrpcNotificationEvent(long txNo, String sourceUei, String message, int status, String generator) {
        ThreadCategory log = ThreadCategory.getInstance((String)"XmlrpcUtil");
        if (log.isDebugEnabled()) {
            log.debug("createAndSendXmlrpcNotificationEvent:  txNo= " + txNo + "\n" + " uei = " + sourceUei + "\n" + " message = " + message + "\n" + " status = " + status);
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/xmlrpcNotification");
        newEvent.setSource(generator);
        String hostAddress = null;
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhE) {
            hostAddress = "localhost";
            log.warn("createAndSendXmlrpcNotificationEvent: Could not lookup the host name for  the local host machine, address set to localhost", (Throwable)uhE);
        }
        newEvent.setHost(hostAddress);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("sourceUei");
        parmValue = new Value();
        parmValue.setContent(new String(sourceUei));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("eventMessage");
        parmValue = new Value();
        parmValue.setContent(new String(message));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("eventStatus");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(status));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
            if (log.isDebugEnabled()) {
                log.debug("createdAndSendXmlrpcNotificationEvent: successfully sent XMLRPC notification event for txno: " + txNo + " / " + sourceUei + " " + status);
            }
        }
        catch (Throwable t) {
            log.warn("run: unexpected throwable exception caught during send to middleware", t);
            int failureFlag = 2;
            eventParms.removeParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("eventStatus");
            parmValue = new Value();
            parmValue.setContent(String.valueOf(failureFlag));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            newEvent.setParms(eventParms);
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
                if (log.isDebugEnabled()) {
                    log.debug("createdAndSendXmlrpcNotificationEvent: successfully sent XMLRPC notification event for txno: " + txNo + " / " + sourceUei + " " + failureFlag);
                }
            }
            catch (Throwable te) {
                log.warn("run: unexpected throwable exception caught during send to middleware", te);
            }
        }
    }
}

