/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.math.BigInteger;
import org.opennms.core.utils.Base64;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public class EventConstants {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_SNMP_OCTET_STRING = "OctetString";
    public static final String TYPE_SNMP_INT32 = "Int32";
    public static final String TYPE_SNMP_NULL = "Null";
    public static final String TYPE_SNMP_OBJECT_IDENTIFIER = "ObjectIdentifier";
    public static final String TYPE_SNMP_IPADDRESS = "IpAddress";
    public static final String TYPE_SNMP_TIMETICKS = "TimeTicks";
    public static final String TYPE_SNMP_COUNTER32 = "Counter32";
    public static final String TYPE_SNMP_GAUGE32 = "Gauge32";
    public static final String TYPE_SNMP_OPAQUE = "Opaque";
    public static final String TYPE_SNMP_SEQUENCE = "Sequence";
    public static final String TYPE_SNMP_COUNTER64 = "Counter64";
    public static final String XML_ENCODING_TEXT = "text";
    public static final String XML_ENCODING_BASE64 = "base64";
    public static final SnmpObjId OID_SNMP_IFINDEX = SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.1");

    private EventConstants() {
    }

    public static String toString(String encoding, Object value) {
        if (encoding == null || value == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String result = null;
        if (XML_ENCODING_TEXT.equals(encoding)) {
            if (value instanceof String) {
                result = (String)value;
            } else if (value instanceof Number) {
                result = value.toString();
            } else if (value instanceof SnmpValue) {
                result = ((SnmpValue)value).toString();
            }
        } else if (XML_ENCODING_BASE64.equals(encoding)) {
            if (value instanceof String) {
                result = new String(Base64.encodeBase64((byte[])((String)value).getBytes()));
            } else if (value instanceof Number) {
                byte[] ibuf = null;
                ibuf = value instanceof BigInteger ? ((BigInteger)value).toByteArray() : BigInteger.valueOf(((Number)value).longValue()).toByteArray();
                result = new String(Base64.encodeBase64((byte[])ibuf));
            } else if (value instanceof SnmpValue) {
                SnmpValue snmpValue = (SnmpValue)value;
                result = new String(Base64.encodeBase64((byte[])snmpValue.getBytes()));
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("unable to encode " + value + " of type " + value.getClass());
        }
        return result;
    }
}

