/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.HashMap;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorState;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

public class ThresholdEvaluatorRearmingAbsoluteChange
implements ThresholdEvaluator {
    private static final String TYPE = "rearmingAbsoluteChange";

    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold) {
        return new ThresholdEvaluatorStateRearmingAbsoluteChange(threshold);
    }

    public boolean supportsType(String type) {
        return TYPE.equals(type);
    }

    public static class ThresholdEvaluatorStateRearmingAbsoluteChange
    extends AbstractThresholdEvaluatorState {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;
        private double m_lastSample = Double.NaN;
        private double m_previousTriggeringSample = Double.NaN;
        private int m_triggerCount = 0;

        public ThresholdEvaluatorStateRearmingAbsoluteChange(BaseThresholdDefConfigWrapper threshold) {
            Assert.notNull((Object)threshold, (String)"threshold argument cannot be null");
            this.setThresholdConfig(threshold);
        }

        public String getType() {
            return this.getThresholdConfig().getType().toString();
        }

        public void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            Assert.isTrue((boolean)ThresholdEvaluatorRearmingAbsoluteChange.TYPE.equals(thresholdConfig.getType()), (String)("threshold for ds-name '" + thresholdConfig.getDatasourceExpression() + "' has type of '" + thresholdConfig.getType() + "', but this evaluator only supports thresholds with a 'type' value of '" + ThresholdEvaluatorRearmingAbsoluteChange.TYPE + "'"));
            Assert.isTrue((thresholdConfig.getValue() != Double.NaN ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is a number");
            Assert.isTrue((thresholdConfig.getValue() != Double.POSITIVE_INFINITY && thresholdConfig.getValue() != Double.NEGATIVE_INFINITY ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is not positive or negative infinity");
            this.m_thresholdConfig = thresholdConfig;
        }

        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThresholdEvaluatorState.Status evaluate(double dsValue) {
            block6: {
                block5: {
                    try {
                        if (Double.valueOf(this.getPreviousTriggeringSample()).isNaN()) break block5;
                        ++this.m_triggerCount;
                        if (!this.wasTriggered(dsValue) && this.m_triggerCount >= this.getThresholdConfig().getTrigger()) {
                            this.setPreviousTriggeringSample(Double.NaN);
                            this.m_triggerCount = 0;
                            this.log().debug("rearmingAbsoluteChange threshold rearmed, sample value=" + dsValue);
                            ThresholdEvaluatorState.Status status = ThresholdEvaluatorState.Status.RE_ARMED;
                            Object var5_4 = null;
                            this.setLastSample(dsValue);
                            return status;
                        }
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.setLastSample(dsValue);
                        throw throwable;
                    }
                }
                if (!this.wasTriggered(dsValue)) break block6;
                this.setPreviousTriggeringSample(this.getLastSample());
                this.m_triggerCount = 0;
                this.log().debug("rearmingAbsoluteChange threshold triggered, sample value=" + dsValue);
                ThresholdEvaluatorState.Status status = ThresholdEvaluatorState.Status.TRIGGERED;
                Object var5_5 = null;
                this.setLastSample(dsValue);
                return status;
            }
            Object var5_6 = null;
            this.setLastSample(dsValue);
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        private boolean wasTriggered(double dsValue) {
            if (Double.valueOf(dsValue).isNaN()) {
                return false;
            }
            if (Double.valueOf(this.getLastSample()).isNaN()) {
                return false;
            }
            double threshold = Math.abs(this.getLastSample() - dsValue);
            return threshold >= this.getThresholdConfig().getValue();
        }

        public Double getLastSample() {
            return this.m_lastSample;
        }

        public void setLastSample(double lastSample) {
            this.m_lastSample = lastSample;
        }

        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, CollectionResourceWrapper resource) {
            if (status == ThresholdEvaluatorState.Status.TRIGGERED) {
                String uei = this.getThresholdConfig().getTriggeredUEI();
                if (uei == null || "".equals(uei)) {
                    uei = "uei.opennms.org/threshold/rearmingAbsoluteChangeExceeded";
                }
                return this.createBasicEvent(uei, date, dsValue, resource);
            }
            if (status == ThresholdEvaluatorState.Status.RE_ARMED) {
                String uei = this.getThresholdConfig().getRearmedUEI();
                if (uei == null || "".equals(uei)) {
                    uei = "uei.opennms.org/threshold/rearmingAbsoluteChangeRearmed";
                }
                return this.createBasicEvent(uei, date, dsValue, resource);
            }
            return null;
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("previousValue", this.formatValue(this.getPreviousTriggeringSample()));
            params.put("threshold", Double.toString(this.getThresholdConfig().getValue()));
            params.put("trigger", Integer.toString(this.getThresholdConfig().getTrigger()));
            return this.createBasicEvent(uei, date, dsValue, resource, params);
        }

        public double getPreviousTriggeringSample() {
            return this.m_previousTriggeringSample;
        }

        public void setPreviousTriggeringSample(double previousTriggeringSample) {
            this.m_previousTriggeringSample = previousTriggeringSample;
        }

        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateRearmingAbsoluteChange(this.m_thresholdConfig);
        }

        public boolean isTriggered() {
            return this.wasTriggered(this.m_previousTriggeringSample);
        }

        public void clearState() {
            this.m_lastSample = Double.NaN;
            this.m_triggerCount = 0;
            this.setPreviousTriggeringSample(Double.NaN);
        }
    }
}

