/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractThresholdEvaluatorState
implements ThresholdEvaluatorState {
    protected Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource, Map<String, String> additionalParams) {
        String dsLabelValue;
        if (resource == null) {
            resource = new CollectionResourceWrapper(0L, 0, null, null, null, null, null);
        }
        if ((dsLabelValue = resource.getLabelValue(resource.getLabel())) == null) {
            dsLabelValue = "Unknown";
        }
        Event event = new Event();
        event.setUei(uei);
        event.setNodeid((long)resource.getNodeId());
        event.setService(resource.getServiceName());
        event.setInterface(resource.getHostAddress());
        Parms eventParms = new Parms();
        this.addEventParm(eventParms, "label", dsLabelValue);
        if (resource.isAnInterfaceResource()) {
            this.addEventParm(eventParms, "ifLabel", resource.getIfLabel());
            this.addEventParm(eventParms, "ifIndex", resource.getIfIndex());
        }
        event.setSource("OpenNMS.Threshd." + this.getThresholdConfig().getDatasourceExpression());
        try {
            event.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            event.setHost("unresolved.host");
            this.log().warn("Failed to resolve local hostname: " + e, (Throwable)e);
        }
        event.setTime(EventConstants.formatToString((Date)date));
        this.addEventParm(eventParms, "ds", this.getThresholdConfig().getDatasourceExpression());
        this.addEventParm(eventParms, "value", this.formatValue(dsValue));
        this.addEventParm(eventParms, "instance", resource.getInstance() != null ? resource.getInstance() : "null");
        if (additionalParams != null) {
            for (String p : additionalParams.keySet()) {
                this.addEventParm(eventParms, p, additionalParams.get(p));
            }
        }
        event.setParms(eventParms);
        return event;
    }

    protected String formatValue(Double value) {
        String pattern = System.getProperty("org.opennms.threshd.value.decimalformat", "###.##");
        DecimalFormat valueFormatter = new DecimalFormat(pattern);
        return valueFormatter.format(value);
    }

    private void addEventParm(Parms parms, String key, String value) {
        if (value != null) {
            Parm eventParm = new Parm();
            eventParm.setParmName(key);
            Value parmValue = new Value();
            parmValue.setContent(value);
            eventParm.setValue(parmValue);
            parms.addParm(eventParm);
        }
    }

    protected final ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

