/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd.helper;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.opennms.core.utils.Base64;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.scriptd.helper.SnmpTrapHelperException;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;

public class SnmpTrapHelper {
    private static final String SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3.0";
    private static final String SNMP_TRAP_OID = ".1.3.6.1.6.3.1.1.4.1.0";
    private static final String SNMP_TRAP_ADDRESS_OID = ".1.3.6.1.6.3.18.1.3.0";
    private static final String SNMP_TRAP_COMMUNITY_OID = ".1.3.6.1.6.3.18.1.4.0";
    private static final String SNMP_TRAP_ENTERPRISE_OID = ".1.3.6.1.6.3.1.1.4.3.0";
    private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";
    private static final int ENTERPRISE_SPECIFIC = 6;
    private HashMap<String, Object> m_factoryMap = new HashMap();

    public SnmpTrapHelper() {
        this.m_factoryMap.put("OctetString", new SnmpOctetStringFactory());
        this.m_factoryMap.put("Int32", new SnmpInt32Factory());
        this.m_factoryMap.put("Null", new SnmpNullFactory());
        this.m_factoryMap.put("ObjectIdentifier", new SnmpObjectIdFactory());
        this.m_factoryMap.put("IpAddress", new SnmpIPAddressFactory());
        this.m_factoryMap.put("TimeTicks", new SnmpTimeTicksFactory());
        this.m_factoryMap.put("Counter32", new SnmpCounter32Factory());
        this.m_factoryMap.put("Gauge32", new SnmpGauge32Factory());
        this.m_factoryMap.put("Opaque", new SnmpOpaqueFactory());
        this.m_factoryMap.put("Counter64", new SnmpCounter64Factory());
    }

    public void stop() {
    }

    public SnmpV1TrapBuilder createV1Trap(String entId, String agentAddr, int generic, int specific, long timeStamp) throws UnknownHostException {
        SnmpV1TrapBuilder trap = SnmpUtils.getV1TrapBuilder();
        trap.setEnterprise(SnmpObjId.get((String)entId));
        trap.setAgentAddress(InetAddress.getByName(agentAddr));
        trap.setGeneric(generic);
        trap.setSpecific(specific);
        trap.setTimeStamp(timeStamp);
        return trap;
    }

    public SnmpTrapBuilder createV2Trap(String trapOid, String sysUpTime) throws SnmpTrapHelperException {
        SnmpTrapBuilder packet = SnmpUtils.getV2TrapBuilder();
        this.addVarBinding(packet, SNMP_SYSUPTIME_OID, "TimeTicks", sysUpTime);
        this.addVarBinding(packet, SNMP_TRAP_OID, "ObjectIdentifier", trapOid);
        return packet;
    }

    public void addVarBinding(SnmpTrapBuilder trap, String name, String type, String value) throws SnmpTrapHelperException {
        this.addVarBinding(trap, name, type, "text", value);
    }

    public void addVarBinding(SnmpTrapBuilder trap, String name, String type, String encoding, String value) throws SnmpTrapHelperException {
        if (name == null) {
            throw new SnmpTrapHelperException("Name is null");
        }
        VarBindFactory factory = (VarBindFactory)this.m_factoryMap.get(type);
        if (factory == null) {
            throw new SnmpTrapHelperException("Type " + type + " is invalid or not implemented");
        }
        factory.addVarBind(trap, name, encoding, value);
    }

    public void forwardV1Trap(Event event, String destAddr, int destPort) throws SnmpTrapHelperException {
        Snmp snmpInfo = event.getSnmp();
        if (snmpInfo == null) {
            throw new SnmpTrapHelperException("Cannot forward an event with no SNMP info: " + event.getUei());
        }
        String version = snmpInfo.getVersion();
        SnmpV1TrapBuilder trap = SnmpUtils.getV1TrapBuilder();
        if ("v1".equals(version)) {
            InetAddress agentAddress;
            trap.setEnterprise(SnmpObjId.get((String)snmpInfo.getId()));
            try {
                agentAddress = InetAddress.getByName(event.getSnmphost());
            }
            catch (UnknownHostException e) {
                throw new SnmpTrapHelperException("Invalid ip address: " + e.getMessage(), e);
            }
            trap.setAgentAddress(agentAddress);
            trap.setGeneric(snmpInfo.getGeneric());
            trap.setSpecific(snmpInfo.getSpecific());
            trap.setTimeStamp(snmpInfo.getTimeStamp());
            Parm[] parms = event.getParms().getParm();
            for (int i = 0; i < parms.length; ++i) {
                Parm parm = parms[i];
                Value value = parm.getValue();
                try {
                    this.addVarBinding((SnmpTrapBuilder)trap, parm.getParmName(), value.getType(), value.getEncoding(), value.getContent());
                    continue;
                }
                catch (SnmpTrapHelperException e) {
                    throw new SnmpTrapHelperException(e.getMessage() + " in event parm[" + i + "]");
                }
            }
        } else if ("v2".equals(version)) {
            InetAddress agentAddress;
            trap.setEnterprise(SnmpObjId.get((String)snmpInfo.getId()));
            Parm[] parms = event.getParms().getParm();
            String addr = null;
            for (int i = 0; i < parms.length; ++i) {
                Parm parm = parms[i];
                if (!SNMP_TRAP_ADDRESS_OID.equals(parm.getParmName())) continue;
                addr = parm.getValue().getContent();
                break;
            }
            if (addr == null) {
                addr = "0.0.0.0";
            }
            try {
                agentAddress = InetAddress.getByName(addr);
            }
            catch (UnknownHostException e) {
                throw new SnmpTrapHelperException("Invalid ip address: " + e.getMessage(), e);
            }
            trap.setAgentAddress(agentAddress);
            trap.setGeneric(snmpInfo.getGeneric());
            trap.setSpecific(snmpInfo.getSpecific());
            trap.setTimeStamp(snmpInfo.getTimeStamp());
            for (int i = 0; i < parms.length; ++i) {
                Parm parm = parms[i];
                Value value = parm.getValue();
                if ("Counter64".equals(value.getType())) continue;
                try {
                    this.addVarBinding((SnmpTrapBuilder)trap, parm.getParmName(), value.getType(), value.getEncoding(), value.getContent());
                    continue;
                }
                catch (SnmpTrapHelperException e) {
                    throw new SnmpTrapHelperException(e.getMessage() + " in event parm[" + i + "]");
                }
            }
        } else {
            throw new SnmpTrapHelperException("Invalid SNMP version: " + version);
        }
        this.sendTrap(destAddr, destPort, snmpInfo.getCommunity(), (SnmpTrapBuilder)trap);
    }

    private void sendTrap(String destAddr, int destPort, String community, SnmpTrapBuilder trap) throws SnmpTrapHelperException {
        try {
            trap.send(destAddr, destPort, community);
        }
        catch (Exception e) {
            throw new SnmpTrapHelperException("Failed to send trap " + e.getMessage(), e);
        }
    }

    public void forwardV2Trap(Event event, String destAddr, int destPort) throws SnmpTrapHelperException {
        Snmp snmpInfo = event.getSnmp();
        if (snmpInfo == null) {
            throw new SnmpTrapHelperException("Cannot forward an event with no SNMP info: " + event.getUei());
        }
        String version = snmpInfo.getVersion();
        SnmpTrapBuilder packet = SnmpUtils.getV2TrapBuilder();
        if ("v1".equals(version)) {
            this.addVarBinding(packet, SNMP_SYSUPTIME_OID, "TimeTicks", Long.toString(snmpInfo.getTimeStamp()));
            String oid = snmpInfo.getGeneric() == 6 ? snmpInfo.getId() + ".0." + snmpInfo.getSpecific() : ".1.3.6.1.6.3.1.1.5." + (snmpInfo.getGeneric() + 1);
            this.addVarBinding(packet, SNMP_TRAP_OID, "ObjectIdentifier", oid);
            boolean addrPresent = false;
            boolean communityPresent = false;
            boolean enterprisePresent = false;
            Parm[] parms = event.getParms().getParm();
            for (int i = 0; i < parms.length; ++i) {
                Parm parm = parms[i];
                Value value = parm.getValue();
                try {
                    this.addVarBinding(packet, parm.getParmName(), value.getType(), value.getEncoding(), value.getContent());
                }
                catch (SnmpTrapHelperException e) {
                    throw new SnmpTrapHelperException(e.getMessage() + " in event parm[" + i + "]");
                }
                if (SNMP_TRAP_ADDRESS_OID.equals(parm.getParmName())) {
                    addrPresent = true;
                    continue;
                }
                if (SNMP_TRAP_COMMUNITY_OID.equals(parm.getParmName())) {
                    communityPresent = true;
                    continue;
                }
                if (!SNMP_TRAP_ENTERPRISE_OID.equals(parm.getParmName())) continue;
                enterprisePresent = true;
            }
            if (!addrPresent) {
                this.addVarBinding(packet, SNMP_TRAP_ADDRESS_OID, "IpAddress", event.getSnmphost());
            }
            if (!communityPresent) {
                this.addVarBinding(packet, SNMP_TRAP_COMMUNITY_OID, "OctetString", snmpInfo.getCommunity());
            }
            if (!enterprisePresent) {
                this.addVarBinding(packet, SNMP_TRAP_ENTERPRISE_OID, "ObjectIdentifier", snmpInfo.getId());
            }
        } else if ("v2".equals(version)) {
            this.addVarBinding(packet, SNMP_SYSUPTIME_OID, "TimeTicks", Long.toString(snmpInfo.getTimeStamp()));
            String oid = snmpInfo.getGeneric() == 6 ? snmpInfo.getId() + "." + snmpInfo.getSpecific() : ".1.3.6.1.6.3.1.1.5." + (snmpInfo.getGeneric() + 1);
            this.addVarBinding(packet, SNMP_TRAP_OID, "ObjectIdentifier", oid);
            Parm[] parms = event.getParms().getParm();
            for (int i = 0; i < parms.length; ++i) {
                Parm parm = parms[i];
                Value value = parm.getValue();
                try {
                    this.addVarBinding(packet, parm.getParmName(), value.getType(), value.getEncoding(), value.getContent());
                    continue;
                }
                catch (SnmpTrapHelperException e) {
                    throw new SnmpTrapHelperException(e.getMessage() + " in event parm[" + i + "]");
                }
            }
        } else {
            throw new SnmpTrapHelperException("Invalid SNMP version: " + version);
        }
        this.sendTrap(destAddr, destPort, snmpInfo.getCommunity(), packet);
    }

    public void forwardTrap(Event event, String destAddr, int destPort) throws SnmpTrapHelperException {
        Snmp snmpInfo = event.getSnmp();
        if (snmpInfo == null) {
            throw new SnmpTrapHelperException("Cannot forward an event with no SNMP info: " + event.getUei());
        }
        String version = snmpInfo.getVersion();
        if ("v1".equals(version)) {
            this.forwardV1Trap(event, destAddr, destPort);
        } else if ("v2".equals(version)) {
            this.forwardV2Trap(event, destAddr, destPort);
        } else {
            throw new SnmpTrapHelperException("Invalid SNMP version: " + version);
        }
    }

    public void sendTL1AutonomousMsgTrap(Event event, String destAddr, int destPort, String trapVersion, String community) throws SnmpTrapHelperException, UnknownHostException {
        if (!"uei.opennms.org/api/tl1d/message/autonomous".equals(event.getUei())) {
            throw new SnmpTrapHelperException("The event must have a UEI of uei.opennms.org/api/tl1d/message/autonomous");
        }
        SnmpV1TrapBuilder trapBuilder = null;
        long trapTimeStamp = 0L;
        if ("v1".equalsIgnoreCase(trapVersion)) {
            trapBuilder = this.createV1Trap(".1.3.6.1.4.1.5813.1", event.getInterface(), 6, 2, trapTimeStamp);
        } else if ("v2c".equalsIgnoreCase(trapVersion)) {
            trapBuilder = this.createV2Trap(".1.3.6.1.4.1.5813.1.0.2", Long.toString(trapTimeStamp));
        } else {
            throw new SnmpTrapHelperException("The trap SNMP version must be either v1 or v2c");
        }
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.1.8.0", "OctetString", Long.toString(event.getNodeid()));
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.1.9.0", "OctetString", event.getTime());
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.1.10.0", "OctetString", event.getHost());
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.1.11.0", "OctetString", event.getInterface());
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.1.13.0", "OctetString", event.getService());
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.1.18.0", "OctetString", event.getSeverity());
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.2.1.1.0", "OctetString", EventUtil.expandParms("%parm[raw-message]%", event));
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.2.1.2.0", "OctetString", EventUtil.expandParms("%parm[alarm-code]%", event));
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.2.1.3.0", "OctetString", EventUtil.expandParms("%parm[atag]%", event));
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.2.1.4.0", "OctetString", EventUtil.expandParms("%parm[verb]%", event));
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.2.1.5.0", "OctetString", EventUtil.expandParms("%parm[autoblock]%", event));
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.2.1.6.0", "OctetString", EventUtil.expandParms("%parm[aid]%", event));
        this.addVarBinding((SnmpTrapBuilder)trapBuilder, ".1.3.6.1.4.1.5813.20.2.1.7.0", "OctetString", EventUtil.expandParms("%parm[additionalParams]%", event));
        this.sendTrap(destAddr, destPort, community, (SnmpTrapBuilder)trapBuilder);
    }

    private class SnmpCounter64Factory
    implements VarBindFactory {
        private SnmpCounter64Factory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getCounter64(new BigInteger(value)));
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpCounter64");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapHelperException("Value is null for SnmpCounter64");
                }
            } else {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpCounter64");
            }
        }
    }

    private class SnmpOpaqueFactory
    implements VarBindFactory {
        private SnmpOpaqueFactory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if (!"base64".equals(encoding)) {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpOpaque");
            }
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getOpaque(Base64.decodeBase64((char[])value.toCharArray())));
        }
    }

    private class SnmpGauge32Factory
    implements VarBindFactory {
        private SnmpGauge32Factory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getGauge32(Long.parseLong(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpGauge32");
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpGauge32");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapHelperException("Value is null for SnmpGauge32");
                }
            } else {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpGauge32");
            }
        }
    }

    private class SnmpCounter32Factory
    implements VarBindFactory {
        private SnmpCounter32Factory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getCounter32(Long.parseLong(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpCounter32");
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpCounter32");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapHelperException("Value is null for SnmpCounter32");
                }
            } else {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpCounter32");
            }
        }
    }

    private class SnmpTimeTicksFactory
    implements VarBindFactory {
        private SnmpTimeTicksFactory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getTimeTicks(Long.parseLong(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpTimeTicks");
                }
                catch (IllegalArgumentException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpTimeTicks");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapHelperException("Value is null for SnmpTimeTicks");
                }
            } else {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpTimeTicks");
            }
        }
    }

    private class SnmpIPAddressFactory
    implements VarBindFactory {
        private SnmpIPAddressFactory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getIpAddress(InetAddress.getByName(value)));
                }
                catch (UnknownHostException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid, or host unknown for SnmpIPAddress");
                }
            } else {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpIPAddress");
            }
        }
    }

    private class SnmpObjectIdFactory
    implements VarBindFactory {
        private SnmpObjectIdFactory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if (!"text".equals(encoding)) {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpObjectId");
            }
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getObjectId(SnmpObjId.get((String)value)));
        }
    }

    private class SnmpNullFactory
    implements VarBindFactory {
        private SnmpNullFactory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) {
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getNull());
        }
    }

    private class SnmpInt32Factory
    implements VarBindFactory {
        private SnmpInt32Factory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            if ("text".equals(encoding)) {
                try {
                    trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getInt32(Integer.parseInt(value)));
                }
                catch (NumberFormatException e) {
                    throw new SnmpTrapHelperException("Value " + value + "is invalid for SnmpInt32");
                }
                catch (NullPointerException e) {
                    throw new SnmpTrapHelperException("Value is null for SnmpInt32");
                }
            } else {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpInt32");
            }
        }
    }

    private class SnmpOctetStringFactory
    implements VarBindFactory {
        private SnmpOctetStringFactory() {
        }

        public void addVarBind(SnmpTrapBuilder trap, String name, String encoding, String value) throws SnmpTrapHelperException {
            byte[] contents;
            if ("text".equals(encoding)) {
                contents = value.getBytes();
            } else if ("base64".equals(encoding)) {
                contents = Base64.decodeBase64((char[])value.toCharArray());
            } else {
                throw new SnmpTrapHelperException("Encoding " + encoding + "is invalid for SnmpOctetString");
            }
            trap.addVarBind(SnmpObjId.get((String)name), SnmpUtils.getValueFactory().getOctetString(contents));
        }
    }

    private static interface VarBindFactory {
        public void addVarBind(SnmpTrapBuilder var1, String var2, String var3, String var4) throws SnmpTrapHelperException;
    }
}

