/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.scriptd.BroadcastEventProcessor;
import org.opennms.netmgt.scriptd.Executor;
import org.opennms.netmgt.xml.event.Event;

public final class Scriptd
extends AbstractServiceDaemon {
    private static final Scriptd m_singleton = new Scriptd();
    private Executor m_execution = null;
    private BroadcastEventProcessor m_eventReader = null;

    private Scriptd() {
        super("OpenNMS.Scriptd");
    }

    protected void onInit() {
        ScriptdConfigFactory aFactory = null;
        try {
            ScriptdConfigFactory.reload();
            aFactory = ScriptdConfigFactory.getInstance();
        }
        catch (MarshalException ex) {
            this.log().error("Failed to load scriptd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error("Failed to load scriptd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error("Failed to load scriptd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        FifoQueueImpl execQ = new FifoQueueImpl();
        try {
            this.m_eventReader = new BroadcastEventProcessor((FifoQueue<Event>)execQ);
        }
        catch (Exception ex) {
            this.log().error("Failed to setup event reader", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        this.m_execution = new Executor((FifoQueue<Event>)execQ, aFactory);
    }

    protected void onStart() {
        if (this.m_execution == null) {
            this.init();
        }
        this.m_execution.start();
        this.log().info("Scriptd running");
    }

    protected void onStop() {
        try {
            if (this.m_execution != null) {
                this.m_execution.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_eventReader != null) {
            this.m_eventReader.close();
        }
        this.m_eventReader = null;
        this.m_execution = null;
    }

    protected void onPause() {
        this.m_execution.pause();
    }

    protected void onResume() {
        this.m_execution.resume();
    }

    public static Scriptd getInstance() {
        return m_singleton;
    }
}

