/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.utils;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.xml.rtc.EuiLevel;

public class PipedMarshaller {
    private EuiLevel m_objToMarshall;

    public PipedMarshaller(EuiLevel toMarshall) {
        this.m_objToMarshall = toMarshall;
    }

    public Reader getReader() throws IOException {
        MarshalThread m = new MarshalThread(this.m_objToMarshall);
        Thread t = new Thread((Runnable)m, "PipedMarshaller");
        t.start();
        return m.getReader();
    }

    private class MarshalThread
    implements Runnable {
        private PipedWriter m_out;
        private PipedReader m_in;
        private EuiLevel m_obj;

        MarshalThread(EuiLevel inp) throws IOException {
            this.m_obj = inp;
            this.m_out = new PipedWriter();
            this.m_in = new PipedReader(this.m_out);
        }

        public void run() {
            try {
                Marshaller.marshal((Object)this.m_obj, (Writer)this.m_out);
                this.m_out.flush();
                this.m_out.close();
            }
            catch (MarshalException e) {
                ThreadCategory.getInstance(this.getClass()).error("Failed to convert category to xml", (Throwable)e);
                throw new UndeclaredThrowableException(e);
            }
            catch (ValidationException e) {
                ThreadCategory.getInstance(this.getClass()).error("Failed to convert category to xml", (Throwable)e);
                throw new UndeclaredThrowableException(e);
            }
            catch (IOException e) {
                ThreadCategory.getInstance(this.getClass()).warn("Failed to convert category to xml", (Throwable)e);
            }
        }

        Reader getReader() {
            return this.m_in;
        }
    }
}

