/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.Poller;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.netmgt.poller.remote.ServicePollState;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedEvent;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPollerFrontEnd
implements PollerFrontEnd,
InitializingBean,
DisposableBean {
    private State m_state = new Initial();
    private PollerBackEnd m_backEnd;
    private PollerSettings m_pollerSettings;
    private PollService m_pollService;
    private LinkedList<PropertyChangeListener> m_propertyChangeListeners = new LinkedList();
    private LinkedList<ServicePollStateChangedListener> m_servicePollStateChangedListeners = new LinkedList();
    private LinkedList<ConfigurationChangedListener> m_configChangeListeners = new LinkedList();
    private PollerConfiguration m_pollerConfiguration;
    private Map<Integer, ServicePollState> m_pollState = new LinkedHashMap<Integer, ServicePollState>();

    @Override
    public void addConfigurationChangedListener(ConfigurationChangedListener l) {
        this.m_configChangeListeners.addFirst(l);
    }

    public void doResume() {
        this.doLoadConfig();
    }

    public void doPause() {
    }

    public void doDisconnected() {
        this.doLoadConfig();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.addFirst(listener);
    }

    @Override
    public void addServicePollStateChangedListener(ServicePollStateChangedListener listener) {
        this.m_servicePollStateChangedListeners.addFirst(listener);
    }

    public void afterPropertiesSet() throws Exception {
        this.m_state.initialize();
    }

    public void checkConfig() {
        this.m_state.checkIn();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public OnmsLocationMonitor.MonitorStatus doCheckIn() {
        return this.m_backEnd.pollerCheckingIn(this.getMonitorId(), this.getCurrentConfigTimestamp());
    }

    public void doDelete() {
        this.setMonitorId(null);
    }

    public Integer doInitialize() {
        this.assertNotNull(this.m_backEnd, "pollerBackEnd");
        this.assertNotNull(this.m_pollService, "pollService");
        this.assertNotNull(this.m_pollerSettings, "pollerSettings");
        return this.getMonitorId();
    }

    public boolean doPollerStart() {
        if (!this.m_backEnd.pollerStarting(this.getMonitorId(), this.getDetails())) {
            return false;
        }
        this.doLoadConfig();
        return true;
    }

    public void doPollService(Integer polledServiceId) {
        PollStatus result = this.doPoll(polledServiceId);
        if (result == null) {
            return;
        }
        this.updateServicePollState(polledServiceId, result);
        this.m_backEnd.reportResult(this.getMonitorId(), polledServiceId, result);
    }

    public void doRegister(String location) {
        int monitorId = this.m_backEnd.registerLocationMonitor(location);
        this.setMonitorId(monitorId);
        this.doPollerStart();
    }

    public void doStop() {
        this.m_backEnd.pollerStopping(this.getMonitorId());
    }

    public Map<String, String> getDetails() {
        HashMap<String, String> details = new HashMap<String, String>();
        Properties p = System.getProperties();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            if (!e.getKey().toString().startsWith("os.") || e.getValue() == null) continue;
            details.put(e.getKey().toString(), e.getValue().toString());
        }
        try {
            InetAddress us = InetAddress.getLocalHost();
            details.put("org.opennms.netmgt.poller.remote.hostAddress", us.getHostAddress());
            details.put("org.opennms.netmgt.poller.remote.hostName", us.getHostName());
        }
        catch (UnknownHostException e) {
            LogUtils.tracef((Object)this, (Throwable)e, (String)"Unable to determine localhost.", (Object[])new Object[0]);
        }
        return details;
    }

    public Integer getMonitorId() {
        return this.m_pollerSettings.getMonitorId();
    }

    @Override
    public Collection<OnmsMonitoringLocationDefinition> getMonitoringLocations() {
        this.assertInitialized();
        return this.m_backEnd.getMonitoringLocations();
    }

    @Override
    public String getMonitorName() {
        return this.isRegistered() ? this.m_backEnd.getMonitorName(this.getMonitorId()) : "";
    }

    @Override
    public Collection<PolledService> getPolledServices() {
        return Arrays.asList(this.m_pollerConfiguration.getPolledServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServicePollState> getPollerPollState() {
        Map<Integer, ServicePollState> map = this.m_pollState;
        synchronized (map) {
            return new LinkedList<ServicePollState>(this.m_pollState.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServicePollState getServicePollState(int polledServiceId) {
        Map<Integer, ServicePollState> map = this.m_pollState;
        synchronized (map) {
            return this.m_pollState.get(polledServiceId);
        }
    }

    public String getStatus() {
        return this.m_state.toString();
    }

    @Override
    public boolean isRegistered() {
        return this.m_state.isRegistered();
    }

    @Override
    public boolean isStarted() {
        return this.m_state.isStarted();
    }

    @Override
    public void pollService(Integer polledServiceId) {
        this.m_state.pollService(polledServiceId);
    }

    @Override
    public void register(String monitoringLocation) {
        this.m_state.register(monitoringLocation);
    }

    @Override
    public void removeConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.m_configChangeListeners.remove(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.remove(listener);
    }

    @Override
    public void removeServicePollStateChangedListener(ServicePollStateChangedListener listener) {
        this.m_servicePollStateChangedListeners.remove(listener);
    }

    @Override
    public void setInitialPollTime(Integer polledServiceId, Date initialPollTime) {
        ServicePollState pollState = this.getServicePollState(polledServiceId);
        pollState.setInitialPollTime(initialPollTime);
        this.fireServicePollStateChanged(pollState.getPolledService(), pollState.getIndex());
    }

    public void setMonitorId(Integer monitorId) {
        this.m_pollerSettings.setMonitorId(monitorId);
    }

    public void setPollerBackEnd(PollerBackEnd backEnd) {
        this.m_backEnd = backEnd;
    }

    public void setPollerSettings(PollerSettings settings) {
        this.m_pollerSettings = settings;
    }

    public void setPollService(PollService pollService) {
        this.m_pollService = pollService;
    }

    @Override
    public void stop() {
        this.m_state.stop();
    }

    private void assertInitialized() {
        Assert.isTrue((boolean)this.isInitialized(), (String)"afterProperties set has not been called");
    }

    private void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + Poller.class));
    }

    private void assertRegistered() {
        Assert.state((boolean)this.isRegistered(), (String)"The poller must be registered before we can poll or get its configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadConfig() {
        Date oldTime = this.getCurrentConfigTimestamp();
        try {
            this.m_pollService.setServiceMonitorLocators(this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR));
            this.m_pollerConfiguration = this.m_backEnd.getPollerConfiguration(this.getMonitorId());
            Map<Integer, ServicePollState> map = this.m_pollState;
            synchronized (map) {
                int i = 0;
                this.m_pollState.clear();
                for (PolledService service : this.getPolledServices()) {
                    this.m_pollService.initialize(service);
                    this.m_pollState.put(service.getServiceId(), new ServicePollState(service, i++));
                }
            }
            this.fireConfigurationChange(oldTime, this.getCurrentConfigTimestamp());
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to get updated poller configuration.", (Object[])new Object[0]);
        }
    }

    private PollStatus doPoll(Integer polledServiceId) {
        PolledService polledService = this.getPolledService(polledServiceId);
        if (polledService == null) {
            return null;
        }
        PollStatus result = this.m_pollService.poll(polledService);
        return result;
    }

    private void fireConfigurationChange(Date oldTime, Date newTime) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, "configuration", oldTime, newTime);
        for (ConfigurationChangedListener listener : this.m_configChangeListeners) {
            listener.configurationChanged(e);
        }
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.nullSafeEquals(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.m_propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private boolean nullSafeEquals(Object oldValue, Object newValue) {
        return oldValue == newValue ? true : ObjectUtils.nullSafeEquals((Object)oldValue, (Object)newValue);
    }

    private void fireServicePollStateChanged(PolledService polledService, int index) {
        ServicePollStateChangedEvent event = new ServicePollStateChangedEvent(polledService, index);
        for (ServicePollStateChangedListener listener : this.m_servicePollStateChangedListeners) {
            listener.pollStateChange(event);
        }
    }

    private Date getCurrentConfigTimestamp() {
        return this.m_pollerConfiguration == null ? null : this.m_pollerConfiguration.getConfigurationTimestamp();
    }

    private PolledService getPolledService(Integer polledServiceId) {
        ServicePollState servicePollState = this.getServicePollState(polledServiceId);
        return servicePollState == null ? null : servicePollState.getPolledService();
    }

    private boolean isInitialized() {
        return this.m_state.isInitialized();
    }

    private void setState(State newState) {
        boolean started = this.isStarted();
        boolean registered = this.isRegistered();
        boolean paused = this.isPaused();
        boolean disconnected = this.isDisconnected();
        boolean exitNecessary = this.isExitNecessary();
        this.m_state = newState;
        this.firePropertyChange("exitNecessary", exitNecessary, this.isExitNecessary());
        this.firePropertyChange("started", started, this.isStarted());
        this.firePropertyChange("registered", registered, this.isRegistered());
        this.firePropertyChange("paused", paused, this.isPaused());
        this.firePropertyChange("disconnected", disconnected, this.isDisconnected());
    }

    private boolean isDisconnected() {
        return this.m_state.isDisconnected();
    }

    private boolean isPaused() {
        return this.m_state.isPaused();
    }

    @Override
    public boolean isExitNecessary() {
        return this.m_state.isExitNecessary();
    }

    private void updateServicePollState(Integer polledServiceId, PollStatus result) {
        ServicePollState pollState = this.getServicePollState(polledServiceId);
        pollState.setLastPoll(result);
        this.fireServicePollStateChanged(pollState.getPolledService(), pollState.getIndex());
    }

    private abstract class State {
        private State() {
        }

        public void checkIn() {
        }

        public IllegalStateException illegalState(String msg) {
            return new IllegalStateException(msg + " State: " + this);
        }

        public void initialize() {
            throw this.illegalState("Initialize called on invalid state.");
        }

        public boolean isInitialized() {
            return true;
        }

        public boolean isRegistered() {
            return true;
        }

        public boolean isStarted() {
            return false;
        }

        public boolean isPaused() {
            return false;
        }

        public boolean isDisconnected() {
            return false;
        }

        public boolean isExitNecessary() {
            return false;
        }

        public void pollService(Integer serviceId) {
            throw this.illegalState("Cannot poll from this state.");
        }

        public void register(String location) {
            throw this.illegalState("Cannot register from this state.");
        }

        public void stop() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public class FatalExceptionOccurred
    extends State {
        public boolean isExitNecessary() {
            return true;
        }
    }

    public class Running
    extends RunningState {
        public void pollService(Integer polledServiceId) {
            try {
                DefaultPollerFrontEnd.this.doPollService(polledServiceId);
            }
            catch (Exception e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected exception occurred loading the configs.", (Object[])new Object[0]);
                DefaultPollerFrontEnd.this.setState(new FatalExceptionOccurred());
            }
        }

        protected void onConfigChanged() {
            DefaultPollerFrontEnd.this.doLoadConfig();
        }

        protected void onDisconnected() {
            DefaultPollerFrontEnd.this.doDisconnected();
            DefaultPollerFrontEnd.this.setState(new Disconnected());
        }

        protected void onPaused() {
            DefaultPollerFrontEnd.this.doPause();
            DefaultPollerFrontEnd.this.setState(new Paused());
        }
    }

    private class RunningState
    extends State {
        private RunningState() {
        }

        public void pollService(Integer serviceId) {
        }

        public void checkIn() {
            File killSwitch;
            try {
                OnmsLocationMonitor.MonitorStatus status = DefaultPollerFrontEnd.this.doCheckIn();
                switch (status) {
                    case CONFIG_CHANGED: {
                        this.onConfigChanged();
                        break;
                    }
                    case DELETED: {
                        this.onDeleted();
                        break;
                    }
                    case DISCONNECTED: {
                        this.onDisconnected();
                        break;
                    }
                    case PAUSED: {
                        this.onPaused();
                        break;
                    }
                    case STARTED: {
                        this.onStarted();
                    }
                }
            }
            catch (Exception e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected exception occurred loading the configs.", (Object[])new Object[0]);
                DefaultPollerFrontEnd.this.setState(new FatalExceptionOccurred());
            }
            String killSwitchFileName = System.getProperty("opennms.poller.killSwitch.resource");
            if (!"".equals(killSwitchFileName) && killSwitchFileName != null && !(killSwitch = new File(System.getProperty("opennms.poller.killSwitch.resource"))).exists()) {
                LogUtils.infof((Object)this, (String)"Kill-switch file %s does not exist; stopping.", (Object[])new Object[]{killSwitch.getPath()});
                DefaultPollerFrontEnd.this.doStop();
            }
        }

        public boolean isStarted() {
            return true;
        }

        public void stop() {
            try {
                DefaultPollerFrontEnd.this.doStop();
                DefaultPollerFrontEnd.this.setState(new Registering());
            }
            catch (Exception e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected exception occurred loading the configs.", (Object[])new Object[0]);
                DefaultPollerFrontEnd.this.setState(new FatalExceptionOccurred());
            }
        }

        protected void onConfigChanged() {
        }

        protected void onDeleted() {
            DefaultPollerFrontEnd.this.doDelete();
            DefaultPollerFrontEnd.this.setState(new Registering());
        }

        protected void onDisconnected() {
        }

        protected void onPaused() {
        }

        protected void onStarted() {
        }
    }

    private class Registering
    extends State {
        private Registering() {
        }

        public boolean isRegistered() {
            return false;
        }

        public void register(String location) {
            try {
                DefaultPollerFrontEnd.this.doRegister(location);
                DefaultPollerFrontEnd.this.setState(new Running());
            }
            catch (Exception e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to register.", (Object[])new Object[0]);
                DefaultPollerFrontEnd.this.setState(new Disconnected());
            }
        }
    }

    private class Paused
    extends RunningState {
        private Paused() {
        }

        protected void onConfigChanged() {
            DefaultPollerFrontEnd.this.doLoadConfig();
        }

        public boolean isPaused() {
            return true;
        }

        protected void onDisconnected() {
            DefaultPollerFrontEnd.this.doDisconnected();
            DefaultPollerFrontEnd.this.setState(new Disconnected());
        }

        protected void onStarted() {
            DefaultPollerFrontEnd.this.doResume();
            DefaultPollerFrontEnd.this.setState(new Running());
        }
    }

    public class Initial
    extends State {
        public void initialize() {
            try {
                Integer monitorId = DefaultPollerFrontEnd.this.doInitialize();
                if (monitorId == null) {
                    DefaultPollerFrontEnd.this.setState(new Registering());
                } else if (DefaultPollerFrontEnd.this.doPollerStart()) {
                    DefaultPollerFrontEnd.this.setState(new Running());
                } else {
                    DefaultPollerFrontEnd.this.doDelete();
                    DefaultPollerFrontEnd.this.setState(new Registering());
                }
            }
            catch (RuntimeException e) {
                DefaultPollerFrontEnd.this.setState(new FatalExceptionOccurred());
                throw e;
            }
        }

        public boolean isRegistered() {
            return false;
        }
    }

    private class Disconnected
    extends RunningState {
        private Disconnected() {
        }

        public boolean isDisconnected() {
            return true;
        }

        public void stop() {
            DefaultPollerFrontEnd.this.setState(new Registering());
        }

        protected void onConfigChanged() {
            DefaultPollerFrontEnd.this.doLoadConfig();
            DefaultPollerFrontEnd.this.setState(new Running());
        }

        protected void onPaused() {
            DefaultPollerFrontEnd.this.doPause();
            DefaultPollerFrontEnd.this.setState(new Paused());
        }

        protected void onStarted() {
            DefaultPollerFrontEnd.this.doLoadConfig();
            DefaultPollerFrontEnd.this.setState(new Running());
        }
    }
}

