/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.poller.IPv4NetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.remote.OnmsPollModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolledService
implements MonitoredService,
Serializable,
Comparable<PolledService> {
    private static final long serialVersionUID = 2L;
    private IPv4NetworkInterface m_netInterface;
    private Map<String, Object> m_monitorConfiguration;
    private OnmsPollModel m_pollModel;
    private Integer m_serviceId;
    private Integer m_nodeId;
    private String m_nodeLabel;
    private String m_svcName;

    public PolledService(OnmsMonitoredService monitoredService, Map<String, Object> monitorConfiguration, OnmsPollModel pollModel) {
        this.m_serviceId = monitoredService.getId();
        this.m_nodeId = monitoredService.getNodeId();
        this.m_nodeLabel = monitoredService.getIpInterface().getNode().getLabel();
        this.m_svcName = monitoredService.getServiceName();
        this.m_netInterface = new IPv4NetworkInterface(monitoredService.getIpInterface().getInetAddress());
        this.m_monitorConfiguration = monitorConfiguration;
        this.m_pollModel = pollModel;
    }

    public Integer getServiceId() {
        return this.m_serviceId;
    }

    public InetAddress getAddress() {
        return this.m_netInterface.getInetAddress();
    }

    public String getIpAddr() {
        return this.m_netInterface.getInetAddress().getHostAddress();
    }

    public NetworkInterface getNetInterface() {
        return this.m_netInterface;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public String getSvcName() {
        return this.m_svcName;
    }

    public Map<String, Object> getMonitorConfiguration() {
        return this.m_monitorConfiguration;
    }

    public OnmsPollModel getPollModel() {
        return this.m_pollModel;
    }

    public String toString() {
        return this.getNodeId() + ":" + this.getIpAddr() + ":" + this.getSvcName();
    }

    @Override
    public int compareTo(PolledService that) {
        if (that == null) {
            return -1;
        }
        return new CompareToBuilder().append((Object)this.getNodeLabel(), (Object)that.getNodeLabel()).append((Object)this.getIpAddr(), (Object)that.getIpAddr()).append(this.getNodeId(), that.getNodeId()).append((Object)this.getSvcName(), (Object)that.getSvcName()).append((Object)this.getServiceId(), (Object)that.getServiceId()).toComparison();
    }
}

