/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Scope {
    SERVICE,
    INTERFACE,
    NODE,
    NETWORK;


    public static Scope fromUei(String uei) {
        if ("uei.opennms.org/nodes/nodeDown".equals(uei)) {
            return NODE;
        }
        if ("uei.opennms.org/nodes/interfaceDown".equals(uei)) {
            return INTERFACE;
        }
        if ("uei.opennms.org/nodes/nodeLostService".equals(uei)) {
            return SERVICE;
        }
        return null;
    }

    public boolean isLargerThan(Scope s) {
        if (s == null) {
            return true;
        }
        return this.ordinal() > s.ordinal();
    }

    public boolean isSmallerThan(Scope s) {
        if (s == null) {
            return false;
        }
        return this.ordinal() < s.ordinal();
    }

    public static boolean isLargerThan(Scope a, Scope b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return true;
        }
        return a.isLargerThan(b);
    }

    public static boolean isSmallerThan(Scope a, Scope b) {
        return a != b && !Scope.isLargerThan(a, b);
    }
}

